/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;

public class PatchConfig
extends ScimObjectNode {
    public PatchConfig(Boolean supported, Boolean ignoreUnknownAttributes, Boolean activateSailsPointWorkaround, Boolean activateMsAzureWorkaround, Boolean activateMsAzureValueSubAttributeWorkaround, Boolean msAzureComplexSimpleValueWorkaroundActive) {
        super(null);
        this.setSupported(supported);
        this.setIgnoreUnknownAttribute(ignoreUnknownAttributes);
        this.setActivateSailsPointWorkaround(activateSailsPointWorkaround);
        this.setMsAzureFilterWorkaroundActive(activateMsAzureWorkaround);
        this.setMsAzureValueSubAttributeWorkaroundActive(activateMsAzureValueSubAttributeWorkaround);
        this.setMsAzureComplexSimpleValueWorkaroundActive(msAzureComplexSimpleValueWorkaroundActive);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public boolean isIgnoreUnknownAttribute() {
        return this.getBooleanAttribute("ignoreUnknownAttributes").orElse(false);
    }

    public void setIgnoreUnknownAttribute(Boolean ignoreUnknownAttribute) {
        this.setAttribute("ignoreUnknownAttributes", ignoreUnknownAttribute);
    }

    public boolean isActivateSailsPointWorkaround() {
        return this.getBooleanAttribute("activateSailsPointWorkaround").orElse(false);
    }

    public void setActivateSailsPointWorkaround(Boolean activateSailsPointWorkaround) {
        this.setAttribute("activateSailsPointWorkaround", activateSailsPointWorkaround);
    }

    public boolean isMsAzureFilterWorkaroundActive() {
        return this.getBooleanAttribute("activateMsAzureFilterWorkaround").orElse(false);
    }

    public void setMsAzureFilterWorkaroundActive(Boolean msAzureWorkaroundActive) {
        this.setAttribute("activateMsAzureFilterWorkaround", msAzureWorkaroundActive);
    }

    public boolean isMsAzureValueSubAttributeWorkaroundActive() {
        return this.getBooleanAttribute("activateMsAzureValueSubAttributeWorkaround").orElse(false);
    }

    public void setMsAzureValueSubAttributeWorkaroundActive(Boolean msAzureValueSubAttributeWorkaroundActive) {
        this.setAttribute("activateMsAzureValueSubAttributeWorkaround", msAzureValueSubAttributeWorkaroundActive);
    }

    public boolean isMsAzureComplexSimpleValueWorkaroundActive() {
        return this.getBooleanAttribute("activateMsAzureComplexSimpleValueWorkaround").orElse(false);
    }

    public void setMsAzureComplexSimpleValueWorkaroundActive(Boolean msAzureComplexSimpleValueWorkaroundActive) {
        this.setAttribute("activateMsAzureComplexSimpleValueWorkaround", msAzureComplexSimpleValueWorkaroundActive);
    }

    public static PatchConfigBuilder builder() {
        return new PatchConfigBuilder();
    }

    public PatchConfig() {
    }

    public static class PatchConfigBuilder {
        private Boolean supported;
        private Boolean ignoreUnknownAttributes;
        private Boolean activateSailsPointWorkaround;
        private Boolean activateMsAzureWorkaround;
        private Boolean activateMsAzureValueSubAttributeWorkaround;
        private Boolean msAzureComplexSimpleValueWorkaroundActive;

        public PatchConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public PatchConfigBuilder ignoreUnknownAttributes(Boolean ignoreUnknownAttributes) {
            this.ignoreUnknownAttributes = ignoreUnknownAttributes;
            return this;
        }

        public PatchConfigBuilder activateSailsPointWorkaround(Boolean activateSailsPointWorkaround) {
            this.activateSailsPointWorkaround = activateSailsPointWorkaround;
            return this;
        }

        public PatchConfigBuilder activateMsAzureWorkaround(Boolean activateMsAzureWorkaround) {
            this.activateMsAzureWorkaround = activateMsAzureWorkaround;
            return this;
        }

        public PatchConfigBuilder activateMsAzureValueSubAttributeWorkaround(Boolean activateMsAzureValueSubAttributeWorkaround) {
            this.activateMsAzureValueSubAttributeWorkaround = activateMsAzureValueSubAttributeWorkaround;
            return this;
        }

        public PatchConfigBuilder msAzureComplexSimpleValueWorkaroundActive(Boolean msAzureComplexSimpleValueWorkaroundActive) {
            this.msAzureComplexSimpleValueWorkaroundActive = msAzureComplexSimpleValueWorkaroundActive;
            return this;
        }

        public PatchConfig build() {
            return new PatchConfig(this.supported, this.ignoreUnknownAttributes, this.activateSailsPointWorkaround, this.activateMsAzureWorkaround, this.activateMsAzureValueSubAttributeWorkaround, this.msAzureComplexSimpleValueWorkaroundActive);
        }

        public String toString() {
            return "PatchConfig.PatchConfigBuilder(supported=" + this.supported + ", ignoreUnknownAttributes=" + this.ignoreUnknownAttributes + ", activateSailsPointWorkaround=" + this.activateSailsPointWorkaround + ", activateMsAzureWorkaround=" + this.activateMsAzureWorkaround + ", activateMsAzureValueSubAttributeWorkaround=" + this.activateMsAzureValueSubAttributeWorkaround + ", msAzureComplexSimpleValueWorkaroundActive=" + this.msAzureComplexSimpleValueWorkaroundActive + ")";
        }
    }
}

