// Generated by delombok at Fri Nov 17 17:08:50 CET 2023
package de.captaingoldfish.scim.sdk.common.constants.enums;

import org.apache.commons.lang3.StringUtils;
import de.captaingoldfish.scim.sdk.common.constants.HttpStatus;
import de.captaingoldfish.scim.sdk.common.constants.ScimType;
import de.captaingoldfish.scim.sdk.common.exceptions.UnknownValueException;


/**
 * author Pascal Knueppel <br>
 * created at: 29.10.2019 - 08:37 <br>
 * <br>
 * HTTP PATCH is an OPTIONAL server function that enables clients to update one or more attributes of a SCIM
 * resource using a sequence of operations to "add", "remove", or "replace" values.Clients may discover
 * service provider support for PATCH by querying the service provider configuration
 */
public enum PatchOp
{

  ADD("add"), REPLACE("replace"), REMOVE("remove");

  private String value;

  PatchOp(String value)
  {
    this.value = value;
  }

  public static PatchOp getByValue(String value)
  {
    for ( PatchOp patchOp : PatchOp.values() )
    {
      if (StringUtils.equalsIgnoreCase(value, patchOp.getValue()))
      {
        return patchOp;
      }
    }
    throw new UnknownValueException("the value \'" + value + "\' is not a valid patch operation", null,
                                    HttpStatus.BAD_REQUEST, ScimType.Custom.INVALID_PARAMETERS);
  }

  @java.lang.SuppressWarnings("all")
  public String getValue()
  {
    return this.value;
  }
}
