/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;
import lombok.Generated;

public class BulkConfig
extends ScimObjectNode {
    protected static final Integer DEFAULT_MAX_OPERATIONS = 1;
    protected static final Long DEFAULT_MAX_PAYLOAD_SIZE = (long)(Math.pow(1024.0, 2.0) * 2.0);

    public BulkConfig() {
        this.setSupported(false);
    }

    public BulkConfig(Boolean supported, Integer maxOperations, Long maxPayloadSize, Boolean returnResourcesEnabled, Boolean returnResourcesByDefault, Boolean supportBulkGet) {
        super(null);
        this.setSupported(Optional.ofNullable(supported).orElse(false));
        this.setMaxOperations(maxOperations);
        this.setMaxPayloadSize(maxPayloadSize);
        this.setReturnResourcesEnabled(returnResourcesEnabled);
        this.setReturnResourcesByDefault(returnResourcesByDefault);
        this.setSupportBulkGet(supportBulkGet);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public Integer getMaxOperations() {
        return this.getLongAttribute("maxOperations").orElse((long)DEFAULT_MAX_OPERATIONS).intValue();
    }

    public void setMaxOperations(Integer maxOperations) {
        Long max = maxOperations == null ? null : Long.valueOf(maxOperations.intValue());
        this.setAttribute("maxOperations", Optional.ofNullable(max).orElse((long)DEFAULT_MAX_OPERATIONS));
    }

    public Long getMaxPayloadSize() {
        return this.getLongAttribute("maxPayloadSize").orElse(DEFAULT_MAX_PAYLOAD_SIZE);
    }

    public void setMaxPayloadSize(Long maxPayloadSize) {
        this.setAttribute("maxPayloadSize", Optional.ofNullable(maxPayloadSize).orElse(DEFAULT_MAX_PAYLOAD_SIZE));
    }

    public boolean isReturnResourcesEnabled() {
        return this.getBooleanAttribute("returnResourcesEnabled").orElse(false);
    }

    public void setReturnResourcesEnabled(Boolean returnResourcesEnabled) {
        this.setAttribute("returnResourcesEnabled", Optional.ofNullable(returnResourcesEnabled).orElse(false));
    }

    public boolean isReturnResourcesByDefault() {
        return this.isReturnResourcesEnabled() && this.getBooleanAttribute("returnResourcesByDefault").orElse(false) != false;
    }

    public void setReturnResourcesByDefault(Boolean returnResourcesByDefault) {
        boolean effectiveValue = Optional.ofNullable(returnResourcesByDefault).orElse(false);
        if (effectiveValue) {
            this.setReturnResourcesEnabled(true);
        }
        this.setAttribute("returnResourcesByDefault", effectiveValue);
    }

    public boolean isSupportBulkGet() {
        return this.isReturnResourcesEnabled() && this.getBooleanAttribute("supportBulkGet").orElse(false) != false;
    }

    public void setSupportBulkGet(Boolean supportBulkGet) {
        boolean effectiveValue = Optional.ofNullable(supportBulkGet).orElse(false);
        if (effectiveValue) {
            this.setReturnResourcesEnabled(true);
        }
        this.setAttribute("supportBulkGet", effectiveValue);
    }

    @Generated
    public static BulkConfigBuilder builder() {
        return new BulkConfigBuilder();
    }

    public static class BulkConfigBuilder {
        @Generated
        private Boolean supported;
        @Generated
        private Integer maxOperations;
        @Generated
        private Long maxPayloadSize;
        @Generated
        private Boolean returnResourcesEnabled;
        @Generated
        private Boolean returnResourcesByDefault;
        @Generated
        private Boolean supportBulkGet;

        @Generated
        public BulkConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        @Generated
        public BulkConfigBuilder maxOperations(Integer maxOperations) {
            this.maxOperations = maxOperations;
            return this;
        }

        @Generated
        public BulkConfigBuilder maxPayloadSize(Long maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        @Generated
        public BulkConfigBuilder returnResourcesEnabled(Boolean returnResourcesEnabled) {
            this.returnResourcesEnabled = returnResourcesEnabled;
            return this;
        }

        @Generated
        public BulkConfigBuilder returnResourcesByDefault(Boolean returnResourcesByDefault) {
            this.returnResourcesByDefault = returnResourcesByDefault;
            return this;
        }

        @Generated
        public BulkConfigBuilder supportBulkGet(Boolean supportBulkGet) {
            this.supportBulkGet = supportBulkGet;
            return this;
        }

        @Generated
        public BulkConfig build() {
            return new BulkConfig(this.supported, this.maxOperations, this.maxPayloadSize, this.returnResourcesEnabled, this.returnResourcesByDefault, this.supportBulkGet);
        }

        @Generated
        public String toString() {
            return "BulkConfig.BulkConfigBuilder(supported=" + this.supported + ", maxOperations=" + this.maxOperations + ", maxPayloadSize=" + this.maxPayloadSize + ", returnResourcesEnabled=" + this.returnResourcesEnabled + ", returnResourcesByDefault=" + this.returnResourcesByDefault + ", supportBulkGet=" + this.supportBulkGet + ")";
        }
    }
}

