/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ResourceComparator {
    private final Schema mainSchema;
    private final List<Schema> extensions;
    private final List<SchemaAttribute> attributes;
    private final AttributeHandlingType attributeHandlingType;

    public ResourceComparator(Schema mainSchema, List<Schema> extensions, List<SchemaAttribute> attributes, AttributeHandlingType attributeHandlingType) {
        this.mainSchema = Objects.requireNonNull(mainSchema);
        this.extensions = Optional.ofNullable(extensions).orElseGet(Collections::emptyList);
        this.attributes = Optional.ofNullable(attributes).map(ArrayList::new).orElseGet(ArrayList::new);
        this.attributeHandlingType = Optional.ofNullable(attributeHandlingType).orElse(AttributeHandlingType.EXCLUDE);
    }

    public void addAttributes(SchemaAttribute schemaAttribute, SchemaAttribute ... schemaAttributes) {
        this.attributes.add(schemaAttribute);
        Optional.ofNullable(schemaAttributes).ifPresent(attributeArray -> {
            for (SchemaAttribute attribute : attributeArray) {
                this.attributes.add(attribute);
            }
        });
    }

    public boolean equals(ObjectNode resource1, ObjectNode resource2) {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return JsonHelper.isEqual((JsonNode)resource1, (JsonNode)resource2);
        }
        if (resource1 == null && resource2 == null) {
            return true;
        }
        if (resource1 == null) {
            return false;
        }
        if (resource2 == null) {
            return false;
        }
        HashSet<SchemaAttribute> attributesToCheck = AttributeHandlingType.EXCLUDE.equals((Object)this.attributeHandlingType) ? new HashSet<SchemaAttribute>(this.mainSchema.getAttributes()) : this.attributes.stream().filter(s -> s.getSchema() == this.mainSchema).map(s -> s.getParent() == null ? s : s.getParent()).collect(Collectors.toSet());
        for (SchemaAttribute mainSchemaAttribute : attributesToCheck) {
            JsonNode node2;
            JsonNode node1;
            boolean isEqual = this.compareNodes(mainSchemaAttribute, node1 = resource1.get(mainSchemaAttribute.getName()), node2 = resource2.get(mainSchemaAttribute.getName()));
            if (isEqual) continue;
            return false;
        }
        for (Schema extension : this.extensions) {
            JsonNode extensionResource2;
            JsonNode extensionResource1 = resource1.get(extension.getNonNullId());
            if (extensionResource1 == null) {
                extensionResource1 = resource1;
            }
            if ((extensionResource2 = resource2.get(extension.getNonNullId())) == null) {
                extensionResource2 = resource2;
            }
            attributesToCheck = AttributeHandlingType.EXCLUDE.equals((Object)this.attributeHandlingType) ? new HashSet<SchemaAttribute>(extension.getAttributes()) : this.attributes.stream().filter(s -> s.getSchema() == extension).map(s -> s.getParent() == null ? s : s.getParent()).collect(Collectors.toSet());
            for (SchemaAttribute extensionSchemaAttribute : attributesToCheck) {
                JsonNode node2;
                JsonNode node1;
                boolean isEqual = this.compareNodes(extensionSchemaAttribute, node1 = extensionResource1.get(extensionSchemaAttribute.getName()), node2 = extensionResource2.get(extensionSchemaAttribute.getName()));
                if (isEqual) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compareNodes(SchemaAttribute schemaAttribute, JsonNode node1, JsonNode node2) {
        boolean ignoreAttribute = this.ignoreAttribute(schemaAttribute);
        if (ignoreAttribute) {
            return true;
        }
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null) {
            return false;
        }
        if (node2 == null) {
            return false;
        }
        if (schemaAttribute.isMultivaluedComplexAttribute()) {
            boolean node1IsArray = node1 instanceof ArrayNode;
            boolean node2IsArray = node2 instanceof ArrayNode;
            if (!node1IsArray || !node2IsArray) {
                return false;
            }
            return this.compareArray(schemaAttribute, (ArrayNode)node1, (ArrayNode)node2);
        }
        if (schemaAttribute.isComplexAttribute()) {
            boolean node1IsObject = node1 instanceof ObjectNode;
            boolean node2IsObject = node2 instanceof ObjectNode;
            if (!node1IsObject || !node2IsObject) {
                return false;
            }
            for (SchemaAttribute subAttribute : schemaAttribute.getSubAttributes()) {
                JsonNode subNode2;
                JsonNode subNode1;
                boolean isEqual = this.compareNodes(subAttribute, subNode1 = node1.get(subAttribute.getName()), subNode2 = node2.get(subAttribute.getName()));
                if (isEqual) continue;
                return false;
            }
            return true;
        }
        return JsonHelper.isEqual(node1, node2);
    }

    private boolean ignoreAttribute(SchemaAttribute schemaAttribute) {
        boolean ignoreAttribute;
        if (this.attributeHandlingType.equals((Object)AttributeHandlingType.EXCLUDE)) {
            return this.attributes.contains(schemaAttribute);
        }
        boolean isAttributePresent = this.attributes.contains(schemaAttribute) || schemaAttribute.isChildOfComplexAttribute() && this.attributes.contains(schemaAttribute.getParent());
        boolean bl = ignoreAttribute = !isAttributePresent;
        if (ignoreAttribute && schemaAttribute.isComplexAttribute()) {
            if (schemaAttribute.getSubAttributes().stream().anyMatch(this.attributes::contains)) {
                return false;
            }
        }
        return ignoreAttribute;
    }

    private boolean compareArray(SchemaAttribute schemaAttribute, ArrayNode node1, ArrayNode node2) {
        if (node1.size() != node2.size()) {
            return false;
        }
        List subNodes1 = IntStream.range(0, node1.size()).mapToObj(index -> new ObjectNode(JsonNodeFactory.instance)).collect(Collectors.toList());
        List subNodes2 = IntStream.range(0, node2.size()).mapToObj(index -> new ObjectNode(JsonNodeFactory.instance)).collect(Collectors.toList());
        for (SchemaAttribute subAttribute : schemaAttribute.getSubAttributes()) {
            boolean ignoreAttribute = this.ignoreAttribute(subAttribute);
            if (ignoreAttribute) continue;
            for (int i = 0; i < subNodes1.size(); ++i) {
                ObjectNode objectNode1 = (ObjectNode)subNodes1.get(i);
                ObjectNode objectNode2 = (ObjectNode)subNodes2.get(i);
                ObjectNode complexIndexNode1 = (ObjectNode)node1.get(i);
                ObjectNode complexIndexNode2 = (ObjectNode)node2.get(i);
                objectNode1.set(subAttribute.getName(), complexIndexNode1.get(subAttribute.getName()));
                objectNode2.set(subAttribute.getName(), complexIndexNode2.get(subAttribute.getName()));
            }
        }
        for (int i = subNodes1.size() - 1; i >= 0; --i) {
            ObjectNode comparisonNode1 = (ObjectNode)subNodes1.get(i);
            boolean equalElement = false;
            for (int j = subNodes2.size() - 1; j >= 0; --j) {
                ObjectNode comparisonNode2 = (ObjectNode)subNodes2.get(j);
                boolean isEqual = JsonHelper.isEqual((JsonNode)comparisonNode1, (JsonNode)comparisonNode2);
                if (!isEqual) continue;
                subNodes1.remove(i);
                subNodes2.remove(j);
                equalElement = true;
                break;
            }
            if (equalElement) continue;
            return false;
        }
        return true;
    }

    public static enum AttributeHandlingType {
        EXCLUDE,
        INCLUDE;

    }
}

