/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class BulkRequestOperation
extends ScimObjectNode {
    public String uniqueIdentifier;

    public BulkRequestOperation() {
        super(null);
    }

    public BulkRequestOperation(HttpMethod method, String bulkId, String path, String data, ETag version, Boolean returnResource, Integer maxResourceLevel) {
        this();
        this.setMethod(method);
        this.setBulkId(bulkId);
        this.setPath(path);
        this.setData(data);
        this.setVersion(version);
        this.setReturnResource(returnResource);
        this.setMaxResourceLevel(maxResourceLevel);
    }

    public HttpMethod getMethod() {
        return this.getStringAttribute("method").map(HttpMethod::valueOf).orElseThrow(() -> new BadRequestException("the 'method' attribute is mandatory", null, "invalidParameters"));
    }

    public void setMethod(HttpMethod method) {
        this.setAttribute("method", method == null ? null : method.name());
    }

    public Optional<String> getBulkId() {
        return this.getStringAttribute("bulkId");
    }

    public void setBulkId(String bulkId) {
        this.setAttribute("bulkId", bulkId);
    }

    public String getPath() {
        return this.getStringAttribute("path").orElseThrow(() -> new BadRequestException("the 'path' attribute is mandatory", null, null));
    }

    public void setPath(String path) {
        this.setAttribute("path", path);
    }

    public Optional<String> getData() {
        return Optional.ofNullable(this.get("data")).map(jsonNode -> jsonNode.isTextual() ? jsonNode.textValue() : jsonNode.toString());
    }

    public void setData(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        this.set("data", JsonHelper.readJsonDocument(data));
    }

    public void setData(JsonNode data) {
        if (data == null || data.isNull()) {
            return;
        }
        this.set("data", data);
    }

    public Optional<ETag> getVersion() {
        return this.getStringAttribute("version", ETag.class);
    }

    public void setVersion(String version) {
        this.setVersion(ETag.builder().weak(true).tag(version).build());
    }

    public void setVersion(ETag version) {
        if (version == null) {
            this.remove("version");
        } else {
            this.set("version", (JsonNode)version);
        }
    }

    public Optional<Boolean> isReturnResource() {
        return this.getBooleanAttribute("returnResource");
    }

    public void setReturnResource(Boolean returnResource) {
        this.setAttribute("returnResource", returnResource);
    }

    public Integer getMaxResourceLevel() {
        return this.getIntegerAttribute("maxResourceLevel").orElse(0);
    }

    public void setMaxResourceLevel(Integer maxResourceLevel) {
        this.setAttribute("maxResourceLevel", maxResourceLevel);
    }

    @Generated
    public static BulkRequestOperationBuilder builder() {
        return new BulkRequestOperationBuilder();
    }

    @Generated
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Generated
    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public static class BulkRequestOperationBuilder {
        @Generated
        private HttpMethod method;
        @Generated
        private String bulkId;
        @Generated
        private String path;
        @Generated
        private String data;
        @Generated
        private ETag version;
        @Generated
        private Boolean returnResource;
        @Generated
        private Integer maxResourceLevel;

        @Generated
        public BulkRequestOperationBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @Generated
        public BulkRequestOperationBuilder bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        @Generated
        public BulkRequestOperationBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public BulkRequestOperationBuilder data(String data) {
            this.data = data;
            return this;
        }

        @Generated
        public BulkRequestOperationBuilder version(ETag version) {
            this.version = version;
            return this;
        }

        @Generated
        public BulkRequestOperationBuilder returnResource(Boolean returnResource) {
            this.returnResource = returnResource;
            return this;
        }

        @Generated
        public BulkRequestOperationBuilder maxResourceLevel(Integer maxResourceLevel) {
            this.maxResourceLevel = maxResourceLevel;
            return this;
        }

        @Generated
        public BulkRequestOperation build() {
            return new BulkRequestOperation(this.method, this.bulkId, this.path, this.data, this.version, this.returnResource, this.maxResourceLevel);
        }

        @Generated
        public String toString() {
            return "BulkRequestOperation.BulkRequestOperationBuilder(method=" + (Object)((Object)this.method) + ", bulkId=" + this.bulkId + ", path=" + this.path + ", data=" + this.data + ", version=" + this.version + ", returnResource=" + this.returnResource + ", maxResourceLevel=" + this.maxResourceLevel + ")";
        }
    }
}

