// Generated by delombok at Sun Aug 17 13:23:43 CEST 2025
package de.captaingoldfish.scim.sdk.common.request;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.constants.SchemaUris;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;


/**
 * author Pascal Knueppel <br>
 * created at: 25.10.2019 - 20:34 <br>
 * <br>
 * represents a simple bulk request
 */
public class BulkRequest extends AbstractSchemasHolder
{

  public BulkRequest()
  {
    setSchemas(Collections.singletonList(SchemaUris.BULK_REQUEST_URI));
  }

  public BulkRequest(Integer failOnErrors, List<BulkRequestOperation> bulkRequestOperation)
  {
    this();
    setFailOnErrors(failOnErrors);
    setBulkRequestOperations(bulkRequestOperation);
  }

  /**
   * An integer specifying the number of errors that the service provider will accept before the operation is
   * terminated and an error response is returned. OPTIONAL in a request. Not valid in a response.
   */
  public Optional<Integer> getFailOnErrors()
  {
    return getLongAttribute(AttributeNames.RFC7643.FAIL_ON_ERRORS).map(Long::intValue);
  }

  /**
   * An integer specifying the number of errors that the service provider will accept before the operation is
   * terminated and an error response is returned. OPTIONAL in a request. Not valid in a response.
   */
  public void setFailOnErrors(Integer failOnErrors)
  {
    setAttribute(AttributeNames.RFC7643.FAIL_ON_ERRORS, failOnErrors == null ? null : failOnErrors.longValue());
  }

  /**
   * Defines operations within a bulk job. Each operation corresponds to a single HTTP request against a
   * resource endpoint. REQUIRED.
   */
  public List<BulkRequestOperation> getBulkRequestOperations()
  {
    List<BulkRequestOperation> operations = getArrayAttribute(AttributeNames.RFC7643.OPERATIONS,
                                                              BulkRequestOperation.class);
    if (operations.isEmpty())
    {
      this.setAttribute(AttributeNames.RFC7643.OPERATIONS, (ObjectNode)null);
    }
    return operations;
  }

  /**
   * Defines operations within a bulk job. Each operation corresponds to a single HTTP request against a
   * resource endpoint. REQUIRED.
   */
  public void setBulkRequestOperations(List<BulkRequestOperation> bulkRequestOperation)
  {
    setAttribute(AttributeNames.RFC7643.OPERATIONS, bulkRequestOperation);
  }


  /**
   * override lombok builder with public constructor
   */
  public static class BulkRequestBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer failOnErrors;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private List<BulkRequestOperation> bulkRequestOperation;

    public BulkRequestBuilder()
    {}

    public Integer getFailOnErrors()
    {
      return failOnErrors;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BulkRequest.BulkRequestBuilder failOnErrors(final Integer failOnErrors)
    {
      this.failOnErrors = failOnErrors;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BulkRequest.BulkRequestBuilder bulkRequestOperation(final List<BulkRequestOperation> bulkRequestOperation)
    {
      this.bulkRequestOperation = bulkRequestOperation;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BulkRequest build()
    {
      return new BulkRequest(this.failOnErrors, this.bulkRequestOperation);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "BulkRequest.BulkRequestBuilder(failOnErrors=" + this.failOnErrors + ", bulkRequestOperation="
             + this.bulkRequestOperation + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static BulkRequest.BulkRequestBuilder builder()
  {
    return new BulkRequest.BulkRequestBuilder();
  }
}
