// Generated by delombok at Sun Aug 17 13:23:43 CEST 2025
package de.captaingoldfish.scim.sdk.common.resources.complex;

import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;


/**
 * author Pascal Knueppel <br>
 * created at: 18.10.2019 - 10:56 <br>
 * <br>
 * A complex type that specifies FILTER options. REQUIRED. See Section 3.4.2.2 of [RFC7644].
 */
public class FilterConfig extends ScimObjectNode
{

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(FilterConfig.class);

  /**
   * the default value for the max results value. Default is 1. This will enforce the developer to modify the
   * service provider configuration to the applications requirements
   */
  protected static final Integer DEFAULT_MAX_RESULTS = 1;

  public FilterConfig()
  {
    setSupported(false);
  }

  public FilterConfig(Boolean supported, Integer maxResults)
  {
    super(null);
    setSupported(Optional.ofNullable(supported).orElse(false));
    setMaxResults(maxResults);
  }

  /**
   * A Boolean value specifying whether or not the operation is supported. REQUIRED.
   */
  public boolean isSupported()
  {
    return getBooleanAttribute(AttributeNames.RFC7643.SUPPORTED).orElse(false);
  }

  /**
   * A Boolean value specifying whether or not the operation is supported. REQUIRED.
   */
  public void setSupported(Boolean supported)
  {
    setAttribute(AttributeNames.RFC7643.SUPPORTED, Optional.ofNullable(supported).orElse(false));
  }

  /**
   * An integer value specifying the maximum number of resources returned in a response. REQUIRED.
   */
  public Integer getMaxResults()
  {
    return getLongAttribute(AttributeNames.RFC7643.MAX_RESULTS).orElse(Long.valueOf(DEFAULT_MAX_RESULTS)).intValue();
  }

  /**
   * An integer value specifying the maximum number of resources returned in a response. REQUIRED.
   */
  public void setMaxResults(Integer maxResults)
  {
    Long results = maxResults == null ? null : Long.valueOf(maxResults);
    setAttribute(AttributeNames.RFC7643.MAX_RESULTS, Optional.ofNullable(results).orElseGet(() -> {
      log.warn("No value set for \'FilterConfig.maxResults\'. Value is defaulting to: {}", DEFAULT_MAX_RESULTS);
      return Long.valueOf(DEFAULT_MAX_RESULTS);
    }));
  }


  /**
   * override lombok builder with public constructor
   */
  public static class FilterConfigBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean supported;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer maxResults;

    public FilterConfigBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterConfig.FilterConfigBuilder supported(final Boolean supported)
    {
      this.supported = supported;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterConfig.FilterConfigBuilder maxResults(final Integer maxResults)
    {
      this.maxResults = maxResults;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterConfig build()
    {
      return new FilterConfig(this.supported, this.maxResults);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "FilterConfig.FilterConfigBuilder(supported=" + this.supported + ", maxResults=" + this.maxResults + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static FilterConfig.FilterConfigBuilder builder()
  {
    return new FilterConfig.FilterConfigBuilder();
  }
}
