// Generated by delombok at Sun Aug 17 13:23:43 CEST 2025
package de.captaingoldfish.scim.sdk.common.resources.multicomplex;

import java.util.Objects;
import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidConfigException;


/**
 * author Pascal Knueppel <br>
 * created at: 18.10.2019 - 10:41 <br>
 * <br>
 * A multi-valued complex type that specifies supported authentication scheme properties. To enable seamless
 * discovery of configurations, the service provider SHOULD, with the appropriate security considerations,
 * make the authenticationSchemes attribute publicly accessible without prior authentication. REQUIRED.
 */
public class AuthenticationScheme extends MultiComplexNode
{

  public AuthenticationScheme(String name,
                              String description,
                              String type,
                              String specUri,
                              String documentationUri,
                              Boolean primary,
                              String display,
                              String value,
                              String ref)
  {
    setName(name);
    setDescription(description);
    setAuthenticationType(type);
    setSpecUri(specUri);
    setDocumentationUri(documentationUri);
    setPrimary(primary);
    setDisplay(display);
    setValue(value);
    setRef(ref);
  }

  public AuthenticationScheme(String type, Boolean primary, String display, String value, String ref)
  {
    super(type, primary, display, value, ref);
  }

  /**
   * The common authentication scheme name, e.g., HTTP Basic. REQUIRED.
   */
  public String getName()
  {
    return getStringAttribute(AttributeNames.RFC7643.NAME).orElseThrow(() -> {
      return new InvalidConfigException("the \'name\' attribute is required");
    });
  }

  /**
   * The common authentication scheme name, e.g., HTTP Basic. REQUIRED.
   */
  public void setName(String name)
  {
    setAttribute(AttributeNames.RFC7643.NAME, Objects.requireNonNull(name));
  }

  /**
   * A description of the authentication scheme. REQUIRED.
   */
  public String getDescription()
  {
    return getStringAttribute(AttributeNames.RFC7643.DESCRIPTION).orElseThrow(() -> {
      return new InvalidConfigException("the \'description\' attribute is required");
    });
  }

  /**
   * A description of the authentication scheme. REQUIRED.
   */
  public void setDescription(String description)
  {
    setAttribute(AttributeNames.RFC7643.DESCRIPTION, Objects.requireNonNull(description));
  }

  /**
   * The authentication scheme. This specification defines the values "oauth", "oauth2", "oauthbearertoken",
   * "httpbasic", and "httpdigest". REQUIRED.
   */
  public String getAuthenticationType()
  {
    return getStringAttribute(AttributeNames.RFC7643.TYPE).orElseThrow(() -> {
      return new InvalidConfigException("the \'type\' attribute is required");
    });
  }

  /**
   * The authentication scheme. This specification defines the values "oauth", "oauth2", "oauthbearertoken",
   * "httpbasic", and "httpdigest". REQUIRED.
   */
  public void setAuthenticationType(String type)
  {
    setAttribute(AttributeNames.RFC7643.TYPE, Objects.requireNonNull(type));
  }

  /**
   * An HTTP-addressable URL pointing to the authentication scheme's specification. OPTIONAL.
   */
  public Optional<String> getSpecUri()
  {
    return getStringAttribute(AttributeNames.RFC7643.SPEC_URI);
  }

  /**
   * An HTTP-addressable URL pointing to the authentication scheme's specification. OPTIONAL.
   */
  public void setSpecUri(String specUri)
  {
    setAttribute(AttributeNames.RFC7643.SPEC_URI, specUri);
  }

  /**
   * An HTTP-addressable URL pointing to the authentication scheme's usage documentation. OPTIONAL.
   */
  public Optional<String> getDocumentationUri()
  {
    return getStringAttribute(AttributeNames.RFC7643.DOCUMENTATION_URI);
  }

  /**
   * An HTTP-addressable URL pointing to the authentication scheme's usage documentation. OPTIONAL.
   */
  public void setDocumentationUri(String documentationUri)
  {
    setAttribute(AttributeNames.RFC7643.DOCUMENTATION_URI, documentationUri);
  }

  /**
   * returns this authentication type as string representation that matches the http WWW-Authenticate response
   * header representation
   */
  public String getWwwAuthenticateHeaderRepresentation(String realm)
  {
    return getName() + " realm=\"" + realm + "\"";
  }


  /**
   * override lombok builder with public constructor
   */
  public static class AuthenticationSchemeBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String name;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String description;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String specUri;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String documentationUri;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean primary;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String display;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String value;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String ref;

    public AuthenticationSchemeBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder name(final String name)
    {
      this.name = name;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder description(final String description)
    {
      this.description = description;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder type(final String type)
    {
      this.type = type;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder specUri(final String specUri)
    {
      this.specUri = specUri;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder documentationUri(final String documentationUri)
    {
      this.documentationUri = documentationUri;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder primary(final Boolean primary)
    {
      this.primary = primary;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder display(final String display)
    {
      this.display = display;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder value(final String value)
    {
      this.value = value;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme.AuthenticationSchemeBuilder ref(final String ref)
    {
      this.ref = ref;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthenticationScheme build()
    {
      return new AuthenticationScheme(this.name, this.description, this.type, this.specUri, this.documentationUri,
                                      this.primary, this.display, this.value, this.ref);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "AuthenticationScheme.AuthenticationSchemeBuilder(name=" + this.name + ", description=" + this.description
             + ", type=" + this.type + ", specUri=" + this.specUri + ", documentationUri=" + this.documentationUri
             + ", primary=" + this.primary + ", display=" + this.display + ", value=" + this.value + ", ref=" + this.ref
             + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static AuthenticationScheme.AuthenticationSchemeBuilder builder()
  {
    return new AuthenticationScheme.AuthenticationSchemeBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AuthenticationScheme()
  {}
}
