/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources;

import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.Member;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class Group
extends ResourceNode {
    public Group() {
        this.setSchemas(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Group"));
    }

    public Group(String id, String externalId, String displayName, List<Member> members, Meta meta) {
        this();
        this.setId(id);
        this.setExternalId(externalId);
        this.setDisplayName(displayName);
        this.setMembers(members);
        this.setMeta(meta);
    }

    public Optional<String> getDisplayName() {
        return this.getStringAttribute("displayName");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("displayName", displayName);
    }

    public List<Member> getMembers() {
        return this.getArrayAttribute("members", Member.class);
    }

    public void setMembers(List<Member> members) {
        this.setAttribute("members", members);
    }

    public void addMember(Member member) {
        this.addAttribute("members", member);
    }

    @Generated
    public static GroupBuilder builder() {
        return new GroupBuilder();
    }

    public static class GroupBuilder {
        @Generated
        private String id;
        @Generated
        private String externalId;
        @Generated
        private String displayName;
        @Generated
        private List<Member> members;
        @Generated
        private Meta meta;

        @Generated
        public GroupBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public GroupBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Generated
        public GroupBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Generated
        public GroupBuilder members(List<Member> members) {
            this.members = members;
            return this;
        }

        @Generated
        public GroupBuilder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        @Generated
        public Group build() {
            return new Group(this.id, this.externalId, this.displayName, this.members, this.meta);
        }

        @Generated
        public String toString() {
            return "Group.GroupBuilder(id=" + this.id + ", externalId=" + this.externalId + ", displayName=" + this.displayName + ", members=" + this.members + ", meta=" + this.meta + ")";
        }
    }
}

