/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources;

import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ChangePasswordConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ETagConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.FilterConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.SortConfig;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.AuthenticationScheme;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProvider
extends ResourceNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceProvider.class);
    private ForkJoinPool threadPool = ForkJoinPool.commonPool();
    private boolean caseInsensitiveValidation;
    private boolean useDefaultValuesOnRequest = true;
    private boolean useDefaultValuesOnResponse = true;
    private boolean ignoreRequiredAttributesOnResponse = false;
    private boolean ignoreRequiredExtensionsOnResponse = false;
    private boolean lenientContentTypeChecking = false;

    public ServiceProvider(String documentationUri, PatchConfig patchConfig, ChangePasswordConfig changePasswordConfig, SortConfig sortConfig, ETagConfig eTagConfig, FilterConfig filterConfig, BulkConfig bulkConfig, List<AuthenticationScheme> authenticationSchemes, ForkJoinPool forkJoinPool, boolean caseInsensitiveValidation, boolean useDefaultValuesOnRequest, boolean useDefaultValuesOnResponse, Boolean ignoreRequiredAttributesOnResponse, Boolean ignoreRequiredExtensionsOnResponse, boolean lenientContentTypeChecking) {
        this.setSchemas(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig"));
        this.setDocumentationUri(documentationUri);
        this.setPatchConfig(patchConfig);
        this.setChangePasswordConfig(changePasswordConfig);
        this.setSortConfig(sortConfig);
        this.setETagConfig(eTagConfig);
        this.setFilterConfig(filterConfig);
        this.setBulkConfig(bulkConfig);
        this.setAuthenticationSchemes(authenticationSchemes);
        Meta meta = Meta.builder().resourceType("ServiceProviderConfig").created(LocalDateTime.now()).lastModified(LocalDateTime.now()).build();
        this.setMeta(meta);
        Optional.ofNullable(forkJoinPool).ifPresent(this::setThreadPool);
        this.caseInsensitiveValidation = caseInsensitiveValidation;
        this.useDefaultValuesOnRequest = useDefaultValuesOnRequest;
        this.useDefaultValuesOnResponse = useDefaultValuesOnResponse;
        this.lenientContentTypeChecking = lenientContentTypeChecking;
        this.ignoreRequiredAttributesOnResponse = Optional.ofNullable(ignoreRequiredAttributesOnResponse).orElse(true);
        this.ignoreRequiredExtensionsOnResponse = Optional.ofNullable(ignoreRequiredExtensionsOnResponse).orElse(true);
    }

    public Optional<String> getDocumentationUri() {
        return this.getStringAttribute("documentationUri");
    }

    public void setDocumentationUri(String documentationUri) {
        this.setAttribute("documentationUri", documentationUri);
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public PatchConfig getPatchConfig() {
        return this.getObjectAttribute("patch", PatchConfig.class).orElseGet(PatchConfig::new);
    }

    public void setPatchConfig(PatchConfig patchConfig) {
        this.setAttribute("patch", Optional.ofNullable(patchConfig).orElseGet(() -> PatchConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public BulkConfig getBulkConfig() {
        return this.getObjectAttribute("bulk", BulkConfig.class).orElseGet(BulkConfig::new);
    }

    public void setBulkConfig(BulkConfig bulkConfig) {
        this.setAttribute("bulk", Optional.ofNullable(bulkConfig).orElseGet(() -> BulkConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public FilterConfig getFilterConfig() {
        return this.getObjectAttribute("filter", FilterConfig.class).orElseGet(FilterConfig::new);
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.setAttribute("filter", Optional.ofNullable(filterConfig).orElseGet(FilterConfig::new));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public ChangePasswordConfig getChangePasswordConfig() {
        return this.getObjectAttribute("changePassword", ChangePasswordConfig.class).orElseGet(ChangePasswordConfig::new);
    }

    public void setChangePasswordConfig(ChangePasswordConfig changePasswordConfig) {
        this.setAttribute("changePassword", Optional.ofNullable(changePasswordConfig).orElseGet(ChangePasswordConfig::new));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public SortConfig getSortConfig() {
        return this.getObjectAttribute("sort", SortConfig.class).orElseGet(SortConfig::new);
    }

    public void setSortConfig(SortConfig sortConfig) {
        this.setAttribute("sort", Optional.ofNullable(sortConfig).orElseGet(SortConfig::new));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public ETagConfig getETagConfig() {
        return this.getObjectAttribute("etag", ETagConfig.class).orElseGet(ETagConfig::new);
    }

    public void setETagConfig(ETagConfig eTagConfig) {
        this.setAttribute("etag", Optional.ofNullable(eTagConfig).orElseGet(ETagConfig::new));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public List<AuthenticationScheme> getAuthenticationSchemes() {
        return this.getArrayAttribute("authenticationSchemes", AuthenticationScheme.class);
    }

    public void setAuthenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
        this.setAttribute("authenticationSchemes", authenticationSchemes);
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public void setThreadPool(ForkJoinPool threadPool) {
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    @Generated
    public static ServiceProviderBuilder builder() {
        return new ServiceProviderBuilder();
    }

    @Generated
    public ServiceProvider() {
    }

    @Generated
    public ForkJoinPool getThreadPool() {
        return this.threadPool;
    }

    @Generated
    public boolean isCaseInsensitiveValidation() {
        return this.caseInsensitiveValidation;
    }

    @Generated
    public boolean isUseDefaultValuesOnRequest() {
        return this.useDefaultValuesOnRequest;
    }

    @Generated
    public void setUseDefaultValuesOnRequest(boolean useDefaultValuesOnRequest) {
        this.useDefaultValuesOnRequest = useDefaultValuesOnRequest;
    }

    @Generated
    public boolean isUseDefaultValuesOnResponse() {
        return this.useDefaultValuesOnResponse;
    }

    @Generated
    public void setUseDefaultValuesOnResponse(boolean useDefaultValuesOnResponse) {
        this.useDefaultValuesOnResponse = useDefaultValuesOnResponse;
    }

    @Generated
    public boolean isIgnoreRequiredAttributesOnResponse() {
        return this.ignoreRequiredAttributesOnResponse;
    }

    @Generated
    public void setIgnoreRequiredAttributesOnResponse(boolean ignoreRequiredAttributesOnResponse) {
        this.ignoreRequiredAttributesOnResponse = ignoreRequiredAttributesOnResponse;
    }

    @Generated
    public boolean isIgnoreRequiredExtensionsOnResponse() {
        return this.ignoreRequiredExtensionsOnResponse;
    }

    @Generated
    public void setIgnoreRequiredExtensionsOnResponse(boolean ignoreRequiredExtensionsOnResponse) {
        this.ignoreRequiredExtensionsOnResponse = ignoreRequiredExtensionsOnResponse;
    }

    @Generated
    public boolean isLenientContentTypeChecking() {
        return this.lenientContentTypeChecking;
    }

    public static class ServiceProviderBuilder {
        @Generated
        private String documentationUri;
        @Generated
        private PatchConfig patchConfig;
        @Generated
        private ChangePasswordConfig changePasswordConfig;
        @Generated
        private SortConfig sortConfig;
        @Generated
        private ETagConfig eTagConfig;
        @Generated
        private FilterConfig filterConfig;
        @Generated
        private BulkConfig bulkConfig;
        @Generated
        private List<AuthenticationScheme> authenticationSchemes;
        @Generated
        private ForkJoinPool forkJoinPool;
        @Generated
        private boolean caseInsensitiveValidation;
        @Generated
        private boolean useDefaultValuesOnRequest;
        @Generated
        private boolean useDefaultValuesOnResponse;
        @Generated
        private Boolean ignoreRequiredAttributesOnResponse;
        @Generated
        private Boolean ignoreRequiredExtensionsOnResponse;
        @Generated
        private boolean lenientContentTypeChecking;

        @Generated
        public ServiceProviderBuilder documentationUri(String documentationUri) {
            this.documentationUri = documentationUri;
            return this;
        }

        @Generated
        public ServiceProviderBuilder patchConfig(PatchConfig patchConfig) {
            this.patchConfig = patchConfig;
            return this;
        }

        @Generated
        public ServiceProviderBuilder changePasswordConfig(ChangePasswordConfig changePasswordConfig) {
            this.changePasswordConfig = changePasswordConfig;
            return this;
        }

        @Generated
        public ServiceProviderBuilder sortConfig(SortConfig sortConfig) {
            this.sortConfig = sortConfig;
            return this;
        }

        @Generated
        public ServiceProviderBuilder eTagConfig(ETagConfig eTagConfig) {
            this.eTagConfig = eTagConfig;
            return this;
        }

        @Generated
        public ServiceProviderBuilder filterConfig(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
            return this;
        }

        @Generated
        public ServiceProviderBuilder bulkConfig(BulkConfig bulkConfig) {
            this.bulkConfig = bulkConfig;
            return this;
        }

        @Generated
        public ServiceProviderBuilder authenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
            this.authenticationSchemes = authenticationSchemes;
            return this;
        }

        @Generated
        public ServiceProviderBuilder forkJoinPool(ForkJoinPool forkJoinPool) {
            this.forkJoinPool = forkJoinPool;
            return this;
        }

        @Generated
        public ServiceProviderBuilder caseInsensitiveValidation(boolean caseInsensitiveValidation) {
            this.caseInsensitiveValidation = caseInsensitiveValidation;
            return this;
        }

        @Generated
        public ServiceProviderBuilder useDefaultValuesOnRequest(boolean useDefaultValuesOnRequest) {
            this.useDefaultValuesOnRequest = useDefaultValuesOnRequest;
            return this;
        }

        @Generated
        public ServiceProviderBuilder useDefaultValuesOnResponse(boolean useDefaultValuesOnResponse) {
            this.useDefaultValuesOnResponse = useDefaultValuesOnResponse;
            return this;
        }

        @Generated
        public ServiceProviderBuilder ignoreRequiredAttributesOnResponse(Boolean ignoreRequiredAttributesOnResponse) {
            this.ignoreRequiredAttributesOnResponse = ignoreRequiredAttributesOnResponse;
            return this;
        }

        @Generated
        public ServiceProviderBuilder ignoreRequiredExtensionsOnResponse(Boolean ignoreRequiredExtensionsOnResponse) {
            this.ignoreRequiredExtensionsOnResponse = ignoreRequiredExtensionsOnResponse;
            return this;
        }

        @Generated
        public ServiceProviderBuilder lenientContentTypeChecking(boolean lenientContentTypeChecking) {
            this.lenientContentTypeChecking = lenientContentTypeChecking;
            return this;
        }

        @Generated
        public ServiceProvider build() {
            return new ServiceProvider(this.documentationUri, this.patchConfig, this.changePasswordConfig, this.sortConfig, this.eTagConfig, this.filterConfig, this.bulkConfig, this.authenticationSchemes, this.forkJoinPool, this.caseInsensitiveValidation, this.useDefaultValuesOnRequest, this.useDefaultValuesOnResponse, this.ignoreRequiredAttributesOnResponse, this.ignoreRequiredExtensionsOnResponse, this.lenientContentTypeChecking);
        }

        @Generated
        public String toString() {
            return "ServiceProvider.ServiceProviderBuilder(documentationUri=" + this.documentationUri + ", patchConfig=" + this.patchConfig + ", changePasswordConfig=" + this.changePasswordConfig + ", sortConfig=" + this.sortConfig + ", eTagConfig=" + this.eTagConfig + ", filterConfig=" + this.filterConfig + ", bulkConfig=" + this.bulkConfig + ", authenticationSchemes=" + this.authenticationSchemes + ", forkJoinPool=" + this.forkJoinPool + ", caseInsensitiveValidation=" + this.caseInsensitiveValidation + ", useDefaultValuesOnRequest=" + this.useDefaultValuesOnRequest + ", useDefaultValuesOnResponse=" + this.useDefaultValuesOnResponse + ", ignoreRequiredAttributesOnResponse=" + this.ignoreRequiredAttributesOnResponse + ", ignoreRequiredExtensionsOnResponse=" + this.ignoreRequiredExtensionsOnResponse + ", lenientContentTypeChecking=" + this.lenientContentTypeChecking + ")";
        }
    }
}

