/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Returned;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.constants.enums.Uniqueness;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidSchemaException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaAttribute
extends ScimObjectNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaAttribute.class);
    private final Schema schema;
    private final SchemaAttribute parent;
    private final Map<String, SchemaAttribute> subAttributes = new HashMap<String, SchemaAttribute>();
    private final String resourceUri;
    private final String namePrefix;
    private Pattern pattern;

    public SchemaAttribute() {
        this.schema = null;
        this.parent = null;
        this.resourceUri = null;
        this.namePrefix = null;
    }

    public SchemaAttribute(SchemaAttribute parent, String resourceUri, String namePrefix) {
        this.schema = null;
        this.parent = parent;
        this.resourceUri = resourceUri;
        this.namePrefix = namePrefix;
    }

    protected SchemaAttribute(JsonNode attributeDefinition) {
        this(null, null, null, attributeDefinition, null);
    }

    protected SchemaAttribute(Schema schema, String resourceUri, SchemaAttribute parent, JsonNode jsonNode, String namePrefix) {
        super(null);
        this.schema = schema;
        this.resourceUri = resourceUri;
        this.parent = parent;
        this.namePrefix = namePrefix;
        Function<String, String> errorMessageBuilder = attribute -> "could not find required attribute '" + attribute + "' in meta-schema for attribute: " + this.getScimNodeName();
        String nameAttribute = "name";
        String nameErrorMessage = errorMessageBuilder.apply("name");
        this.setName(JsonHelper.getSimpleAttribute(jsonNode, "name").orElseThrow(() -> this.getException(nameErrorMessage, null)));
        String typeAttribute = "type";
        String typeErrorMessage = errorMessageBuilder.apply("type");
        Type type = Type.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "type").orElseThrow(() -> this.getException(typeErrorMessage, null)));
        this.setType(type);
        String descriptionAttribute = "description";
        String descriptionErrorMessage = errorMessageBuilder.apply("description");
        this.setDescription(JsonHelper.getSimpleAttribute(jsonNode, "description").orElseThrow(() -> this.getException(descriptionErrorMessage, null)));
        this.setMutability(Mutability.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "mutability").orElse(null)));
        this.setReturned(Returned.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "returned").orElse(null)));
        this.setUniqueness(Uniqueness.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "uniqueness").orElse(Uniqueness.NONE.getValue())));
        this.setMultiValued(JsonHelper.getSimpleAttribute(jsonNode, "multiValued", Boolean.class).orElse(false));
        this.setRequired(JsonHelper.getSimpleAttribute(jsonNode, "required", Boolean.class).orElse(false));
        this.setCaseExact(JsonHelper.getSimpleAttribute(jsonNode, "caseExact", Boolean.class).orElse(false));
        this.setCanonicalValues(JsonHelper.getSimpleAttributeArray(jsonNode, "canonicalValues").orElse(Collections.emptyList()));
        this.setReferenceTypes(JsonHelper.getSimpleAttributeArray(jsonNode, "referenceTypes").map(strings -> strings.stream().map(ReferenceTypes::getByValue).collect(Collectors.toList())).orElse(Type.REFERENCE.equals((Object)type) ? Collections.singletonList(ReferenceTypes.EXTERNAL) : Collections.emptyList()));
        this.setResourceTypeReferenceName(JsonHelper.getSimpleAttribute(jsonNode, "resourceType").orElse(null));
        this.setValidationAttributes(jsonNode);
        JsonHelper.getSimpleAttribute(jsonNode, "defaultValue", String.class).ifPresent(this::setDefaultValue);
        List<SchemaAttribute> subAttributes = this.resolveSubAttributes(jsonNode);
        this.setSubAttributes(subAttributes);
        this.validateAttribute();
        Optional.ofNullable(schema).ifPresent(schemaDefinition -> schemaDefinition.addSchemaAttribute(this));
        this.checkForDirectResourceReference();
        if (schema != null && this.isMultivaluedComplexAttribute()) {
            schema.getMultivaluedComplexRegister().put(this, subAttributes);
        } else if (schema != null && this.isComplexAttribute()) {
            schema.getComplexRegister().put(this, subAttributes);
        }
        if (schema != null && this.isReadOnly()) {
            schema.getReadOnlyAttributeRegister().add(this);
        } else if (schema != null && this.isImmutable()) {
            schema.getImmutableAttributeRegister().add(this);
        }
    }

    public SchemaAttribute(Schema schema, String resourceUri, SchemaAttribute parent, JsonNode jsonNode) {
        this(schema, resourceUri, parent, jsonNode, null);
    }

    public SchemaAttribute getSubAttribute(String attributeName) {
        SchemaAttribute schemaAttribute = this.subAttributes.get(attributeName.toLowerCase());
        if (schemaAttribute == null) {
            schemaAttribute = this.schema.getSchemaAttribute(attributeName);
            if (schemaAttribute != null && schemaAttribute.getParent() != null && schemaAttribute.getParent() == this) {
                return schemaAttribute;
            }
            return null;
        }
        return schemaAttribute;
    }

    public boolean isComplexAttribute() {
        return this.parent == null && Type.COMPLEX.equals((Object)this.getType());
    }

    public boolean isMultivaluedComplexAttribute() {
        return this.parent == null && Type.COMPLEX.equals((Object)this.getType()) && this.isMultiValued();
    }

    public boolean isChildOfComplexAttribute() {
        return this.parent != null;
    }

    public boolean isChildOfMultivaluedComplexAttribute() {
        return this.isChildOfComplexAttribute() && this.parent.isMultiValued();
    }

    public boolean isReadOnly() {
        return this.getMutability().equals((Object)Mutability.READ_ONLY);
    }

    public boolean isImmutable() {
        return this.getMutability().equals((Object)Mutability.IMMUTABLE);
    }

    public boolean isReadWrite() {
        return this.getMutability().equals((Object)Mutability.READ_WRITE);
    }

    public boolean isWriteOnly() {
        return this.getMutability().equals((Object)Mutability.WRITE_ONLY);
    }

    private void checkForDirectResourceReference() {
        if (!Type.REFERENCE.equals((Object)this.getType())) {
            return;
        }
        List<ReferenceTypes> referenceTypes = this.getReferenceTypes();
        if (referenceTypes.size() != 1 || !referenceTypes.contains((Object)ReferenceTypes.RESOURCE)) {
            return;
        }
        if (Mutability.READ_ONLY.equals((Object)this.getMutability())) {
            return;
        }
        if (!this.getResourceTypeReferenceName().isPresent()) {
            return;
        }
        this.schema.getSimpleBulkIdCandidates().add(this);
    }

    private void setValidationAttributes(JsonNode jsonNode) {
        JsonHelper.getSimpleAttribute(jsonNode, "minimum", Double.class).ifPresent(this::setMinimum);
        JsonHelper.getSimpleAttribute(jsonNode, "maximum", Double.class).ifPresent(this::setMaximum);
        JsonHelper.getSimpleAttribute(jsonNode, "multipleOf", Double.class).ifPresent(this::setMultipleOf);
        JsonHelper.getSimpleAttribute(jsonNode, "minLength", Long.class).ifPresent(this::setMinLength);
        JsonHelper.getSimpleAttribute(jsonNode, "maxLength", Long.class).ifPresent(this::setMaxLength);
        JsonHelper.getSimpleAttribute(jsonNode, "pattern").ifPresent(this::setPattern);
        JsonHelper.getSimpleAttribute(jsonNode, "minItems", Integer.class).ifPresent(this::setMinItems);
        JsonHelper.getSimpleAttribute(jsonNode, "maxItems", Integer.class).ifPresent(this::setMaxItems);
        JsonHelper.getSimpleAttribute(jsonNode, "notBefore", String.class).ifPresent(this::setNotBefore);
        JsonHelper.getSimpleAttribute(jsonNode, "notAfter", String.class).ifPresent(this::setNotAfter);
    }

    public boolean isComplexBulkCandidate() {
        return this.schema.getComplexBulkIdCandidates().contains(this);
    }

    public boolean isSimpleValueBulkCandidate() {
        return this.schema.getSimpleBulkIdCandidates().contains(this);
    }

    public String getFullResourceName() {
        return this.getParent() == null ? this.getResourceUri() + ":" + this.getScimNodeName() : this.getResourceUri() + ":" + this.getScimNodeName();
    }

    @Override
    public String getScimNodeName() {
        return this.getParent() == null ? this.getNamePrefix() + this.getName() : this.getParent().getScimNodeName() + "." + this.getName();
    }

    public String getNamePrefix() {
        return this.namePrefix == null ? "" : this.namePrefix + ".";
    }

    public String getName() {
        return this.getStringAttribute("name").orElse(null);
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public Type getType() {
        return this.getStringAttribute("type").map(Type::getByValue).orElse(null);
    }

    public void setType(Type type) {
        this.setAttribute("type", (String)Optional.ofNullable(type).map(Type::getValue).orElse(null));
    }

    public String getDescription() {
        return this.getStringAttribute("description").orElse(null);
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    @Override
    public Mutability getMutability() {
        return this.getStringAttribute("mutability").map(Mutability::getByValue).orElse(null);
    }

    public void setMutability(Mutability mutability) {
        this.setAttribute("mutability", (String)Optional.ofNullable(mutability).map(Mutability::getValue).orElse(null));
    }

    @Override
    public Returned getReturned() {
        return this.getStringAttribute("returned").map(Returned::getByValue).orElse(null);
    }

    public void setReturned(Returned returned) {
        this.setAttribute("returned", (String)Optional.ofNullable(returned).map(Returned::getValue).orElse(null));
    }

    @Override
    public Uniqueness getUniqueness() {
        return this.getStringAttribute("uniqueness").map(Uniqueness::getByValue).orElse(null);
    }

    public void setUniqueness(Uniqueness uniqueness) {
        this.setAttribute("uniqueness", (String)Optional.ofNullable(uniqueness).map(Uniqueness::getValue).orElse(null));
    }

    @Override
    public boolean isMultiValued() {
        return this.getBooleanAttribute("multiValued").orElse(false);
    }

    public void setMultiValued(boolean multiValued) {
        this.setAttribute("multiValued", multiValued);
    }

    @Override
    public boolean isRequired() {
        return this.getBooleanAttribute("required").orElse(false);
    }

    public void setRequired(boolean required) {
        this.setAttribute("required", required);
    }

    @Override
    public boolean isCaseExact() {
        return this.getBooleanAttribute("caseExact").orElse(false);
    }

    public void setCaseExact(boolean caseExact) {
        this.setAttribute("caseExact", caseExact);
    }

    @Override
    public List<String> getCanonicalValues() {
        return this.getSimpleArrayAttribute("canonicalValues");
    }

    public void setCanonicalValues(List<String> canonicalValues) {
        this.setStringAttributeList("canonicalValues", canonicalValues);
    }

    @Override
    public List<ReferenceTypes> getReferenceTypes() {
        return this.getSimpleArrayAttribute("referenceTypes").stream().map(ReferenceTypes::getByValue).collect(Collectors.toList());
    }

    public void setReferenceTypes(List<ReferenceTypes> referenceTypes) {
        this.setStringAttributeList("referenceTypes", referenceTypes.stream().map(ReferenceTypes::getValue).collect(Collectors.toList()));
    }

    public Optional<String> getResourceTypeReferenceName() {
        return this.getStringAttribute("resourceType");
    }

    public void setResourceTypeReferenceName(String resourceTypeReferenceName) {
        this.setAttribute("resourceType", resourceTypeReferenceName);
    }

    public Optional<Double> getMultipleOf() {
        return this.getDoubleAttribute("multipleOf");
    }

    public void setMultipleOf(double multipleOf) {
        if (!Type.INTEGER.equals((Object)this.getType()) && !Type.DECIMAL.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'multipleOf' is only applicable to 'integer' and 'decimal' types");
        }
        this.setAttribute("multipleOf", multipleOf);
    }

    public Optional<Double> getMinimum() {
        return this.getDoubleAttribute("minimum");
    }

    public void setMinimum(double minimum) {
        if (!Type.INTEGER.equals((Object)this.getType()) && !Type.DECIMAL.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'minimum' is only applicable to 'integer' and 'decimal' types");
        }
        this.setAttribute("minimum", minimum);
    }

    public Optional<Double> getMaximum() {
        return this.getDoubleAttribute("maximum");
    }

    public void setMaximum(double maximum) {
        if (!Type.INTEGER.equals((Object)this.getType()) && !Type.DECIMAL.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'maximum' is only applicable to 'integer' and 'decimal' types");
        }
        this.setAttribute("maximum", maximum);
    }

    public Optional<Long> getMaxLength() {
        return this.getLongAttribute("maxLength");
    }

    public void setMaxLength(Long maxLength) {
        if (!Type.STRING.equals((Object)this.getType()) && !Type.REFERENCE.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'maxLength' is only applicable to 'string' and 'reference' types");
        }
        this.setAttribute("maxLength", maxLength);
    }

    public Optional<Long> getMinLength() {
        return this.getLongAttribute("minLength");
    }

    public void setMinLength(Long minLength) {
        if (!Type.STRING.equals((Object)this.getType()) && !Type.REFERENCE.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'minLength' is only applicable to 'string' and 'reference' types");
        }
        this.setAttribute("minLength", minLength);
    }

    public Optional<Pattern> getPattern() {
        return Optional.ofNullable(this.pattern);
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            this.setAttribute("pattern", (String)null);
            return;
        }
        Type type = this.getType();
        if (Type.STRING.equals((Object)type) || Type.REFERENCE.equals((Object)type)) {
            try {
                this.pattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new InvalidSchemaException("the given pattern is not a valid regular expression '" + pattern + "'");
            }
        } else {
            throw new InvalidSchemaException("The attribute 'pattern' is only applicable to 'string' and 'reference' types");
        }
        this.setAttribute("pattern", pattern);
    }

    public Optional<Integer> getMinItems() {
        return this.getIntegerAttribute("minItems");
    }

    public void setMinItems(Integer minItems) {
        if (!this.isMultiValued()) {
            throw new InvalidSchemaException("The attribute 'minItems' is only applicable to 'multivalued' types");
        }
        this.setAttribute("minItems", minItems);
    }

    public Optional<Integer> getMaxItems() {
        return this.getIntegerAttribute("maxItems");
    }

    public void setMaxItems(Integer maxItems) {
        if (!this.isMultiValued()) {
            throw new InvalidSchemaException("The attribute 'maxItems' is only applicable to 'multivalued' types");
        }
        this.setAttribute("maxItems", maxItems);
    }

    public Optional<Instant> getNotBefore() {
        return this.getDateTimeAttribute("notBefore");
    }

    public void setNotBefore(String notBefore) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notBefore' is only applicable to 'dateTime' types");
        }
        this.setAttribute("notBefore", notBefore);
    }

    public void setNotBefore(Instant notBefore) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notBefore' is only applicable to 'dateTime' types");
        }
        this.setDateTimeAttribute("notBefore", notBefore);
    }

    public void setNotBefore(LocalDateTime notBefore) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notBefore' is only applicable to 'dateTime' types");
        }
        this.setDateTimeAttribute("notBefore", notBefore);
    }

    public void setNotBefore(OffsetDateTime notBefore) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notBefore' is only applicable to 'dateTime' types");
        }
        this.setDateTimeAttribute("notBefore", notBefore);
    }

    public Optional<Instant> getNotAfter() {
        return this.getDateTimeAttribute("notAfter");
    }

    public void setNotAfter(String notAfter) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notAfter' is only applicable to 'dateTime' types");
        }
        this.setAttribute("notAfter", notAfter);
    }

    public void setNotAfter(Instant notAfter) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notAfter' is only applicable to 'dateTime' types");
        }
        this.setDateTimeAttribute("notAfter", notAfter);
    }

    public void setNotAfter(LocalDateTime notAfter) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notAfter' is only applicable to 'dateTime' types");
        }
        this.setDateTimeAttribute("notAfter", notAfter);
    }

    public void setNotAfter(OffsetDateTime notAfter) {
        if (!Type.DATE_TIME.equals((Object)this.getType())) {
            throw new InvalidSchemaException("The attribute 'notAfter' is only applicable to 'dateTime' types");
        }
        this.setDateTimeAttribute("notAfter", notAfter);
    }

    public String getDefaultValue() {
        return this.getStringAttribute("defaultValue").orElse(null);
    }

    public void setDefaultValue(String defaultValue) {
        boolean doesDefaultValueApplyToType = this.validateDefaultValue(defaultValue);
        if (doesDefaultValueApplyToType) {
            this.setAttribute("defaultValue", defaultValue);
        } else {
            log.warn("Ignoring default value for attribute '{}' because the value '{}' does not apply to type '{}'", new Object[]{this.getName(), defaultValue, this.getType()});
        }
    }

    public List<SchemaAttribute> getSubAttributes() {
        return this.getArrayAttribute("subAttributes", SchemaAttribute.class);
    }

    private void setSubAttributes(List<SchemaAttribute> subAttributes) {
        this.setAttribute("subAttributes", subAttributes);
    }

    private List<SchemaAttribute> resolveSubAttributes(JsonNode jsonNode) {
        if (!Type.COMPLEX.equals((Object)this.getType())) {
            return Collections.emptyList();
        }
        ArrayList<SchemaAttribute> schemaAttributeList = new ArrayList<SchemaAttribute>();
        String subAttributeName = "subAttributes";
        String errorMessage = "missing attribute 'subAttributes' on '" + (Object)((Object)this.getType()) + "'-attribute with name: " + this.getName();
        ArrayNode subAttributesArray = JsonHelper.getArrayAttribute(jsonNode, "subAttributes").orElseThrow(() -> this.getException(errorMessage, null));
        HashSet<String> attributeNameSet = new HashSet<String>();
        boolean hasValueAttribute = false;
        boolean isResourceReference = false;
        for (JsonNode subAttribute : subAttributesArray) {
            SchemaAttribute schemaAttribute = new SchemaAttribute(this.schema, this.resourceUri, this, subAttribute, this.namePrefix);
            if (attributeNameSet.contains(schemaAttribute.getScimNodeName())) {
                String duplicateNameMessage = "The attribute with the name '" + schemaAttribute.getFullResourceName() + "' was found twice within the given schema declaration";
                throw new InvalidSchemaException(duplicateNameMessage, null, null, null);
            }
            if (!Mutability.READ_ONLY.equals((Object)this.getMutability())) {
                if ("value".equals(schemaAttribute.getName())) {
                    hasValueAttribute = true;
                }
                if ("$ref".equals(schemaAttribute.getName()) && schemaAttribute.getReferenceTypes().contains((Object)ReferenceTypes.RESOURCE)) {
                    isResourceReference = true;
                }
            }
            attributeNameSet.add(schemaAttribute.getScimNodeName());
            schemaAttributeList.add(schemaAttribute);
            this.subAttributes.put(schemaAttribute.getName().toLowerCase(), schemaAttribute);
        }
        if (hasValueAttribute && isResourceReference) {
            this.schema.getComplexBulkIdCandidates().add(this);
        }
        return schemaAttributeList;
    }

    private void validateAttribute() {
        Mutability mutability = this.getMutability();
        Returned returned = this.getReturned();
        if (Mutability.READ_ONLY.equals((Object)mutability) && Returned.NEVER.equals((Object)returned)) {
            String errorMessage = "The attribute with the name '" + this.getFullResourceName() + "' has an invalid declaration. mutability 'readOnly' and returned 'never' are an illegal combination. The client is not able to write to the given attribute and the server will never return it.";
            throw this.getException(errorMessage, null);
        }
        if (Mutability.WRITE_ONLY.equals((Object)mutability) && !Returned.NEVER.equals((Object)returned)) {
            String errorMessage = "The attribute with the name '" + this.getFullResourceName() + "' has an invalid declaration. mutability 'writeOnly' must have a returned value of 'never' are an illegal in combination. The client should only write to this attribute but should never have it returned. The mutability writeOnly makes only sense for sensitive application data like passwords or other secrets.";
            throw this.getException(errorMessage, null);
        }
        if (Type.BINARY.equals((Object)this.getType()) && !this.isCaseExact()) {
            String errorMessage = "The attribute with the name '" + this.getFullResourceName() + "' has an invalid declaration. Binaries have to be case-exact by definition.";
            throw this.getException(errorMessage, null);
        }
    }

    private InvalidSchemaException getException(String errorMessage, Exception cause) {
        return new InvalidSchemaException(errorMessage, (Throwable)cause, 500, null);
    }

    public List<SchemaAttribute> getParentHierarchy() {
        ArrayList<SchemaAttribute> parentHierarchy = new ArrayList<SchemaAttribute>();
        for (SchemaAttribute currentNode = this; currentNode != null; currentNode = currentNode.getParent()) {
            parentHierarchy.add(0, currentNode);
        }
        return parentHierarchy;
    }

    private boolean validateDefaultValue(String defaultValue) {
        try {
            switch (this.getType()) {
                case BOOLEAN: {
                    return StringUtils.equalsAnyIgnoreCase((CharSequence)defaultValue, (CharSequence[])new CharSequence[]{"true", "false"});
                }
                case INTEGER: {
                    Integer.parseInt(defaultValue);
                    return true;
                }
                case DECIMAL: {
                    Double.parseDouble(defaultValue);
                    return true;
                }
                case COMPLEX: 
                case BINARY: 
                case ANY: {
                    throw new InternalServerException(String.format("Invalid configuration. Default values are only supported for the following types: %s", Arrays.asList(Type.BOOLEAN, Type.INTEGER, Type.DECIMAL, Type.STRING, Type.REFERENCE, Type.DATE_TIME)));
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Generated
    public Schema getSchema() {
        return this.schema;
    }

    @Generated
    public SchemaAttribute getParent() {
        return this.parent;
    }

    @Generated
    public String getResourceUri() {
        return this.resourceUri;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaAttribute)) {
            return false;
        }
        SchemaAttribute other = (SchemaAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<SchemaAttribute> this$subAttributes = this.getSubAttributes();
        List<SchemaAttribute> other$subAttributes = other.getSubAttributes();
        if (this$subAttributes == null ? other$subAttributes != null : !((Object)this$subAttributes).equals(other$subAttributes)) {
            return false;
        }
        String this$resourceUri = this.getResourceUri();
        String other$resourceUri = other.getResourceUri();
        if (this$resourceUri == null ? other$resourceUri != null : !this$resourceUri.equals(other$resourceUri)) {
            return false;
        }
        String this$namePrefix = this.getNamePrefix();
        String other$namePrefix = other.getNamePrefix();
        if (this$namePrefix == null ? other$namePrefix != null : !this$namePrefix.equals(other$namePrefix)) {
            return false;
        }
        Optional<Pattern> this$pattern = this.getPattern();
        Optional<Pattern> other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchemaAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<SchemaAttribute> $subAttributes = this.getSubAttributes();
        result = result * 59 + ($subAttributes == null ? 43 : ((Object)$subAttributes).hashCode());
        String $resourceUri = this.getResourceUri();
        result = result * 59 + ($resourceUri == null ? 43 : $resourceUri.hashCode());
        String $namePrefix = this.getNamePrefix();
        result = result * 59 + ($namePrefix == null ? 43 : $namePrefix.hashCode());
        Optional<Pattern> $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
        return result;
    }
}

