/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.AttributeExtractor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class CaseInsensitiveAttributeExtractor
extends AttributeExtractor {
    private final Map<String, String> attributeMap = new HashMap<String, String>();

    public CaseInsensitiveAttributeExtractor(JsonNode jsonDocument) {
        super(jsonDocument);
    }

    @Override
    public Optional<JsonNode> getAttribute(SchemaAttribute schemaAttribute) {
        Object attribute = this.jsonDocument.get(schemaAttribute.getName());
        if (attribute != null) {
            this.attributeMap.put(schemaAttribute.getName().toLowerCase(), schemaAttribute.getName());
            return Optional.of(attribute);
        }
        attribute = this.extractAttributeByAttributeMap(schemaAttribute);
        if (((Optional)attribute).isPresent()) {
            return attribute;
        }
        if (this.attributeMap.size() == this.jsonDocument.size()) {
            return Optional.empty();
        }
        Iterator attributeNameIterator = this.jsonDocument.fieldNames();
        while (attributeNameIterator.hasNext()) {
            String attributeName = (String)attributeNameIterator.next();
            this.attributeMap.put(attributeName.toLowerCase(), attributeName);
        }
        return this.extractAttributeByAttributeMap(schemaAttribute);
    }

    private Optional<JsonNode> extractAttributeByAttributeMap(SchemaAttribute schemaAttribute) {
        String attributeName = this.attributeMap.get(schemaAttribute.getName().toLowerCase());
        if (attributeName == null) {
            return Optional.empty();
        }
        JsonNode attribute = this.jsonDocument.get(attributeName);
        return Optional.of(attribute);
    }
}

