/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public abstract class ScimResponse
extends AbstractSchemasHolder {
    private Map<String, String> httpHeaders = new HashMap<String, String>();

    public ScimResponse(JsonNode responseNode) {
        if (responseNode != null) {
            responseNode.fields().forEachRemaining(childNode -> this.set((String)childNode.getKey(), (JsonNode)childNode.getValue()));
        }
        this.httpHeaders.put("Content-Type", "application/scim+json");
    }

    protected void setETag(Meta meta) {
        if (meta != null && meta.getVersion().isPresent()) {
            this.getHttpHeaders().put("ETag", meta.getVersion().get().getEntityTag());
        }
    }

    public Response buildResponse() {
        Response.ResponseBuilder responseBuilder = Response.status((int)this.getHttpStatus());
        this.httpHeaders.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)responseBuilder).header(arg_0, arg_1));
        if (this.size() != 0) {
            responseBuilder.entity((Object)this.toString());
        }
        return responseBuilder.build();
    }

    public abstract int getHttpStatus();

    protected ScimResponse() {
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }
}

