/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.utils;

import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import java.math.BigDecimal;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;

public final class AttributeValidator {
    public static void validateTextNode(SchemaAttribute schemaAttribute, String value) {
        if (schemaAttribute == null) {
            return;
        }
        if (Type.STRING.equals((Object)schemaAttribute.getType()) || Type.REFERENCE.equals((Object)schemaAttribute.getType())) {
            AttributeValidator.validateStringTypes(schemaAttribute, value);
        } else if (Type.DATE_TIME.equals((Object)schemaAttribute.getType())) {
            AttributeValidator.validateDateTimeTypes(schemaAttribute, value);
        }
    }

    private static void validateDateTimeTypes(SchemaAttribute schemaAttribute, String value) {
        schemaAttribute.getNotBefore().ifPresent(notBefore -> {
            Instant val = TimeUtils.parseDateTime(value);
            if (val.isBefore((Instant)notBefore)) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' must not be before '" + notBefore.toString() + "' but was '" + val.toString() + "'", 400, "invalidValue");
            }
        });
        schemaAttribute.getNotAfter().ifPresent(notAfter -> {
            Instant val = TimeUtils.parseDateTime(value);
            if (val.isAfter((Instant)notAfter)) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' must not be after '" + notAfter.toString() + "' but was '" + val.toString() + "'", 400, "invalidValue");
            }
        });
    }

    private static void validateStringTypes(SchemaAttribute schemaAttribute, String value) {
        schemaAttribute.getMinLength().ifPresent(minLength -> {
            if (minLength > (long)StringUtils.length((CharSequence)value)) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' has a minimum length of " + minLength + " characters but value is '" + value + "'", 400, "invalidValue");
            }
        });
        schemaAttribute.getMaxLength().ifPresent(maxLength -> {
            if (maxLength < (long)StringUtils.length((CharSequence)value)) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' has a maximum length of " + maxLength + " characters but value is '" + value + "'", 400, "invalidValue");
            }
        });
        schemaAttribute.getPattern().ifPresent(pattern -> {
            if (!pattern.matcher(value).matches()) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' must match the regular expression '" + pattern.pattern() + "' but value is '" + value + "'", 400, "invalidValue");
            }
        });
    }

    public static void validateNumberNode(SchemaAttribute schemaAttribute, double value) {
        if (schemaAttribute == null) {
            return;
        }
        schemaAttribute.getMinimum().ifPresent(minimum -> {
            if (minimum > value) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' has a minimum value of " + minimum + " but value is '" + value + "'", 400, "invalidValue");
            }
        });
        schemaAttribute.getMaximum().ifPresent(maximum -> {
            if (maximum < value) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' has a maximum value of " + maximum + " but value is '" + value + "'", 400, "invalidValue");
            }
        });
        schemaAttribute.getMultipleOf().ifPresent(multipleOf -> {
            if (BigDecimal.valueOf(value).remainder(BigDecimal.valueOf(multipleOf)).doubleValue() != 0.0) {
                throw new DocumentValidationException("the attribute '" + schemaAttribute.getScimNodeName() + "' must be multiple of " + multipleOf + " but value is '" + value + "'", 400, "invalidValue");
            }
        });
    }

    public static void validateArrayNode(SchemaAttribute schemaAttribute, ArrayNode arrayNode) {
        if (schemaAttribute == null) {
            return;
        }
        schemaAttribute.getMinItems().ifPresent(minItems -> {
            if (minItems > arrayNode.size()) {
                throw new DocumentValidationException("the multivalued attribute '" + schemaAttribute.getScimNodeName() + "' must have at least " + minItems + " items but array has " + arrayNode.size() + " items and is: " + arrayNode.toString(), 400, "invalidValue");
            }
        });
        schemaAttribute.getMaxItems().ifPresent(maxItems -> {
            if (maxItems < arrayNode.size()) {
                throw new DocumentValidationException("the multivalued attribute '" + schemaAttribute.getScimNodeName() + "' must not have more than " + maxItems + " items but array has " + arrayNode.size() + " items and is: " + arrayNode.toString(), 400, "invalidValue");
            }
        });
    }

    private AttributeValidator() {
    }
}

