/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.etag;

import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ETag
extends ScimTextNode {
    public static final String WEAK_IDENTIFIER = "W/";
    private boolean weak;
    private String tag;

    public ETag(Boolean weak, String tag) {
        super(null, ETag.getEntityTag(weak == null ? true : weak, tag));
        if (StringUtils.contains((CharSequence)tag, (CharSequence)"\"")) {
            throw new BadRequestException("Please omit the quotes in the entity tag value '" + tag + "'", null, "invalidValue");
        }
        this.weak = weak == null ? true : weak;
        this.tag = tag;
    }

    public static ETag newInstance(String version) {
        return ETag.parseETag(version);
    }

    public static ETag parseETag(String version) {
        int numberOfQuotes = StringUtils.countMatches((CharSequence)version, (CharSequence)"\"");
        if (numberOfQuotes != 0 && numberOfQuotes != 2) {
            throw new BadRequestException("invalid entity tag value. Value was '" + version + "'. Value has a irregular number of quotes '" + numberOfQuotes + "'. Please take a look into RFC7232 for more detailed information of entity tags", null, "invalidValue");
        }
        boolean weak = StringUtils.startsWith((CharSequence)version, (CharSequence)WEAK_IDENTIFIER) || !StringUtils.startsWith((CharSequence)version, (CharSequence)"\"");
        String tag = Optional.ofNullable(StringUtils.stripToNull((String)version)).map(s -> s.replaceFirst("^(W/)?\"(.*?)\"", "$2")).orElse(null);
        return ETag.builder().weak(weak).tag(StringUtils.isBlank((CharSequence)tag) ? null : tag).build();
    }

    private static String getEntityTag(boolean weak, String tag) {
        String eTag = "\"" + StringUtils.stripToEmpty((String)tag) + "\"";
        return Optional.ofNullable(tag).map(s -> weak ? WEAK_IDENTIFIER + eTag : eTag).orElse(weak ? "W/\"\"" : "\"\"");
    }

    public String getEntityTag() {
        return this.textValue();
    }

    public String toString() {
        return this.getEntityTag();
    }

    public String toPrettyString() {
        return this.getEntityTag();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ETag)) {
            return false;
        }
        ETag other = (ETag)o;
        if (this.isWeak()) {
            return this.tag.equals(other.getTag());
        }
        return this.getEntityTag().equals(other.getEntityTag());
    }

    public static ETagBuilder builder() {
        return new ETagBuilder();
    }

    public boolean isWeak() {
        return this.weak;
    }

    public String getTag() {
        return this.tag;
    }

    public static class ETagBuilder {
        private Boolean weak;
        private String tag;

        ETagBuilder() {
        }

        public ETagBuilder weak(Boolean weak) {
            this.weak = weak;
            return this;
        }

        public ETagBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ETag build() {
            return new ETag(this.weak, this.tag);
        }

        public String toString() {
            return "ETag.ETagBuilder(weak=" + this.weak + ", tag=" + this.tag + ")";
        }
    }
}

