/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.constants.enums;

import de.captaingoldfish.scim.sdk.common.exceptions.UnknownValueException;
import org.apache.commons.lang3.StringUtils;

public enum Type {
    ANY("any"),
    STRING("string"),
    COMPLEX("complex"),
    BOOLEAN("boolean"),
    DECIMAL("decimal"),
    INTEGER("integer"),
    DATE_TIME("dateTime"),
    REFERENCE("reference");

    private String value;

    private Type(String value) {
        this.value = value;
    }

    public static Type getByValue(String value) {
        for (Type type : Type.values()) {
            if (!StringUtils.equals((CharSequence)value, (CharSequence)type.getValue())) continue;
            return type;
        }
        throw new UnknownValueException("value '" + value + "' could not be resolved to type: " + Type.class, null, null, null);
    }

    public String getValue() {
        return this.value;
    }
}

