package de.charlex.compose.bottomdrawerscaffold

import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp

object BottomDrawerScaffoldDefaults {

    /**
     * The default elevation used by [BottomDrawerScaffold].
     */
    val DrawerTonalElevation = 8.dp

    /**
     * The default elevation used by [BottomDrawerScaffold].
     */
    val DrawerShadowElevation = 0.dp

    /**
     * The default peek height used by [BottomDrawerScaffold].
     */
    val DrawerPeekHeight = 56.dp

    @Composable
    fun scrimColor(opacity: Float = ScrimOpacity): Color {
        return MaterialTheme.colorScheme.onSurface.copy(alpha = opacity)
    }

    val ScrimOpacity = 0.32f
}
