package de.charlex.compose.bottomdrawerscaffold

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.semantics.contentDescription
import androidx.compose.ui.semantics.onClick
import androidx.compose.ui.semantics.semantics

@Composable
fun Scrim(
    open: Boolean,
    onClose: () -> Unit,
    fraction: () -> Float,
    color: Color
) {
    val dismissDrawer = if (open) {
        Modifier
            .pointerInput(onClose) { detectTapGestures { onClose() } }
            .semantics(mergeDescendants = true) {
                contentDescription = "close drawer"
                onClick { onClose(); true }
            }
    } else {
        Modifier
    }

    val fraction = fraction()

    if(fraction > 0f) {
        Canvas(
            Modifier
                .fillMaxSize()
                .then(dismissDrawer)
        ) {
            drawRect(color, alpha = fraction())
        }
    }
}
