/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.asn1;

import de.christofreichardt.asn1.ASN1;
import java.util.Arrays;
import java.util.HexFormat;

public final class ASN1Integer
extends ASN1 {
    static final int tag = 2;

    public ASN1Integer(byte[] bytes) {
        super(bytes);
        if (this.bytes[0] != 2) {
            throw new IllegalArgumentException("Wrong tag: 0x%02x. ASN.1 INTEGER expected.".formatted(bytes[0]));
        }
    }

    public ASN1Integer(byte[] bytes, int from) {
        this(Arrays.copyOfRange(bytes, from, bytes.length));
    }

    public String toString() {
        return HexFormat.ofDelimiter(" ").withPrefix("0x").formatHex(this.encoded());
    }

    public static ASN1Integer encode(byte[] bytes) {
        if (bytes.length <= 127) {
            byte[] encoded = new byte[bytes.length + 2];
            encoded[0] = 2;
            encoded[1] = (byte)bytes.length;
            System.arraycopy(bytes, 0, encoded, 2, bytes.length);
            return new ASN1Integer(encoded);
        }
        throw new UnsupportedOperationException("ToDo.");
    }
}

