/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.function.Supplier;

public class JsonUtils {
    private JsonUtils() {
    }

    public static <T extends JsonValue> T orElseThrow(JsonObject jsonObject, String key, Class<T> jsonType) {
        return JsonUtils.orElseThrow(jsonObject, key, jsonType, () -> new IllegalArgumentException());
    }

    static <T extends JsonValue, X extends RuntimeException> T orElseThrow(JsonObject jsonObject, String key, Class<T> jsonType, Supplier<? extends X> exceptionSupplier) {
        Map<Class<JsonString>, JsonValue.ValueType> types = Map.of(JsonString.class, JsonValue.ValueType.STRING);
        if (!types.containsKey(jsonType)) {
            throw new UnsupportedOperationException();
        }
        JsonValue.ValueType valueType = types.get(jsonType);
        if (!jsonObject.containsKey((Object)key) || ((JsonValue)jsonObject.get((Object)key)).getValueType() != valueType) {
            throw (RuntimeException)exceptionSupplier.get();
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)key);
        return (T)jsonValue;
    }
}

