/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.webkey;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.webkey.JsonWebKeyPair;
import de.christofreichardt.json.webkey.JsonWebPublicKey;
import de.christofreichardt.json.webkey.JsonWebSecretKey;
import de.christofreichardt.json.webkey.NamedECParameterSpec;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class JsonWebKey
implements Traceable {
    public static final Map<String, ECParameterSpec> EC_PARAMETER_SPEC_MAP;
    public static final ECParameterSpec SECP256R1;
    public static final ECParameterSpec SECP521R1;
    static final Base64.Encoder BASE64_URL_ENCODER;
    static final Base64.Decoder BASE64_URL_DECODER;
    final String kid;
    final String keyType;

    public static <T extends JsonWebKey> T fromJson(JsonObject webKeyView, Class<T> clazz) throws GeneralSecurityException {
        if (JsonWebPublicKey.class.isAssignableFrom(clazz)) {
            JsonWebPublicKey t = JsonWebPublicKey.fromJson(webKeyView);
            return (T)t;
        }
        if (JsonWebKeyPair.class.isAssignableFrom(clazz)) {
            JsonWebKeyPair t = JsonWebKeyPair.fromJson(webKeyView);
            return (T)t;
        }
        if (JsonWebSecretKey.class.isAssignableFrom(clazz)) {
            JsonWebSecretKey t = JsonWebSecretKey.fromJson(webKeyView);
            return (T)t;
        }
        throw new UnsupportedOperationException();
    }

    public String getKid() {
        return this.kid;
    }

    public String getKeyType() {
        return this.keyType;
    }

    JsonWebKey(String kid, String keyType) {
        this.kid = kid;
        this.keyType = keyType;
    }

    public String toString() {
        return String.format("JsonWebKey[class=%s, kid=%s]", this.getClass().getSimpleName(), this.kid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject toJson() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("JsonObject", (Object)this, "toJson()");
        try {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("kty", this.keyType);
            if (Objects.nonNull(this.kid)) {
                jsonObjectBuilder.add("kid", this.kid);
            }
            JsonObject jsonObject = jsonObjectBuilder.build();
            return jsonObject;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }

    static {
        BigInteger p = new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853951");
        ECFieldFp ecFieldFp = new ECFieldFp(p);
        BigInteger a = new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853948");
        BigInteger b = new BigInteger("41058363725152142129326129780047268409114441015993725554835256314039467401291");
        EllipticCurve secp256r1 = new EllipticCurve(ecFieldFp, a, b);
        ECPoint generator = new ECPoint(new BigInteger("48439561293906451759052585252797914202762949526041747995844080717082404635286"), new BigInteger("36134250956749795798585127919587881956611106672985015071877198253568414405109"));
        BigInteger order = new BigInteger("115792089210356248762697446949407573529996955224135760342422259061068512044369");
        SECP256R1 = new NamedECParameterSpec("secp256r1 [NIST P-256,X9.62 prime256v1] (1.2.840.10045.3.1.7)", secp256r1, generator, order, 1);
        p = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151");
        ecFieldFp = new ECFieldFp(p);
        a = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057148");
        b = new BigInteger("1093849038073734274511112390766805569936207598951683748994586394495953116150735016013708737573759623248592132296706313309438452531591012912142327488478985984");
        EllipticCurve secp521r1 = new EllipticCurve(ecFieldFp, a, b);
        generator = new ECPoint(new BigInteger("2661740802050217063228768716723360960729859168756973147706671368418802944996427808491545080627771902352094241225065558662157113545570916814161637315895999846"), new BigInteger("3757180025770020463545507224491183603594455134769762486694567779615544477440556316691234405012945539562144444537289428522585666729196580810124344277578376784"));
        order = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449");
        SECP521R1 = new NamedECParameterSpec("secp521r1 [NIST P-521] (1.3.132.0.35)", secp521r1, generator, order, 1);
        BASE64_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
        BASE64_URL_DECODER = Base64.getUrlDecoder();
        EC_PARAMETER_SPEC_MAP = Map.of("secp256r1", SECP256R1, "secp521r1", SECP521R1);
    }

    public static abstract class Builder<T extends Builder<T>> {
        String kid = null;

        public T withKid(String kid) {
            this.kid = kid;
            Builder t = this;
            return (T)t;
        }

        abstract JsonWebKey build() throws GeneralSecurityException;
    }
}

