/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.webkey;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.json.JsonUtils;
import de.christofreichardt.json.webkey.JsonWebKey;
import de.christofreichardt.json.webkey.JsonWebKeyUtils;
import de.christofreichardt.json.webkey.JsonWebPublicKey;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Objects;

public final class JsonWebKeyPair
extends JsonWebKey {
    final KeyPair keyPair;
    final AlgorithmParameterSpec algorithmParameterSpec;

    public static Builder of() {
        return new Builder();
    }

    public static KeyPairBuilder of(KeyPair keyPair) {
        return new KeyPairBuilder(keyPair);
    }

    public static ParameterSpecBuilder of(AlgorithmParameterSpec algorithmParameterSpec) {
        return new ParameterSpecBuilder(algorithmParameterSpec);
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    JsonWebKeyPair(Builder builder) {
        super(builder.kid, builder.keyPair.getPublic().getAlgorithm());
        this.keyPair = builder.keyPair;
        PublicKey publicKey = this.keyPair.getPublic();
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            this.algorithmParameterSpec = ecPublicKey.getParams();
        } else {
            this.algorithmParameterSpec = null;
        }
    }

    JsonWebKeyPair(KeyPairBuilder keyPairBuilder) {
        super(keyPairBuilder.kid, keyPairBuilder.keyPair.getPublic().getAlgorithm());
        this.keyPair = keyPairBuilder.keyPair;
        PublicKey publicKey = this.keyPair.getPublic();
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            this.algorithmParameterSpec = ecPublicKey.getParams();
        } else {
            this.algorithmParameterSpec = null;
        }
    }

    JsonWebKeyPair(ParameterSpecBuilder parameterSpecBuilder) {
        super(parameterSpecBuilder.kid, parameterSpecBuilder.keyPair.getPublic().getAlgorithm());
        this.keyPair = parameterSpecBuilder.keyPair;
        PublicKey publicKey = this.keyPair.getPublic();
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            this.algorithmParameterSpec = ecPublicKey.getParams();
        } else {
            this.algorithmParameterSpec = null;
        }
    }

    public JsonWebPublicKey jsonWebPublicKey() throws GeneralSecurityException {
        return JsonWebPublicKey.fromJson(this.toJson());
    }

    @Override
    public String toString() {
        String params = null;
        AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            params = ecParameterSpec.toString();
        }
        return String.format("%s[kid=%s, keyType=%s, params=%s]", this.getClass().getSimpleName(), this.kid, this.keyType, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean equals(Object object) {
        tracer = this.getCurrentTracer();
        tracer.entry("boolean", (Object)this, "equals(Object object)");
        try {
            if (this == object) {
                var3_3 = true;
                return var3_3;
            }
            if (object == null || this.getClass() != object.getClass()) {
                var3_4 = false;
                return var3_4;
            }
            that = (JsonWebKeyPair)object;
            tracer.out().printfIndentln("this.keyPair.getPublic().getClass().getName() = %s, that.keyPair.getPublic().getClass().getName() = %s", new Object[]{this.keyPair.getPublic().getClass().getName(), that.keyPair.getPublic().getClass().getName()});
            tracer.out().printfIndentln("this.keyPair.getPrivate().getClass().getName() = %s, that.keyPair.getPrivate().getClass().getName() = %s", new Object[]{this.keyPair.getPrivate().getClass().getName(), that.keyPair.getPrivate().getClass().getName()});
            privateExponent1 = null;
            privateExponent2 = null;
            var9_8 = this.keyPair.getPrivate();
            if (var9_8 instanceof RSAPrivateCrtKey) {
                rsaPrivateCrtKey = (RSAPrivateCrtKey)var9_8;
                privateExponent1 = rsaPrivateCrtKey.getPrivateExponent();
            } else {
                var9_8 = this.keyPair.getPrivate();
                if (var9_8 instanceof RSAPrivateKey) {
                    rsaPrivateKey = (RSAPrivateKey)var9_8;
                    privateExponent1 = rsaPrivateKey.getPrivateExponent();
                }
            }
            var9_8 = that.keyPair.getPrivate();
            if (var9_8 instanceof RSAPrivateCrtKey) {
                rsaPrivateCrtKey = (RSAPrivateCrtKey)var9_8;
                privateExponent2 = rsaPrivateCrtKey.getPrivateExponent();
            } else {
                var9_8 = that.keyPair.getPrivate();
                if (var9_8 instanceof RSAPrivateKey) {
                    rsaPrivateKey = (RSAPrivateKey)var9_8;
                    privateExponent2 = rsaPrivateKey.getPrivateExponent();
                }
            }
            isPrivateKeyTheSame = Objects.nonNull(privateExponent1) != false && Objects.nonNull(privateExponent2) != false ? privateExponent1.equals(privateExponent2) : (Objects.nonNull(privateExponent1) != false ? false : (Objects.nonNull(privateExponent2) != false ? false : this.keyPair.getPrivate().equals(that.keyPair.getPrivate())));
            var10_14 = this.algorithmParameterSpec;
            if (!(var10_14 instanceof ECParameterSpec)) ** GOTO lbl-1000
            ecParameterSpec1 = (ECParameterSpec)var10_14;
            var10_14 = that.algorithmParameterSpec;
            if (var10_14 instanceof ECParameterSpec) {
                ecParameterSpec2 = (ECParameterSpec)var10_14;
                tracer.out().printfIndentln("ecParameterSpec1.getClass().getName() = %s", new Object[]{ecParameterSpec1.getClass().getName()});
                tracer.out().printfIndentln("ecParameterSpec2.getClass().getName() = %s", new Object[]{ecParameterSpec2.getClass().getName()});
                isAlgoTheSame = Objects.equals(ecParameterSpec1.toString(), ecParameterSpec2.toString());
            } else if (this.algorithmParameterSpec instanceof ECParameterSpec) {
                isAlgoTheSame = false;
            } else if (that.algorithmParameterSpec instanceof ECParameterSpec) {
                isAlgoTheSame = false;
            } else if (Objects.isNull(this.algorithmParameterSpec) && Objects.isNull(that.algorithmParameterSpec)) {
                isAlgoTheSame = true;
            } else {
                throw new IllegalArgumentException();
            }
            var8_12 = Objects.equals(this.keyPair.getPublic(), that.keyPair.getPublic()) != false && isPrivateKeyTheSame != false && isAlgoTheSame != false && Objects.equals(this.kid, that.kid) != false && Objects.equals(this.keyType, that.keyType) != false;
            return var8_12;
        }
        finally {
            tracer.wayout();
        }
    }

    public int hashCode() {
        RSAPrivateKey rsaPrivateKey;
        AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            PrivateKey privateKey = this.keyPair.getPrivate();
            if (privateKey instanceof RSAPrivateKey) {
                rsaPrivateKey = (RSAPrivateKey)privateKey;
                return Objects.hash(this.keyPair.getPublic(), rsaPrivateKey.getPrivateExponent(), ecParameterSpec.toString(), this.kid, this.keyType);
            }
            return Objects.hash(this.keyPair.getPublic(), this.keyPair.getPrivate(), ecParameterSpec.toString(), this.kid, this.keyType);
        }
        PrivateKey privateKey = this.keyPair.getPrivate();
        if (privateKey instanceof RSAPrivateKey) {
            rsaPrivateKey = (RSAPrivateKey)privateKey;
            return Objects.hash(this.keyPair.getPublic(), rsaPrivateKey.getPrivateExponent(), this.algorithmParameterSpec, this.kid, this.keyType);
        }
        return Objects.hash(this.keyPair.getPublic(), this.keyPair.getPrivate(), this.algorithmParameterSpec, this.kid, this.keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject toJson() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("JsonObject", (Object)this, "toJson()");
        try {
            Object modulusBytes;
            PublicKey publicKey;
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder((JsonObject)super.toJson());
            AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                String curve;
                ECParameterSpec ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
                if (ecParameterSpec.toString().startsWith("secp256r1")) {
                    curve = "P-256";
                } else if (ecParameterSpec.toString().startsWith("secp521r1")) {
                    curve = "P-521";
                } else if (ecParameterSpec.toString().startsWith("secp384r1")) {
                    curve = "P-384";
                } else {
                    throw new UnsupportedOperationException("Unknown curve specification: %s".formatted(ecParameterSpec.toString()));
                }
                jsonObjectBuilder.add("crv", curve);
            }
            if ((publicKey = this.keyPair.getPublic()) instanceof ECPublicKey) {
                ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
                if (ecPublicKey.getW().getAffineX().signum() == -1 || ecPublicKey.getW().getAffineY().signum() == -1) {
                    throw new ArithmeticException();
                }
                int fieldSize = (int)Math.ceil((double)ecPublicKey.getParams().getCurve().getField().getFieldSize() / 8.0);
                tracer.out().printfIndentln("fieldSize(Bytes) = %d", new Object[]{fieldSize});
                byte[] xBytes = JsonWebKeyUtils.alignBytes(ecPublicKey.getW().getAffineX().toByteArray(), fieldSize);
                byte[] yBytes = JsonWebKeyUtils.alignBytes(ecPublicKey.getW().getAffineY().toByteArray(), fieldSize);
                jsonObjectBuilder.add("x", BASE64_URL_ENCODER.encodeToString(xBytes)).add("y", BASE64_URL_ENCODER.encodeToString(yBytes));
            } else {
                PublicKey fieldSize = this.keyPair.getPublic();
                if (fieldSize instanceof RSAPublicKey) {
                    RSAPublicKey rsaPublicKey = (RSAPublicKey)fieldSize;
                    int keySize = rsaPublicKey.getModulus().bitLength();
                    tracer.out().printfIndentln("keySize = %d", new Object[]{keySize});
                    modulusBytes = JsonWebKeyUtils.skipSurplusZeroes(rsaPublicKey.getModulus().toByteArray(), keySize / 8);
                    tracer.out().printfIndentln("#(modulusBytes) = %d, octets(modulusBytes) = %s", new Object[]{((byte[])modulusBytes).length, JsonWebKeyUtils.formatBytes(modulusBytes)});
                    byte[] publicExponentBytes = JsonWebKeyUtils.skipLeadingZeroes(rsaPublicKey.getPublicExponent().toByteArray());
                    tracer.out().printfIndentln("octets(publicExponentBytes) = %s", new Object[]{JsonWebKeyUtils.formatBytes(publicExponentBytes)});
                    jsonObjectBuilder.add("n", BASE64_URL_ENCODER.encodeToString((byte[])modulusBytes)).add("e", BASE64_URL_ENCODER.encodeToString(publicExponentBytes));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            modulusBytes = this.keyPair.getPrivate();
            if (modulusBytes instanceof ECPrivateKey) {
                ECPrivateKey ecPrivateKey = (ECPrivateKey)modulusBytes;
                order = ecPrivateKey.getParams().getOrder();
                int bytesLen = (int)Math.ceil((double)((BigInteger)order).bitLength() / 8.0);
                tracer.out().printfIndentln("bytesLen = %d", new Object[]{bytesLen});
                byte[] dBytes = JsonWebKeyUtils.alignBytes(ecPrivateKey.getS().toByteArray(), bytesLen);
                jsonObjectBuilder.add("d", BASE64_URL_ENCODER.encodeToString(dBytes));
            } else {
                order = this.keyPair.getPrivate();
                if (order instanceof RSAPrivateKey) {
                    RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)order;
                    byte[] privateExponentBytes = JsonWebKeyUtils.skipLeadingZeroes(rsaPrivateKey.getPrivateExponent().toByteArray());
                    tracer.out().printfIndentln("octets(privateExponentBytes) = %s", new Object[]{JsonWebKeyUtils.formatBytes(privateExponentBytes)});
                    jsonObjectBuilder.add("d", BASE64_URL_ENCODER.encodeToString(privateExponentBytes));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            JsonObject jsonObject = jsonObjectBuilder.build();
            return jsonObject;
        }
        finally {
            tracer.wayout();
        }
    }

    public static JsonWebKeyPair fromJson(JsonObject jwkView) throws GeneralSecurityException {
        String keyType;
        return switch (keyType = JsonUtils.orElseThrow(jwkView, "kty", JsonString.class).getString()) {
            case "EC" -> {
                String curve = JsonUtils.orElseThrow(jwkView, "crv", JsonString.class).getString();
                if (curve.startsWith("secp256r1") || Objects.equals("P-256", curve)) {
                    curve = "secp256r1";
                } else if (curve.startsWith("secp521r1") || Objects.equals("P-521", curve)) {
                    curve = "secp521r1";
                } else {
                    throw new UnsupportedOperationException();
                }
                ECParameterSpec ecParameterSpec = (ECParameterSpec)EC_PARAMETER_SPEC_MAP.get(curve);
                BigInteger x = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "x", JsonString.class).getString()));
                BigInteger y = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "y", JsonString.class).getString()));
                BigInteger d = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "d", JsonString.class).getString()));
                ECPoint w = new ECPoint(x, y);
                ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(w, ecParameterSpec);
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                PublicKey publicKey = keyFactory.generatePublic(ecPublicKeySpec);
                ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
                PrivateKey privateKey = keyFactory.generatePrivate(ecPrivateKeySpec);
                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                String kid = jwkView.getString("kid", null);
                yield ((KeyPairBuilder)JsonWebKeyPair.of(keyPair).withKid(kid)).build();
            }
            case "RSA" -> {
                BigInteger n = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "n", JsonString.class).getString()));
                BigInteger e = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "e", JsonString.class).getString()));
                BigInteger d = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "d", JsonString.class).getString()));
                RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(n, e);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
                RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(n, d);
                PrivateKey privateKey = keyFactory.generatePrivate(rsaPrivateKeySpec);
                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                String kid = jwkView.getString("kid", null);
                yield ((KeyPairBuilder)JsonWebKeyPair.of(keyPair).withKid(kid)).build();
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    public static class Builder
    extends JsonWebKey.Builder<Builder> {
        KeyPair keyPair;
        SecureRandom secureRandom;
        final AlgorithmParameterSpec algorithmGenParameterSpec = new ECGenParameterSpec("secp256r1");

        @Override
        public JsonWebKeyPair build() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            if (Objects.nonNull(this.secureRandom)) {
                keyPairGenerator.initialize(this.algorithmGenParameterSpec, this.secureRandom);
            } else {
                keyPairGenerator.initialize(this.algorithmGenParameterSpec);
            }
            this.keyPair = keyPairGenerator.generateKeyPair();
            return new JsonWebKeyPair(this);
        }

        public Builder withSecureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }
    }

    public static class KeyPairBuilder
    extends JsonWebKey.Builder<KeyPairBuilder> {
        final KeyPair keyPair;

        public KeyPairBuilder(KeyPair keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public JsonWebKeyPair build() {
            return new JsonWebKeyPair(this);
        }
    }

    public static class ParameterSpecBuilder
    extends JsonWebKey.Builder<ParameterSpecBuilder> {
        final AlgorithmParameterSpec algorithmParameterSpec;
        KeyPair keyPair;
        SecureRandom secureRandom;

        public ParameterSpecBuilder(AlgorithmParameterSpec algorithmParameterSpec) {
            this.algorithmParameterSpec = algorithmParameterSpec;
        }

        public ParameterSpecBuilder withSecureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        @Override
        public JsonWebKeyPair build() throws GeneralSecurityException {
            KeyPairGenerator keyPairGenerator;
            if (this.algorithmParameterSpec instanceof ECGenParameterSpec) {
                keyPairGenerator = KeyPairGenerator.getInstance("EC");
            } else if (this.algorithmParameterSpec instanceof ECParameterSpec) {
                keyPairGenerator = KeyPairGenerator.getInstance("EC");
            } else if (this.algorithmParameterSpec instanceof RSAKeyGenParameterSpec) {
                keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            } else {
                throw new InvalidAlgorithmParameterException();
            }
            if (Objects.nonNull(this.secureRandom)) {
                keyPairGenerator.initialize(this.algorithmParameterSpec, this.secureRandom);
            } else {
                keyPairGenerator.initialize(this.algorithmParameterSpec);
            }
            this.keyPair = keyPairGenerator.generateKeyPair();
            return new JsonWebKeyPair(this);
        }
    }
}

