/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.webkey;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.json.JsonUtils;
import de.christofreichardt.json.webkey.JsonWebKey;
import de.christofreichardt.json.webkey.JsonWebKeyUtils;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Objects;

public final class JsonWebPublicKey
extends JsonWebKey {
    final PublicKey publicKey;
    final AlgorithmParameterSpec algorithmParameterSpec;

    public static Builder of(PublicKey publicKey) {
        return new Builder(publicKey);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    JsonWebPublicKey(Builder builder) {
        super(builder.kid, builder.publicKey.getAlgorithm());
        PublicKey publicKey = this.publicKey = builder.publicKey;
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            this.algorithmParameterSpec = ecPublicKey.getParams();
        } else {
            this.algorithmParameterSpec = null;
        }
    }

    @Override
    public String toString() {
        String params = null;
        AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            params = ecParameterSpec.toString();
        }
        return String.format("%s[kid=%s, keyType=%s, params=%s]", this.getClass().getSimpleName(), this.kid, this.keyType, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean equals(Object object) {
        tracer = this.getCurrentTracer();
        tracer.entry("boolean", (Object)this, "equals(Object object)");
        try {
            if (this == object) {
                var3_3 = true;
                return var3_3;
            }
            if (object == null || this.getClass() != object.getClass()) {
                var3_4 = false;
                return var3_4;
            }
            that = (JsonWebPublicKey)object;
            tracer.out().printfIndentln("this.publicKey.getClass().getName() = %s, that.publicKey.getClass().getName() = %s", new Object[]{this.publicKey.getClass().getName(), that.publicKey.getClass().getName()});
            var7_6 = this.algorithmParameterSpec;
            if (!(var7_6 instanceof ECParameterSpec)) ** GOTO lbl-1000
            ecParameterSpec1 = (ECParameterSpec)var7_6;
            var7_6 = that.algorithmParameterSpec;
            if (var7_6 instanceof ECParameterSpec) {
                ecParameterSpec2 = (ECParameterSpec)var7_6;
                tracer.out().printfIndentln("ecParameterSpec1.getClass().getName() = %s", new Object[]{ecParameterSpec1.getClass().getName()});
                tracer.out().printfIndentln("ecParameterSpec2.getClass().getName() = %s", new Object[]{ecParameterSpec2.getClass().getName()});
                isAlgoTheSame = Objects.equals(ecParameterSpec1.toString(), ecParameterSpec2.toString());
            } else if (this.algorithmParameterSpec instanceof ECParameterSpec) {
                isAlgoTheSame = false;
            } else if (that.algorithmParameterSpec instanceof ECParameterSpec) {
                isAlgoTheSame = false;
            } else if (Objects.isNull(this.algorithmParameterSpec) && Objects.isNull(that.algorithmParameterSpec)) {
                isAlgoTheSame = true;
            } else {
                throw new IllegalArgumentException();
            }
            var5_8 = Objects.equals(this.publicKey, that.publicKey) != false && isAlgoTheSame != false && Objects.equals(this.kid, that.kid) != false && Objects.equals(this.keyType, that.keyType) != false;
            return var5_8;
        }
        finally {
            tracer.wayout();
        }
    }

    public int hashCode() {
        AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            return Objects.hash(this.publicKey, ecParameterSpec.toString(), this.kid, this.keyType);
        }
        return Objects.hash(this.publicKey, this.algorithmParameterSpec, this.kid, this.keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject toJson() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("JsonObject", (Object)this, "toJson()");
        try {
            PublicKey publicKey;
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder((JsonObject)super.toJson());
            AlgorithmParameterSpec algorithmParameterSpec = this.algorithmParameterSpec;
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                String curve;
                ECParameterSpec ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
                if (ecParameterSpec.toString().startsWith("secp256r1")) {
                    curve = "P-256";
                } else if (ecParameterSpec.toString().startsWith("secp521r1")) {
                    curve = "P-521";
                } else if (ecParameterSpec.toString().startsWith("secp384r1")) {
                    curve = "P-384";
                } else {
                    throw new UnsupportedOperationException("Unknown curve specification: %s".formatted(ecParameterSpec.toString()));
                }
                jsonObjectBuilder.add("crv", curve);
            }
            if ((publicKey = this.publicKey) instanceof ECPublicKey) {
                ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
                if (ecPublicKey.getW().getAffineX().signum() == -1 || ecPublicKey.getW().getAffineY().signum() == -1) {
                    throw new ArithmeticException();
                }
                int fieldSize = (int)Math.ceil((double)ecPublicKey.getParams().getCurve().getField().getFieldSize() / 8.0);
                tracer.out().printfIndentln("fieldSize(Bytes) = %d", new Object[]{fieldSize});
                byte[] xBytes = JsonWebKeyUtils.alignBytes(ecPublicKey.getW().getAffineX().toByteArray(), fieldSize);
                byte[] yBytes = JsonWebKeyUtils.alignBytes(ecPublicKey.getW().getAffineY().toByteArray(), fieldSize);
                jsonObjectBuilder.add("x", BASE64_URL_ENCODER.encodeToString(xBytes)).add("y", BASE64_URL_ENCODER.encodeToString(yBytes));
            } else {
                PublicKey fieldSize = this.publicKey;
                if (fieldSize instanceof RSAPublicKey) {
                    RSAPublicKey rsaPublicKey = (RSAPublicKey)fieldSize;
                    int keySize = rsaPublicKey.getModulus().bitLength();
                    tracer.out().printfIndentln("keySize = %d", new Object[]{keySize});
                    byte[] modulusBytes = JsonWebKeyUtils.skipSurplusZeroes(rsaPublicKey.getModulus().toByteArray(), keySize / 8);
                    tracer.out().printfIndentln("octets(rsaPublicKey) = %s", new Object[]{JsonWebKeyUtils.formatBytes(modulusBytes)});
                    byte[] publicExponentBytes = JsonWebKeyUtils.skipLeadingZeroes(rsaPublicKey.getPublicExponent().toByteArray());
                    tracer.out().printfIndentln("octets(publicExponentBytes) = %s", new Object[]{JsonWebKeyUtils.formatBytes(publicExponentBytes)});
                    jsonObjectBuilder.add("n", BASE64_URL_ENCODER.encodeToString(modulusBytes)).add("e", BASE64_URL_ENCODER.encodeToString(publicExponentBytes));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            algorithmParameterSpec = jsonObjectBuilder.build();
            return algorithmParameterSpec;
        }
        finally {
            tracer.wayout();
        }
    }

    public static JsonWebPublicKey fromJson(JsonObject jwkView) throws GeneralSecurityException {
        String keyType;
        return switch (keyType = JsonUtils.orElseThrow(jwkView, "kty", JsonString.class).getString()) {
            case "EC" -> {
                String curve = JsonUtils.orElseThrow(jwkView, "crv", JsonString.class).getString();
                if (curve.startsWith("secp256r1") || Objects.equals("P-256", curve)) {
                    curve = "secp256r1";
                } else if (curve.startsWith("secp521r1") || Objects.equals("P-521", curve)) {
                    curve = "secp521r1";
                } else {
                    throw new UnsupportedOperationException();
                }
                ECParameterSpec ecParameterSpec = (ECParameterSpec)EC_PARAMETER_SPEC_MAP.get(curve);
                BigInteger x = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "x", JsonString.class).getString()));
                BigInteger y = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "y", JsonString.class).getString()));
                ECPoint w = new ECPoint(x, y);
                ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(w, ecParameterSpec);
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                PublicKey publicKey = keyFactory.generatePublic(ecPublicKeySpec);
                String kid = jwkView.getString("kid", null);
                yield ((Builder)JsonWebPublicKey.of(publicKey).withKid(kid)).build();
            }
            case "RSA" -> {
                BigInteger n = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "n", JsonString.class).getString()));
                BigInteger e = new BigInteger(1, BASE64_URL_DECODER.decode(JsonUtils.orElseThrow(jwkView, "e", JsonString.class).getString()));
                RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(n, e);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
                String kid = jwkView.getString("kid", null);
                yield ((Builder)JsonWebPublicKey.of(publicKey).withKid(kid)).build();
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    public static class Builder
    extends JsonWebKey.Builder<Builder> {
        final PublicKey publicKey;

        public Builder(PublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public JsonWebPublicKey build() {
            return new JsonWebPublicKey(this);
        }
    }
}

