/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.JsonUtils;
import de.christofreichardt.json.webkey.JsonWebKey;
import de.christofreichardt.json.webkey.JsonWebPublicKey;
import de.christofreichardt.json.websignature.JWSBase;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Map;
import java.util.Objects;

public class JOSEHeader
implements Traceable {
    final String alg;
    final String typ;
    final String kid;
    final JsonWebPublicKey jsonWebPublicKey;

    public String getAlg() {
        return this.alg;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getKid() {
        return this.kid;
    }

    public JsonWebPublicKey getJsonWebPublicKey() {
        return this.jsonWebPublicKey;
    }

    JOSEHeader(AlgorithmBuilder algorithmBuilder) {
        if (!JWSBase.ALGO_MAP.containsKey(algorithmBuilder.alg)) {
            throw new IllegalArgumentException(String.format("Unsupported algorithm '%s'.", algorithmBuilder.alg));
        }
        this.alg = algorithmBuilder.alg;
        this.typ = algorithmBuilder.typ;
        this.kid = algorithmBuilder.kid;
        this.jsonWebPublicKey = null;
    }

    JOSEHeader(PublicKeyBuilder publicKeyBuilder) {
        this.alg = publicKeyBuilder.alg;
        this.kid = publicKeyBuilder.kid;
        this.typ = publicKeyBuilder.typ;
        this.jsonWebPublicKey = publicKeyBuilder.jsonWebPublicKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JOSEHeader that = (JOSEHeader)object;
        return this.alg.equals(that.alg) && Objects.equals(this.typ, that.typ) && Objects.equals(this.kid, that.kid) && Objects.equals(this.jsonWebPublicKey, that.jsonWebPublicKey);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.typ, this.kid, this.jsonWebPublicKey);
    }

    public static AlgorithmBuilder of(String alg) {
        return new AlgorithmBuilder(alg);
    }

    public static PublicKeyBuilder of(JsonWebPublicKey jsonWebPublicKey) {
        return new PublicKeyBuilder(jsonWebPublicKey);
    }

    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("alg", this.alg);
        if (this.typ != null) {
            jsonObjectBuilder.add("typ", this.typ);
        }
        if (this.kid != null) {
            jsonObjectBuilder.add("kid", this.kid);
        }
        if (this.jsonWebPublicKey != null) {
            jsonObjectBuilder.add("jwk", (JsonValue)this.jsonWebPublicKey.toJson());
        }
        return jsonObjectBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JOSEHeader fromJson(JsonObject joseHeaderView) throws GeneralSecurityException {
        AbstractTracer tracer = TracerFactory.getInstance().getCurrentPoolTracer();
        tracer.entry("void", JOSEHeader.class, "fromJson(JsonObject joseHeaderView)");
        try {
            Object object;
            String alg = JsonUtils.orElseThrow(joseHeaderView, "alg", JsonString.class).getString();
            String typ = joseHeaderView.getString("typ", null);
            String kid = joseHeaderView.getString("kid", null);
            JsonWebKey jsonWebPublicKey = null;
            if (joseHeaderView.containsKey((Object)"jwk")) {
                if (((JsonValue)joseHeaderView.get((Object)"jwk")).getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IllegalArgumentException("'jwk' should be an object.");
                }
                jsonWebPublicKey = JsonWebPublicKey.fromJson(joseHeaderView.getJsonObject("jwk"));
            }
            if (Objects.nonNull(jsonWebPublicKey)) {
                if (!Objects.equals(kid, jsonWebPublicKey.getKid())) {
                    throw new IllegalArgumentException("Ambigous kids.");
                }
                if (Objects.equals("ES256", alg)) {
                    if (!Objects.equals("EC", jsonWebPublicKey.getKeyType())) {
                        throw new IllegalArgumentException(String.format("Inappropriate key type '%s' for algorithm '%s'.", jsonWebPublicKey.getKeyType(), alg));
                    }
                    object = ((JsonWebPublicKey)jsonWebPublicKey).getAlgorithmParameterSpec();
                    if (!(object instanceof ECParameterSpec)) throw new IllegalArgumentException("Inappropriate algorithm parameters.");
                    ECParameterSpec ecParameterSpec = (ECParameterSpec)object;
                    if (!ecParameterSpec.toString().startsWith("secp256r1")) {
                        throw new IllegalArgumentException(String.format("Inappropriate curve '%s' for algorithm '%s'.", ecParameterSpec, alg));
                    }
                } else if (Objects.equals("RS256", alg)) {
                    if (!Objects.equals("RSA", jsonWebPublicKey.getKeyType())) {
                        throw new IllegalArgumentException(String.format("Inappropriate key type '%s' for algorithm '%s'.", jsonWebPublicKey.getKeyType(), alg));
                    }
                } else if (Objects.equals("HS256", alg)) {
                    throw new IllegalArgumentException("Symmetric algorithms don't use public keys.");
                }
            }
            JOSEHeader joseHeader = jsonWebPublicKey != null ? JOSEHeader.of((JsonWebPublicKey)jsonWebPublicKey).withTyp(typ).build() : JOSEHeader.of(alg).withKid(kid).withTyp(typ).build();
            object = joseHeader;
            return object;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    public static class AlgorithmBuilder {
        final String alg;
        String typ = null;
        String kid = null;

        public AlgorithmBuilder(String alg) {
            this.alg = alg;
        }

        public AlgorithmBuilder withTyp(String typ) {
            this.typ = typ;
            return this;
        }

        public AlgorithmBuilder withKid(String kid) {
            this.kid = kid;
            return this;
        }

        public JOSEHeader build() {
            return new JOSEHeader(this);
        }
    }

    public static final class PublicKeyBuilder
    implements Traceable {
        static Map<String, String> ecAlgoMap = Map.of("secp256r1 [NIST P-256,X9.62 prime256v1] (1.2.840.10045.3.1.7)", "ES256", "secp521r1 [NIST P-521] (1.3.132.0.35)", "ES512");
        final String alg;
        final JsonWebPublicKey jsonWebPublicKey;
        String kid;
        String typ = null;

        public PublicKeyBuilder(JsonWebPublicKey jsonWebPublicKey) {
            this.jsonWebPublicKey = jsonWebPublicKey;
            this.alg = this.algorithm();
            this.kid = this.jsonWebPublicKey.getKid();
        }

        String algorithm() {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.entry("String", (Object)this, "algorithm()");
            try {
                tracer.out().printfIndentln("this.jsonWebPublicKey = %s", new Object[]{this.jsonWebPublicKey});
                String keyType = this.jsonWebPublicKey.getKeyType();
                if (Objects.equals("EC", keyType)) {
                    Object object = this.jsonWebPublicKey.getAlgorithmParameterSpec();
                    if (!(object instanceof ECParameterSpec)) {
                        throw new IllegalArgumentException("No ECParameterSpec found.");
                    }
                    ECParameterSpec ecParameterSpec = (ECParameterSpec)object;
                    if (!ecAlgoMap.containsKey(ecParameterSpec.toString())) {
                        throw new IllegalArgumentException(String.format("Unsupported curve '%s' found.", ecParameterSpec));
                    }
                    object = ecAlgoMap.get(ecParameterSpec.toString());
                    return object;
                }
                if (Objects.equals("RSA", keyType)) {
                    PublicKey publicKey = this.jsonWebPublicKey.getPublicKey();
                    if (!(publicKey instanceof RSAPublicKey)) {
                        throw new IllegalArgumentException("Inappropriate key.");
                    }
                    RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                    int keysize = rsaPublicKey.getModulus().bitLength() / 8;
                    tracer.out().printfIndentln("keysize = %d bytes", new Object[]{keysize});
                    String string = "RS256";
                    return string;
                }
                throw new IllegalArgumentException(String.format("Unsupported key type '%s'.", keyType));
            }
            finally {
                tracer.wayout();
            }
        }

        public PublicKeyBuilder withKid(String kid) {
            if (Objects.nonNull(this.kid) && !Objects.equals(this.kid, kid)) {
                throw new IllegalArgumentException("Ambigous kids.");
            }
            this.kid = kid;
            return this;
        }

        public PublicKeyBuilder withTyp(String typ) {
            this.typ = typ;
            return this;
        }

        public JOSEHeader build() {
            return new JOSEHeader(this);
        }

        public AbstractTracer getCurrentTracer() {
            return TracerFactory.getInstance().getDefaultTracer();
        }
    }
}

