/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.webkey.JsonWebKey;
import de.christofreichardt.json.webkey.JsonWebKeyPair;
import de.christofreichardt.json.webkey.JsonWebPublicKey;
import de.christofreichardt.json.webkey.JsonWebSecretKey;
import de.christofreichardt.json.websignature.JOSEHeader;
import de.christofreichardt.json.websignature.JWSCompactSerialization;
import de.christofreichardt.json.websignature.JWSSigner;
import de.christofreichardt.json.websignature.JWSValidator;
import de.christofreichardt.json.websignature.Json2StringConverter;
import de.christofreichardt.json.websignature.interfaces.BeforeHeader;
import de.christofreichardt.json.websignature.interfaces.BeforeKey;
import de.christofreichardt.json.websignature.interfaces.BeforeKid;
import de.christofreichardt.json.websignature.interfaces.BeforePayload;
import de.christofreichardt.json.websignature.interfaces.SignatureBegin;
import de.christofreichardt.json.websignature.interfaces.SignatureEnd;
import de.christofreichardt.json.websignature.interfaces.ValidationBegin;
import de.christofreichardt.json.websignature.interfaces.ValidationEnd;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;

public class JWS {
    private JWS() {
    }

    public static SignatureBegin createSignature() {
        return new Signature();
    }

    public static ValidationBegin createValidator() {
        return new Validator();
    }

    protected static class Signature
    implements SignatureBegin,
    BeforePayload,
    BeforeHeader,
    BeforeKid,
    SignatureEnd,
    Traceable {
        JsonWebKey jsonWebKey;
        JsonStructure payload;
        String kid;
        String typ;
        String strPayload;
        String strHeader;

        protected Signature() {
        }

        @Override
        public SignatureEnd payload(JsonStructure payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public SignatureEnd payload(String strPayload) {
            this.strPayload = strPayload;
            return this;
        }

        @Override
        public BeforeHeader webkey(JsonWebKeyPair jsonWebKeyPair) {
            this.jsonWebKey = jsonWebKeyPair;
            return this;
        }

        @Override
        public BeforeHeader webkey(JsonWebSecretKey jsonWebSecretKey) {
            this.jsonWebKey = jsonWebSecretKey;
            return this;
        }

        @Override
        public BeforeHeader key(KeyPair keyPair) {
            this.jsonWebKey = JsonWebKeyPair.of(keyPair).build();
            return this;
        }

        @Override
        public BeforeHeader key(SecretKey secretKey) {
            this.jsonWebKey = JsonWebSecretKey.of(secretKey).build();
            return this;
        }

        @Override
        public JWSCompactSerialization sign() throws GeneralSecurityException {
            return this.sign(JsonValue::toString);
        }

        @Override
        public JWSCompactSerialization sign(Json2StringConverter converter) throws GeneralSecurityException {
            JWSSigner jwsSigner;
            assert (Objects.nonNull(this.payload) || Objects.nonNull(this.strPayload)) : "No payload is given.";
            Key key = this.signingKey();
            Optional<JOSEHeader> optionalJOSEHeader = this.buildJoseHeader();
            if (Objects.nonNull(this.payload)) {
                jwsSigner = optionalJOSEHeader.map(joseHeader -> new JWSSigner(joseHeader.toJson(), this.payload, converter)).orElseGet(() -> new JWSSigner(this.strHeader, converter.convert(this.payload)));
            } else if (Objects.nonNull(this.strPayload)) {
                jwsSigner = optionalJOSEHeader.map(joseHeader -> new JWSSigner(converter.convert((JsonStructure)joseHeader.toJson()), this.strPayload)).orElseGet(() -> new JWSSigner(this.strHeader, this.strPayload));
            } else {
                throw new IllegalStateException();
            }
            return jwsSigner.sign(key);
        }

        @Override
        public BeforePayload kid(String kid) {
            if (Objects.nonNull(this.jsonWebKey.getKid()) && !Objects.equals(this.jsonWebKey.getKid(), kid)) {
                throw new IllegalArgumentException("Ambigous kids.");
            }
            this.kid = kid;
            return this;
        }

        @Override
        public BeforeKid typ(String typ) {
            this.typ = typ;
            return this;
        }

        @Override
        public BeforePayload header(String strHeader) {
            this.strHeader = strHeader;
            return this;
        }

        private Optional<JOSEHeader> buildJoseHeader() throws GeneralSecurityException {
            JOSEHeader joseHeader = null;
            if (Objects.isNull(this.strHeader)) {
                JsonWebKey jsonWebKey = this.jsonWebKey;
                if (jsonWebKey instanceof JsonWebSecretKey) {
                    JsonWebSecretKey jsonWebSecretKey = (JsonWebSecretKey)jsonWebKey;
                    algorithmBuilder = JOSEHeader.of(jsonWebSecretKey.getAlgorithm()).withTyp(this.typ);
                    if (Objects.nonNull(this.kid)) {
                        ((JOSEHeader.AlgorithmBuilder)algorithmBuilder).withKid(this.kid);
                    }
                    joseHeader = ((JOSEHeader.AlgorithmBuilder)algorithmBuilder).build();
                } else {
                    algorithmBuilder = this.jsonWebKey;
                    if (algorithmBuilder instanceof JsonWebKeyPair) {
                        JsonWebKeyPair jsonWebKeyPair = (JsonWebKeyPair)algorithmBuilder;
                        JOSEHeader.PublicKeyBuilder publicKeyBuilder = JOSEHeader.of(jsonWebKeyPair.jsonWebPublicKey()).withTyp(this.typ);
                        if (Objects.nonNull(this.kid)) {
                            publicKeyBuilder.withKid(this.kid);
                        }
                        joseHeader = publicKeyBuilder.build();
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            return Optional.ofNullable(joseHeader);
        }

        private Key signingKey() {
            Key key;
            JsonWebKey jsonWebKey = this.jsonWebKey;
            if (jsonWebKey instanceof JsonWebSecretKey) {
                JsonWebSecretKey jsonWebSecretKey = (JsonWebSecretKey)jsonWebKey;
                key = jsonWebSecretKey.getSecretKey();
            } else {
                jsonWebKey = this.jsonWebKey;
                if (jsonWebKey instanceof JsonWebKeyPair) {
                    JsonWebKeyPair jsonWebKeyPair = (JsonWebKeyPair)jsonWebKey;
                    key = jsonWebKeyPair.getKeyPair().getPrivate();
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            return key;
        }

        public AbstractTracer getCurrentTracer() {
            return TracerFactory.getInstance().getDefaultTracer();
        }
    }

    protected static class Validator
    implements ValidationBegin,
    BeforeKey,
    ValidationEnd {
        JWSCompactSerialization compactSerialization;
        Key key;

        protected Validator() {
        }

        @Override
        public ValidationEnd key(PublicKey publicKey) {
            this.key = publicKey;
            return this;
        }

        @Override
        public ValidationEnd key(SecretKey secretKey) {
            this.key = secretKey;
            return this;
        }

        @Override
        public ValidationEnd webkey(JsonWebPublicKey jsonWebPublicKey) {
            this.key = jsonWebPublicKey.getPublicKey();
            return this;
        }

        @Override
        public ValidationEnd webkey(JsonWebSecretKey jsonWebSecretKey) {
            this.key = jsonWebSecretKey.getSecretKey();
            return this;
        }

        @Override
        public BeforeKey compactSerialization(JWSCompactSerialization compactSerialization) {
            this.compactSerialization = compactSerialization;
            return this;
        }

        @Override
        public boolean validate() throws GeneralSecurityException {
            JWSValidator jwsValidator = new JWSValidator(this.compactSerialization);
            return jwsValidator.validate(this.key);
        }
    }
}

