/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.junit5;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class MyTestExecutionListener
implements TestExecutionListener,
Traceable {
    int succeeded;
    int failed;
    int aborted;
    int containerFailed;
    int containerSucceeded;
    int containerAborted;
    final Map<String, Summary> summaries = new LinkedHashMap<String, Summary>();
    final Map<String, String> id2DisplayName = new HashMap<String, String>();
    public static final String TRACE_CONFIG_PROPERTY = "de.christofreichardt.junit5.traceConfig";
    final String traceConfig = System.getProperty("de.christofreichardt.junit5.traceConfig");
    public static final String SUMMARY_PROPERTY = "de.christofreichardt.junit5.summary";
    final String summary = System.getProperty("de.christofreichardt.junit5.summary");

    public void testPlanExecutionStarted(TestPlan testPlan) {
        block11: {
            System.out.printf("%s: Testplan execution has been started ...\n", Thread.currentThread().getName());
            System.out.printf("Using %s = %s...\n", TRACE_CONFIG_PROPERTY, this.traceConfig);
            System.out.printf("Using %s = %s...\n", SUMMARY_PROPERTY, this.summary);
            try {
                if (this.traceConfig == null) break block11;
                TracerFactory.getInstance().reset();
                try (InputStream resourceAsStream = MyTestExecutionListener.class.getClassLoader().getResourceAsStream(this.traceConfig);){
                    if (resourceAsStream != null) {
                        TracerFactory.getInstance().readConfiguration(resourceAsStream);
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                TracerFactory.getInstance().openPoolTracer();
                AbstractTracer tracer = this.getCurrentTracer();
                tracer.initCurrentTracingContext();
            }
            catch (TracerFactory.Exception ex) {
                throw new RuntimeException("Tracer configuration failed,", ex);
            }
        }
        this.traceTestPlan(testPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceTestPlan(final TestPlan testPlan) {
        final AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "traceTestPlan(TestPlan testPlan)");
        try {
            class TestPlanWalker {
                TestPlanWalker() {
                }

                void walk(TestIdentifier parent) {
                    tracer.out().printfIndentln("uniqueId = %s, displayName = %s", new Object[]{parent.getUniqueId(), parent.getDisplayName()});
                    MyTestExecutionListener.this.id2DisplayName.put(parent.getUniqueId(), parent.getDisplayName());
                    testPlan.getChildren(parent).forEach(testIdentifier -> this.walk((TestIdentifier)testIdentifier));
                }
            }
            TestPlanWalker testPlanWalker = new TestPlanWalker();
            testPlan.getRoots().forEach(testIdentifier -> testPlanWalker.walk((TestIdentifier)testIdentifier));
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPlanExecutionFinished(TestPlan testPlan) {
        System.out.printf("Testplan execution has been finished ...\n", new Object[0]);
        boolean shouldClose = false;
        AbstractTracer tracer = this.getCurrentTracer();
        Object out = tracer.out();
        try {
            if (this.summary != null) {
                try {
                    out = new PrintStream(Files.newOutputStream(Paths.get(this.summary, new String[0]), new OpenOption[0]));
                    shouldClose = true;
                }
                catch (IOException ex) {
                    out = tracer.out();
                }
            }
            ((PrintStream)out).println();
            ((PrintStream)out).printf("-> Summary\n", new Object[0]);
            ((PrintStream)out).printf("=====================================\n", new Object[0]);
            ((PrintStream)out).println();
            for (Map.Entry<String, Summary> entry : this.summaries.entrySet()) {
                entry.getValue().printSummary((PrintStream)out);
            }
            ((PrintStream)out).println();
            ((PrintStream)out).printf("Tests--------------------------------\n", new Object[0]);
            ((PrintStream)out).printf("succeeded: %d\n", this.succeeded);
            ((PrintStream)out).printf("   failed: %d\n", this.failed);
            ((PrintStream)out).printf("  aborted: %d\n", this.aborted);
            ((PrintStream)out).printf("-------------------------------------\n", new Object[0]);
            ((PrintStream)out).println();
            ((PrintStream)out).printf("Container----------------------------\n", new Object[0]);
            ((PrintStream)out).printf("succeeded: %d\n", this.containerSucceeded);
            ((PrintStream)out).printf("   failed: %d\n", this.containerFailed);
            ((PrintStream)out).printf("  aborted: %d\n", this.containerAborted);
            ((PrintStream)out).printf("-------------------------------------\n", new Object[0]);
            ((PrintStream)out).println();
        }
        finally {
            if (shouldClose) {
                ((PrintStream)out).close();
            }
        }
        if (this.traceConfig != null) {
            TracerFactory.getInstance().closePoolTracer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionStarted(TestIdentifier testIdentifier) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "executionStarted(TestIdentifier testIdentifier)");
        try {
            tracer.logMessage(LogLevel.INFO, String.format("%s started ...", testIdentifier.getDisplayName()), this.getClass(), "executionStarted(TestIdentifier testIdentifier)");
            tracer.out().printfIndentln("testIdentifier.getUniqueId() = %s, testIdentifier.getParentId() = %s", new Object[]{testIdentifier.getUniqueId(), testIdentifier.getParentId().orElse("[]")});
            tracer.out().printfIndentln("testIdentifier.isContainer() = %b, testIdentifier.isTest() = %b", new Object[]{testIdentifier.isContainer(), testIdentifier.isTest()});
            if (testIdentifier.getParentId().isPresent()) {
                String parentId = (String)testIdentifier.getParentId().get();
                Summary summary = this.summaries.getOrDefault(parentId, new Summary(parentId));
                summary.addTest(new Test(testIdentifier, LocalDateTime.now()));
                this.summaries.putIfAbsent(parentId, summary);
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult)");
        try {
            tracer.out().printfIndentln("%s[%s] finished with status %s.", new Object[]{testIdentifier.getDisplayName(), testIdentifier.getUniqueId(), testExecutionResult.getStatus()});
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                testExecutionResult.getThrowable().ifPresent(throwable -> {
                    tracer.out().printfIndentln("%s: %s", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
                    do {
                        StackTraceElement[] stackTraceElements;
                        for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                            tracer.out().printfIndentln("  at %s.%s(%s:%d)", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
                        }
                        if ((throwable = throwable.getCause()) == null) continue;
                        tracer.out().printfIndentln("caused by = %s: %s", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
                    } while (throwable != null);
                });
            }
            if (testIdentifier.getParentId().isPresent()) {
                Summary summary = this.summaries.get(testIdentifier.getParentId().get());
                summary.setStatus(testIdentifier.getUniqueId(), testExecutionResult.getStatus());
            }
            if (testIdentifier.isTest()) {
                switch (testExecutionResult.getStatus()) {
                    case SUCCESSFUL: {
                        ++this.succeeded;
                        return;
                    }
                    case FAILED: {
                        ++this.failed;
                        return;
                    }
                    case ABORTED: {
                        ++this.aborted;
                        return;
                    }
                }
                return;
            }
            if (!testIdentifier.isContainer()) return;
            switch (testExecutionResult.getStatus()) {
                case SUCCESSFUL: {
                    ++this.containerSucceeded;
                    return;
                }
                case FAILED: {
                    ++this.containerFailed;
                    return;
                }
                case ABORTED: {
                    ++this.containerAborted;
                    return;
                }
            }
            return;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    class Summary {
        final String id;
        final Map<String, Test> tests = new HashMap<String, Test>();

        public Summary(String id) {
            this.id = id;
        }

        void addTest(Test test) {
            this.tests.put(test.getTestIdentifier().getUniqueId(), test);
        }

        void setStatus(String id, TestExecutionResult.Status status) {
            Test test = this.tests.get(id);
            test.setStatus(status);
            test.setEndTime(LocalDateTime.now());
        }

        long getContainerCount() {
            return this.tests.values().stream().filter(test -> test.getTestIdentifier().isContainer()).count();
        }

        long getTestCount() {
            return this.tests.values().stream().filter(test -> test.getTestIdentifier().isTest()).count();
        }

        long getSuccessful() {
            return this.tests.values().stream().filter(test -> test.getStatus().isPresent() && test.getStatus().get() == TestExecutionResult.Status.SUCCESSFUL).count();
        }

        long getFailed() {
            return this.tests.values().stream().filter(test -> test.getStatus().isPresent() && test.getStatus().get() == TestExecutionResult.Status.FAILED).count();
        }

        long getAborted() {
            return this.tests.values().stream().filter(test -> test.getStatus().isPresent() && test.getStatus().get() == TestExecutionResult.Status.ABORTED).count();
        }

        public String toString() {
            return String.format("id = %s, containers = %d, tests = %d, successful = %d, failed = %d, aborted = %d", this.id, this.getContainerCount(), this.getTestCount(), this.getSuccessful(), this.getFailed(), this.getAborted());
        }

        void printSummary(PrintStream out) {
            out.println("-------------------------------------");
            out.printf("%s, (uniqueId = %s)\n", MyTestExecutionListener.this.id2DisplayName.get(this.id), this.id);
            out.printf("containers = %d, tests = %d, successful = %d, failed = %d, aborted = %d\n", this.getContainerCount(), this.getTestCount(), this.getSuccessful(), this.getFailed(), this.getAborted());
            out.println("-------------------------------------");
            this.tests.values().forEach(test -> out.printf("%s\n", test));
            out.println();
        }
    }

    class Test {
        final TestIdentifier testIdentifier;
        final LocalDateTime startTime;
        LocalDateTime endTime;
        TestExecutionResult.Status status;

        public Test(TestIdentifier testIdentifier, LocalDateTime startTime) {
            this.testIdentifier = testIdentifier;
            this.startTime = startTime;
        }

        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        public void setEndTime(LocalDateTime endTime) {
            this.endTime = endTime;
        }

        public Optional<Duration> getDuration() {
            return this.endTime != null ? Optional.of(Duration.between(this.startTime, this.endTime)) : Optional.empty();
        }

        public TestIdentifier getTestIdentifier() {
            return this.testIdentifier;
        }

        public Optional<TestExecutionResult.Status> getStatus() {
            return this.status != null ? Optional.of(this.status) : Optional.empty();
        }

        public void setStatus(TestExecutionResult.Status status) {
            this.status = status;
        }

        public String toString() {
            return String.format("%s[container=%b, test=%b, start=%s, end=%s, duration=%s, status=%s]", this.testIdentifier.getDisplayName(), this.testIdentifier.isContainer(), this.testIdentifier.isTest(), DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.startTime), this.endTime != null ? DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.endTime) : "-", this.getDuration().isPresent() ? this.getDuration().get() : "-", this.getStatus().isPresent() ? this.getStatus().get() : "-");
        }
    }
}

