/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamirsdemo;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jca.shamirsdemo.App;
import de.christofreichardt.jca.shamirsdemo.Menu;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractMenu
implements Menu,
Traceable {
    final App app;
    final Map<String, Menu.Command> shortCuts;
    final Console console = new Console();

    public AbstractMenu(App app) {
        this.app = app;
        this.shortCuts = this.computeShortCutMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Menu.Command readCommand() throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Command", (Object)this, "readCommand()");
        try {
            Menu.Command command = null;
            System.console().printf("\n", new Object[0]);
            do {
                String line = System.console().readLine("%s-> ", this.app.getCurrentWorkspace().getFileName());
                tracer.out().printfIndentln("line = %s, %d", new Object[]{line, line != null ? line.length() : -1});
                tracer.out().flush();
                if (line == null) continue;
                String found = this.shortCuts.keySet().stream().filter(shortCut -> line.startsWith((String)shortCut)).findFirst().orElseThrow();
                tracer.out().printfIndentln("found = %s, %b, %s", new Object[]{found, this.shortCuts.containsKey(found), this.shortCuts.get(found)});
                tracer.out().flush();
                command = this.shortCuts.get(found);
            } while (command == null);
            Menu.Command command2 = command;
            return command2;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    class Console {
        Console() {
        }

        String readString(String regex, String label) {
            String input;
            while (!Pattern.matches(regex, input = System.console().readLine("%s-> %s (%s): ", AbstractMenu.this.app.getCurrentWorkspace().getFileName(), label, regex))) {
            }
            return input;
        }

        String readString(String regex, String label, String proposal) {
            String input;
            while (!Pattern.matches(regex, input = (input = System.console().readLine("%s-> %s (%s): %s ", AbstractMenu.this.app.getCurrentWorkspace().getFileName(), label, regex, proposal)).length() == 0 ? proposal : input)) {
            }
            return input;
        }

        String readString(Pattern pattern, String label) {
            String input;
            while (!pattern.matcher(input = System.console().readLine("%s-> %s (%s): ", AbstractMenu.this.app.getCurrentWorkspace().getFileName(), label, pattern.pattern())).matches()) {
            }
            return input;
        }

        int readInt(String regex, String label) {
            Integer input = null;
            do {
                String line;
                if (!Pattern.matches(regex, line = System.console().readLine("%s-> %s (%s): ", AbstractMenu.this.app.getCurrentWorkspace().getFileName(), label, regex))) continue;
                input = Integer.parseInt(line);
            } while (input == null);
            return input;
        }
    }
}

