/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamirsdemo;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jca.shamir.ShamirsProvider;
import de.christofreichardt.jca.shamirsdemo.MainMenu;
import de.christofreichardt.jca.shamirsdemo.Menu;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public class App
implements Traceable {
    final String currentDate = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
    private Path currentWorkspace;
    private Menu menu;

    public App() throws IOException {
        this.setCurrentWorkspace(this.initWorkspace());
        this.menu = new MainMenu(this);
    }

    public Path getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentWorkspace(Path currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path initWorkspace() throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "initWorkspace()");
        try {
            int RECENT_WORKSPACE_DIRS = 5;
            Path workspaceDir = Paths.get(".", "workspace");
            Stream.of(workspaceDir.toFile().listFiles(file -> file.isDirectory())).sorted((file1, file2) -> file1.getName().compareTo(file2.getName())).forEachOrdered(file -> tracer.out().printfIndentln("workspace = %s", new Object[]{file}));
            Path workspace = workspaceDir.resolve(this.currentDate);
            if (Files.exists(workspace, new LinkOption[0])) {
                if (!Files.isDirectory(workspace, new LinkOption[0])) {
                    throw new IOException(String.format("%s isn't a directory.", new Object[0]));
                }
            } else {
                Files.createDirectory(workspace, new FileAttribute[0]);
            }
            Path path = workspace;
            return path;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "mainLoop()");
        try {
            do {
                try {
                    System.console().printf("\n", new Object[0]);
                    System.console().printf("+---------------+\n", new Object[0]);
                    System.console().printf("| Shamir's Demo |\n", new Object[0]);
                    System.console().printf("+---------------+\n", new Object[0]);
                    this.menu.print();
                    Menu.Command command = this.menu.readCommand();
                    if (command == null) continue;
                    System.console().printf("%s-> %s\n", this.currentWorkspace.getFileName(), command.getFullName());
                    this.menu.execute(command);
                }
                catch (IOException | IllegalArgumentException | GeneralSecurityException | NoSuchElementException ex) {
                    ex.printStackTrace();
                    Throwable throwable = ex;
                    do {
                        StackTraceElement[] stackTraceElements;
                        for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                            tracer.out().printfIndentln("  at %s.%s(%s:%d)", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
                        }
                        if ((throwable = throwable.getCause()) == null) continue;
                        tracer.out().printfIndentln("caused by = %s: %s", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
                    } while (throwable != null);
                }
            } while (!this.menu.isExit());
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws TracerFactory.Exception, IOException {
        TracerFactory.getInstance().reset();
        InputStream resourceAsStream = App.class.getClassLoader().getResourceAsStream("de/christofreichardt/jca/trace-config.xml");
        if (resourceAsStream != null) {
            TracerFactory.getInstance().readConfiguration(resourceAsStream);
        }
        TracerFactory.getInstance().openPoolTracer();
        try {
            AbstractTracer tracer = TracerFactory.getInstance().getCurrentPoolTracer();
            tracer.initCurrentTracingContext();
            tracer.entry("void", App.class, "main(String[] args)");
            ArrayList<String> propertyNames = new ArrayList<String>(System.getProperties().stringPropertyNames());
            propertyNames.stream().sorted().forEach(propertyName -> tracer.out().printfIndentln("%s = %s", new Object[]{propertyName, System.getProperties().getProperty((String)propertyName)}));
            try {
                Security.addProvider((Provider)new ShamirsProvider());
                App app = new App();
                app.mainLoop();
                System.console().printf("\n", new Object[0]);
            }
            finally {
                tracer.wayout();
            }
        }
        finally {
            TracerFactory.getInstance().closePoolTracer();
        }
    }
}

