/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamirsdemo;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.jca.shamir.ShamirsLoadParameter;
import de.christofreichardt.jca.shamirsdemo.AbstractMenu;
import de.christofreichardt.jca.shamirsdemo.App;
import de.christofreichardt.jca.shamirsdemo.MainMenu;
import de.christofreichardt.jca.shamirsdemo.Menu;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreMenu
extends AbstractMenu {
    private final KeyStore keyStore;
    private final ShamirsLoadParameter shamirsLoadParameter;

    public KeyStoreMenu(App app, KeyStore keyStore, ShamirsLoadParameter shamirsLoadParameter) {
        super(app);
        this.keyStore = keyStore;
        this.shamirsLoadParameter = shamirsLoadParameter;
    }

    @Override
    public void print() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "printMenu()");
        try {
            System.console().printf("\n", new Object[0]);
            System.console().printf("Current time: %s\n", LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            System.console().printf("   Workspace: %s\n", this.app.getCurrentWorkspace().getFileName());
            System.console().printf("\n", new Object[0]);
            String keyStoreFilename = this.shamirsLoadParameter.getFile().getName();
            System.console().printf("%s-> KeyStore menu [%s]\n", this.app.getCurrentWorkspace().getFileName(), keyStoreFilename.substring(0, keyStoreFilename.length() - ".p12".length()));
            System.console().printf("\n", new Object[0]);
            System.console().printf("   %20s", KeystoreCommand.LIST_ENTRIES.getDisplayName());
            System.console().printf("   %20s", KeystoreCommand.PRIVATE_KEY.getDisplayName());
            System.console().printf("   %20s", KeystoreCommand.SECRET_KEY.getDisplayName());
            System.console().printf("\n", new Object[0]);
            System.console().printf("   %20s", KeystoreCommand.CERTIFICATE.getDisplayName());
            System.console().printf("   %20s", KeystoreCommand.MAIN_MENU.getDisplayName());
            System.console().printf("\n", new Object[0]);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Menu.Command> computeShortCutMap() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Map<String, Command>", (Object)this, "computeShortCutMap()");
        try {
            EnumSet<KeystoreCommand> keystoreCommands = EnumSet.allOf(KeystoreCommand.class);
            tracer.out().printfIndentln("keystoreCommands = %s", new Object[]{keystoreCommands});
            Map<String, Menu.Command> shortCuts = keystoreCommands.stream().collect(Collectors.toMap(keystoreCommand -> keystoreCommand.getShortCut(), Function.identity()));
            tracer.out().printfIndentln("shortCuts = %s", new Object[]{shortCuts});
            Map<String, Menu.Command> map = shortCuts;
            return map;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Menu.Command> void execute(T command) throws IOException, GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "execute(Command command)");
        try {
            tracer.out().printfIndentln("command = %s", new Object[]{command});
            KeystoreCommand keystoreCommand = KeystoreCommand.valueOf(command.toString());
            switch (keystoreCommand) {
                case MAIN_MENU: {
                    this.keyStore.store((KeyStore.LoadStoreParameter)this.shamirsLoadParameter);
                    this.app.setMenu(new MainMenu(this.app));
                    return;
                }
                case SECRET_KEY: {
                    this.addSecretKey();
                    return;
                }
                case LIST_ENTRIES: {
                    this.listEntries();
                    return;
                }
                case PRIVATE_KEY: {
                    this.addPrivateKey();
                    return;
                }
                case CERTIFICATE: {
                    this.addCertificate();
                    return;
                }
            }
            return;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSecretKey() throws GeneralSecurityException, IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "addSecretKey()");
        try {
            String algorithm = this.console.readString("AES|ChaCha20|HmacSHA512", "Algorithm");
            int keySize = this.console.readInt("128|256|512", "Keysize");
            String alias = this.console.readString("[A-Za-z0-9-]{5,25}", "Alias");
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            keyGenerator.init(keySize);
            SecretKey secretKey = keyGenerator.generateKey();
            KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(secretKey);
            this.keyStore.setEntry(alias, secretKeyEntry, this.shamirsLoadParameter.getProtectionParameter());
            this.keyStore.store((KeyStore.LoadStoreParameter)this.shamirsLoadParameter);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listEntries() throws GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "listEntries()");
        try {
            Iterator<String> iter = this.keyStore.aliases().asIterator();
            while (iter.hasNext()) {
                String alias = iter.next();
                KeyStore.Entry keyStoreEntry = this.keyStore.getEntry(alias, this.shamirsLoadParameter.getProtectionParameter());
                String algorithm = null;
                String keyEntryType = null;
                if (keyStoreEntry instanceof KeyStore.SecretKeyEntry) {
                    KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)keyStoreEntry;
                    algorithm = secretKeyEntry.getSecretKey().getAlgorithm();
                    keyEntryType = "Secret Key";
                } else if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                    KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStoreEntry;
                    algorithm = privateKeyEntry.getPrivateKey().getAlgorithm();
                    keyEntryType = "Private Key";
                } else if (this.keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                    KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)keyStoreEntry;
                    algorithm = trustedCertificateEntry.getTrustedCertificate().getPublicKey().getAlgorithm();
                    keyEntryType = "Trusted Certificate";
                }
                Set<KeyStore.Entry.Attribute> entryAttributes = keyStoreEntry.getAttributes();
                Map entryAttrMap = entryAttributes.stream().peek(entryAttribut -> tracer.out().printfIndentln("attr: %s = %s", new Object[]{entryAttribut.getName(), entryAttribut.getValue()})).collect(Collectors.toMap(entryAttribut -> entryAttribut.getName(), Function.identity()));
                String FRIENDLY_NAME_OOID = "1.2.840.113549.1.9.20";
                String LOCAL_ID_OOID = "1.2.840.113549.1.9.21";
                String TRUSTED_KEY_USAGE_OID = "2.16.840.1.113894.746875.1.1";
                String friendlyName = entryAttrMap.containsKey("1.2.840.113549.1.9.20") ? ((KeyStore.Entry.Attribute)entryAttrMap.get("1.2.840.113549.1.9.20")).getValue() : "null";
                String localId = entryAttrMap.containsKey("1.2.840.113549.1.9.21") ? ((KeyStore.Entry.Attribute)entryAttrMap.get("1.2.840.113549.1.9.21")).getValue() : "null";
                String trustedKeyUsage = entryAttrMap.containsKey("2.16.840.1.113894.746875.1.1") ? ((KeyStore.Entry.Attribute)entryAttrMap.get("2.16.840.1.113894.746875.1.1")).getValue() : "null";
                tracer.out().printfIndentln("friendlyName(%1$s) = %2$s, localId(%1$s) = %3$s, algorithm(%1$s) = %4$s, trustedKeyUsage(%1$s) = %5$s", new Object[]{alias, friendlyName, localId, algorithm, trustedKeyUsage});
                System.console().printf("%s-> %s: friendlyName=%s, localId=%s, algorithm=%s, keytype=%s\n", this.app.getCurrentWorkspace().getFileName(), alias, friendlyName, localId, algorithm, keyEntryType);
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPrivateKey() throws GeneralSecurityException, IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "addPrivateKey()");
        try {
            String signatureAlgo;
            String algorithm = this.console.readString("DSA|RSA|EC", "Keygenerator algorithm");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            switch (algorithm) {
                case "DSA": {
                    keyPairGenerator.initialize(2048);
                    signatureAlgo = "SHA256withDSA";
                    break;
                }
                case "RSA": {
                    keyPairGenerator.initialize(4096);
                    signatureAlgo = "SHA256withRSA";
                    break;
                }
                case "EC": {
                    ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp521r1");
                    keyPairGenerator.initialize(ecGenParameterSpec);
                    signatureAlgo = "SHA256withECDSA";
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException(String.format("%s is not supported.", algorithm));
                }
            }
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            tracer.out().printfIndentln("keyPair.getPrivate().getAlgorithm() = %s, keyPair.getPrivate().getEncoded().length = %d", new Object[]{keyPair.getPrivate().getAlgorithm(), keyPair.getPrivate().getEncoded().length});
            int validity = this.console.readInt("[0-9]+", "Validity");
            String commonName = this.console.readString("[A-Za-z- ]{5,30}", "Common Name");
            String locality = this.console.readString("[A-Za-z- ]{5,30}", "Locality");
            String state = this.console.readString("[A-Za-z- ]{5,30}", "State");
            String country = this.console.readString("[A-Za-z- ]{5,30}", "Country");
            String distinguishedName = String.format("CN=%s, L=%s, ST=%s, C=%s", commonName, locality, state, country);
            String alias = this.console.readString("[a-z0-9-]{5,25}", "Alias");
            Instant now = Instant.now();
            Date notBefore = Date.from(now);
            Date notAfter = Date.from(now.plus(Duration.ofDays(validity)));
            try {
                ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgo).build(keyPair.getPrivate());
                X500Name x500Name = new X500Name(distinguishedName);
                JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(now.toEpochMilli()), notBefore, notAfter, x500Name, keyPair.getPublic());
                X509CertificateHolder x509CertificateHolder = certificateBuilder.build(contentSigner);
                JcaX509CertificateConverter x509CertificateConverter = new JcaX509CertificateConverter();
                x509CertificateConverter.setProvider((Provider)new BouncyCastleProvider());
                X509Certificate x509Certificate = x509CertificateConverter.getCertificate(x509CertificateHolder);
                this.keyStore.setEntry(alias, new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), new Certificate[]{x509Certificate}), this.shamirsLoadParameter.getProtectionParameter());
            }
            catch (OperatorCreationException ex) {
                throw new GeneralSecurityException(ex);
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCertificate() throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "addCertificate()");
        try {
            String url = this.console.readString("https://[A-Za-z-\\./]{5,30}", "URL");
            String alias = this.console.readString("[A-Za-z0-9-]{5,25}", "Alias");
            int TIME_OUT = 30;
            HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(30L)).build();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            try {
                HttpResponse<Void> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
                Optional<SSLSession> sslSession = httpResponse.sslSession();
                sslSession.ifPresentOrElse(session -> {
                    try {
                        Certificate[] certificates = session.getPeerCertificates();
                        tracer.out().printfIndentln("certificates.length = %d", new Object[]{certificates.length});
                        for (int i = 0; i < certificates.length; ++i) {
                            this.keyStore.setCertificateEntry(alias + i, certificates[i]);
                        }
                    }
                    catch (KeyStoreException | SSLPeerUnverifiedException ex) {
                        tracer.logException(LogLevel.ERROR, (Throwable)ex, this.getClass(), "addCertificate()");
                    }
                }, () -> tracer.logMessage(LogLevel.WARNING, "No ssl session available.", this.getClass(), "addCertificate()"));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            tracer.wayout();
        }
    }

    @Override
    public boolean isExit() {
        return false;
    }

    public static enum KeystoreCommand implements Menu.Command
    {
        LIST_ENTRIES("l", "list entries"),
        SECRET_KEY("s", "secret key"),
        PRIVATE_KEY("p", "private key"),
        CERTIFICATE("c", "certificate"),
        MAIN_MENU("m", "main menu");

        String shortCut;
        String fullName;

        private KeystoreCommand(String shortCut, String fullName) {
            this.shortCut = shortCut;
            this.fullName = fullName;
        }

        @Override
        public String getShortCut() {
            return this.shortCut;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getDisplayName() {
            return this.fullName.replaceFirst(this.shortCut, "(" + this.shortCut + ")");
        }
    }
}

