/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamirsdemo;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.jca.shamir.ShamirsLoadParameter;
import de.christofreichardt.jca.shamir.ShamirsProtection;
import de.christofreichardt.jca.shamirsdemo.AbstractMenu;
import de.christofreichardt.jca.shamirsdemo.App;
import de.christofreichardt.jca.shamirsdemo.KeyStoreMenu;
import de.christofreichardt.jca.shamirsdemo.Menu;
import de.christofreichardt.jca.shamirsdemo.PasswordGenerator;
import de.christofreichardt.scala.shamir.SecretMerging;
import de.christofreichardt.scala.shamir.SecretSharing;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MainMenu
extends AbstractMenu {
    static final Pattern PARTITION_PATTERN = Pattern.compile("[A-Za-z]{1,10}");
    private boolean exit = false;

    public MainMenu(App app) {
        super(app);
    }

    @Override
    public void print() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "printMenu()");
        try {
            System.console().printf("\n", new Object[0]);
            System.console().printf("Current time: %s\n", LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            System.console().printf("   Workspace: %s\n", this.app.getCurrentWorkspace().getFileName());
            System.console().printf("\n", new Object[0]);
            System.console().printf("%s-> Main menu\n", this.app.getCurrentWorkspace().getFileName());
            System.console().printf("\n", new Object[0]);
            System.console().printf("   %20s", MainCommand.SPLIT_PASSWORD.getDisplayName());
            System.console().printf("   %20s", MainCommand.MERGE_PASSWORD.getDisplayName());
            System.console().printf("   %20s", MainCommand.OPEN_WORKSPACE.getDisplayName());
            System.console().printf("\n", new Object[0]);
            System.console().printf("   %20s", MainCommand.CREATE_KEYSTORE.getDisplayName());
            System.console().printf("   %20s", MainCommand.LOAD_KEYSTORE.getDisplayName());
            System.console().printf("   %20s", MainCommand.LIST_WORKSPACE.getDisplayName());
            System.console().printf("\n", new Object[0]);
            System.console().printf("   %20s", MainCommand.EXIT.getDisplayName());
            System.console().printf("\n", new Object[0]);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Menu.Command> computeShortCutMap() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Map<String, Command>", (Object)this, "computeShortCutMap()");
        try {
            EnumSet<MainCommand> mainCommands = EnumSet.allOf(MainCommand.class);
            tracer.out().printfIndentln("mainCommands = %s", new Object[]{mainCommands});
            Map<String, Menu.Command> shortCuts = mainCommands.stream().collect(Collectors.toMap(mainCommand -> mainCommand.getShortCut(), Function.identity()));
            tracer.out().printfIndentln("shortCuts = %s", new Object[]{shortCuts});
            Map<String, Menu.Command> map = shortCuts;
            return map;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Menu.Command> void execute(T command) throws IOException, GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("MainCommand", (Object)this, "execute(Command command)");
        try {
            tracer.out().printfIndentln("command = %s", new Object[]{command});
            MainCommand mainCommand = MainCommand.valueOf(command.toString());
            switch (mainCommand) {
                case SPLIT_PASSWORD: {
                    this.splitPassword();
                    return;
                }
                case MERGE_PASSWORD: {
                    this.mergePassword();
                    return;
                }
                case LOAD_KEYSTORE: {
                    this.loadKeystore();
                    return;
                }
                case LIST_WORKSPACE: {
                    this.listWorkspace();
                    return;
                }
                case CREATE_KEYSTORE: {
                    this.createKeystore();
                    return;
                }
                case OPEN_WORKSPACE: {
                    this.openWorkspace();
                    return;
                }
                case EXIT: {
                    this.exit = true;
                    return;
                }
            }
            return;
        }
        finally {
            tracer.wayout();
        }
    }

    @Override
    public boolean isExit() {
        return this.exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void splitPassword() throws GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "splitPassword()");
        try {
            int LENGTH = 25;
            PasswordGenerator passwordGenerator = new PasswordGenerator(25);
            String proposal = passwordGenerator.generate().findFirst().get();
            String password = this.console.readString("[A-Za-z0-9-]{8,45}", "Password", proposal);
            int shares = this.console.readInt("[0-9]+", "Number of shares");
            int threshold = this.console.readInt("[0-9]+", "Threshold");
            String partition = this.console.readString(PARTITION_PATTERN, "Name of partition");
            int slices = this.console.readInt("[0-9]+", "Number of slices");
            int[] sizes = new int[slices];
            int sum = 0;
            String regex = "[0-9]+";
            for (int i = 0; i < slices; ++i) {
                int size = -1;
                do {
                    String line;
                    if (!Pattern.matches(regex, line = System.console().readLine("%s-> Size[i=%d, sum=%d] (%s): ", this.app.getCurrentWorkspace().getFileName(), i, sum, regex))) continue;
                    size = Integer.parseInt(line);
                } while (size == -1);
                sizes[i] = size;
                sum += size;
            }
            SecretSharing secretSharing = new SecretSharing(shares, threshold, password);
            tracer.out().printfIndentln("secretSharing = %s", new Object[]{secretSharing});
            secretSharing.savePartition(sizes, this.app.getCurrentWorkspace().resolve(partition));
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergePassword() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "mergePassword()");
        try {
            String regex = "(" + PARTITION_PATTERN.pattern() + "-[0-9]+\\.json(,( )*)?)+(" + PARTITION_PATTERN.pattern() + "-[0-9]+\\.json)?";
            String slices = this.console.readString(regex, "Slices");
            String[] files = slices.split(",");
            Path[] paths = new Path[files.length];
            int i = 0;
            for (String file : files) {
                Path path = this.app.getCurrentWorkspace().resolve(file.trim());
                tracer.out().printfIndentln("path = %s", new Object[]{path});
                paths[i++] = path;
            }
            String password = new String(SecretMerging.apply((Path[])paths).password());
            System.console().printf("%s-> password = %s\n", this.app.getCurrentWorkspace().getFileName(), password);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadKeystore() throws GeneralSecurityException, IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "loadKeystore()");
        try {
            String keystoreName = this.console.readString("[A-Za-z-]{1,20}", "Keystore name");
            File keyStoreFile = this.app.getCurrentWorkspace().resolve(keystoreName + ".p12").toFile();
            String regex = "(" + PARTITION_PATTERN.pattern() + "-[0-9]+\\.json(,( )*)?)+(" + PARTITION_PATTERN.pattern() + "-[0-9]+\\.json)?";
            String slices = this.console.readString(regex, "Slices");
            String[] files = slices.split(",");
            Set paths = Stream.of(files).map(file -> this.app.getCurrentWorkspace().resolve(file.trim())).peek(path -> tracer.out().printfIndentln("path = %s", new Object[]{path})).collect(Collectors.toSet());
            KeyStore keyStore = KeyStore.getInstance("ShamirsKeystore", Security.getProvider("Christofs Crypto Lib"));
            ShamirsProtection shamirsProtection = new ShamirsProtection(paths);
            ShamirsLoadParameter shamirsLoadParameter = new ShamirsLoadParameter(keyStoreFile, shamirsProtection);
            keyStore.load((KeyStore.LoadStoreParameter)shamirsLoadParameter);
            this.app.setMenu(new KeyStoreMenu(this.app, keyStore, shamirsLoadParameter));
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createKeystore() throws GeneralSecurityException, IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "createKeystore()");
        try {
            String keystoreName = this.console.readString("[A-Za-z-]{1,20}", "Keystore name");
            File keyStoreFile = this.app.getCurrentWorkspace().resolve(keystoreName + ".p12").toFile();
            String regex = "(" + PARTITION_PATTERN.pattern() + "-[0-9]+\\.json(,( )*)?)+(" + PARTITION_PATTERN.pattern() + "-[0-9]+\\.json)?";
            String slices = this.console.readString(regex, "Slices");
            String[] files = slices.split(",");
            Set paths = Stream.of(files).map(file -> this.app.getCurrentWorkspace().resolve(file.trim())).peek(path -> tracer.out().printfIndentln("path = %s", new Object[]{path})).collect(Collectors.toSet());
            KeyStore keyStore = KeyStore.getInstance("ShamirsKeystore", Security.getProvider("Christofs Crypto Lib"));
            ShamirsProtection shamirsProtection = new ShamirsProtection(paths);
            ShamirsLoadParameter shamirsLoadParameter = new ShamirsLoadParameter(keyStoreFile, shamirsProtection);
            keyStore.load(null, null);
            this.app.setMenu(new KeyStoreMenu(this.app, keyStore, shamirsLoadParameter));
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listWorkspace() throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "listWorkspace()");
        try {
            Set partitions;
            try (Stream<Path> paths = Files.list(this.app.getCurrentWorkspace());){
                partitions = paths.map(path -> path.getFileName().toString()).filter(fileName -> fileName.endsWith(".json")).map(fileName -> fileName.substring(0, fileName.length() - ".json".length())).filter(fileName -> PARTITION_PATTERN.matcher((CharSequence)fileName).matches()).peek(partition -> tracer.out().printfIndentln("partition = %s", new Object[]{partition})).collect(Collectors.toSet());
                System.console().printf("%s-> Partitions: %s\n", this.app.getCurrentWorkspace().getFileName(), partitions);
            }
            partitions.stream().forEach(partition -> {
                Pattern pattern = Pattern.compile(partition + "-[0-9]+\\.json");
                try (Stream<Path> paths = Files.list(this.app.getCurrentWorkspace());){
                    List slices = paths.map(path -> path.getFileName().toString()).filter(fileName -> pattern.matcher((CharSequence)fileName).matches()).sorted().collect(Collectors.toList());
                    System.console().printf("%s-> Slices(%s): %s\n", this.app.getCurrentWorkspace().getFileName(), partition, slices);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
            paths = Files.list(this.app.getCurrentWorkspace());
            try {
                Set keystoreFiles = paths.map(path -> path.getFileName().toString()).filter(fileName -> fileName.endsWith(".p12")).map(fileName -> fileName.substring(0, fileName.length() - ".p12".length())).collect(Collectors.toSet());
                System.console().printf("%s-> Keystores: %s\n", this.app.getCurrentWorkspace().getFileName(), keystoreFiles);
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openWorkspace() throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "openWorkspace()");
        try {
            int LIMIT = 2;
            Path workspaceDir = Paths.get(".", "workspace");
            System.console().printf("%s-> Workspaces:\n\n", this.app.getCurrentWorkspace().getFileName());
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(workspaceDir, path -> path.toFile().isDirectory());){
                int count = 0;
                for (Path path2 : paths) {
                    System.console().printf("   %20s", path2.getFileName());
                    if (++count != 2) continue;
                    System.console().printf("\n", new Object[0]);
                    count = 0;
                }
                if (count == 0) {
                    System.console().printf("\n", new Object[0]);
                } else {
                    System.console().printf("\n\n", new Object[0]);
                }
            }
            Path workspace = Path.of(this.console.readString("[A-Za-z0-9-]{8,45}", "Workspace"), new String[0]);
            workspace = workspaceDir.resolve(workspace);
            if (Files.exists(workspace, new LinkOption[0]) && !Files.isDirectory(workspace, new LinkOption[0])) {
                throw new IOException(String.format("%s isn't a directory.", workspace));
            }
            if (!Files.exists(workspace, new LinkOption[0])) {
                Files.createDirectory(workspace, new FileAttribute[0]);
            }
            this.app.setCurrentWorkspace(workspace);
        }
        finally {
            tracer.wayout();
        }
    }

    public static enum MainCommand implements Menu.Command
    {
        SPLIT_PASSWORD("s", "split password"),
        MERGE_PASSWORD("m", "merge password"),
        OPEN_WORKSPACE("o", "open workspace"),
        CREATE_KEYSTORE("c", "create keystore"),
        LIST_WORKSPACE("li", "list workspace"),
        LOAD_KEYSTORE("lo", "load keystore"),
        EXIT("e", "exit");

        String shortCut;
        String fullName;

        private MainCommand(String shortCut, String fullName) {
            this.shortCut = shortCut;
            this.fullName = fullName;
        }

        @Override
        public String getShortCut() {
            return this.shortCut;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getDisplayName() {
            return this.fullName.replaceFirst(this.shortCut, "(" + this.shortCut + ")");
        }
    }
}

