/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.JDKLoggingRouter;
import de.christofreichardt.diagnosis.NullTracer;
import de.christofreichardt.diagnosis.QueueNullTracer;
import de.christofreichardt.diagnosis.QueueTracer;
import de.christofreichardt.diagnosis.TracerConfigNamespaceContextImpl;
import de.christofreichardt.util.PropertyExpression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TracerFactory {
    static final NullTracer NULLTRACER = new JDKLoggingRouter();
    private final Map<String, Element> threadName2Element = new HashMap<String, Element>();
    private final Map<String, AbstractTracer> tracerPool = new HashMap<String, AbstractTracer>();
    private final Map<Long, AbstractTracer> tracerMap = new ConcurrentHashMap<Long, AbstractTracer>();
    private final Set<String> threadNames = Collections.newSetFromMap(new ConcurrentHashMap());
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    private NullTracer defaultTracer = NULLTRACER;
    private final ReentrantReadWriteLock poolLock = new ReentrantReadWriteLock();
    private final Lock poolReadLock = this.poolLock.readLock();
    private final Lock poolWriteLock = this.poolLock.writeLock();
    private final ReentrantReadWriteLock queueLock = new ReentrantReadWriteLock();
    private final Lock queueReadLock = this.queueLock.readLock();
    private final Lock queueWriteLock = this.queueLock.writeLock();
    private Queue queueConfig = new Queue();

    public static TracerFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private TracerFactory() {
        this.xpath.setNamespaceContext(new TracerConfigNamespaceContextImpl());
    }

    public NullTracer getDefaultTracer() {
        return this.defaultTracer;
    }

    public int getQueueSize() {
        this.queueReadLock.lock();
        try {
            int n = this.queueConfig.size;
            return n;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    public boolean isQueueEnabled() {
        this.queueReadLock.lock();
        try {
            boolean bl = this.queueConfig.enabled;
            return bl;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    public String getQueueTracerClassname() {
        this.queueReadLock.lock();
        try {
            String string = this.queueConfig.className;
            return string;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    public void readConfiguration(File configFile) throws Exception, IOException {
        if (!configFile.exists()) {
            throw new FileNotFoundException(configFile + "doesn't exist.");
        }
        try (FileInputStream fileInputStream = new FileInputStream(configFile);){
            this.readConfiguration(fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws Exception {
        try {
            XMLConfig xmlConfig = new XMLConfig(inputStream);
            xmlConfig.evaluatePropertyExpressions();
            xmlConfig.validate();
            this.poolWriteLock.lock();
            try {
                NodeList tracerNodes = (NodeList)this.xpath.evaluate("/dns:TraceConfig/dns:Pool/dns:TraceLogger", xmlConfig.documentElement(), XPathConstants.NODESET);
                System.out.println();
                System.out.println("Configured Pool Tracers = " + tracerNodes.getLength());
                for (int i = 0; i < tracerNodes.getLength(); ++i) {
                    System.out.println();
                    System.out.println("(+) " + (i + 1) + ". TraceLogger");
                    Element tracerElement = (Element)tracerNodes.item(i);
                    if (!tracerElement.hasAttribute("name")) {
                        throw new Exception("Missing 'name' attribute.");
                    }
                    String name = tracerElement.getAttribute("name");
                    String className = tracerElement.getAttribute("class");
                    System.out.println("name = " + name);
                    System.out.println("className = " + className);
                    Class<?> tracerClass = Class.forName(className);
                    if (!AbstractTracer.class.isAssignableFrom(tracerClass)) {
                        throw new Exception(String.format("Illegal tracer class: '%s'", className));
                    }
                    AbstractTracer tracer = this.createTracer(tracerClass, name);
                    tracer.readConfiguration(this.xpath, tracerElement);
                    this.tracerPool.put(name, tracer);
                }
                NodeList threadNodes = (NodeList)this.xpath.evaluate("/dns:TraceConfig/dns:Map/dns:Threads/dns:Thread", xmlConfig.documentElement(), XPathConstants.NODESET);
                System.out.println();
                System.out.println("Configured Tracermappings = " + threadNodes.getLength());
                for (int i = 0; i < threadNodes.getLength(); ++i) {
                    System.out.println();
                    System.out.println("(+) " + (i + 1) + ". Mapping");
                    Element threadElement = (Element)threadNodes.item(i);
                    String threadName = threadElement.getAttribute("name");
                    String referencedTracerName = (String)this.xpath.evaluate("./dns:TraceLogger/@ref", threadElement, XPathConstants.STRING);
                    System.out.println(threadName + " => " + referencedTracerName);
                    this.threadName2Element.put(threadName, threadElement);
                }
                Node defaultTracerNode = (Node)this.xpath.evaluate("/dns:TraceConfig/dns:DefaultTracer", xmlConfig.documentElement(), XPathConstants.NODE);
                if (defaultTracerNode != null) {
                    NullTracer nullTracer;
                    String className = ((Element)defaultTracerNode).getAttribute("class");
                    Class<?> tracerClass = Class.forName(className);
                    if (!NullTracer.class.isAssignableFrom(tracerClass)) {
                        throw new Exception("Requiring a NullTracer as default tracer!");
                    }
                    this.defaultTracer = nullTracer = this.createTracer(tracerClass);
                } else {
                    this.defaultTracer = NULLTRACER;
                }
            }
            finally {
                this.poolWriteLock.unlock();
            }
            this.queueWriteLock.lock();
            try {
                Node queueNode = (Node)this.xpath.evaluate("/dns:TraceConfig/dns:Queue", xmlConfig.documentElement(), XPathConstants.NODE);
                this.queueConfig = queueNode != null ? new Queue(queueNode) : new Queue();
            }
            finally {
                this.queueWriteLock.unlock();
            }
        }
        catch (AbstractTracer.Exception | IOException | ClassNotFoundException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            throw new Exception(ex);
        }
    }

    private NullTracer createTracer(Class<? extends NullTracer> tracerClass) throws Exception {
        try {
            Constructor<? extends NullTracer> constructor = tracerClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new Exception(ex);
        }
    }

    private AbstractTracer createTracer(Class<? extends AbstractTracer> tracerClass, String name) throws Exception {
        try {
            Constructor<? extends AbstractTracer> constructor = tracerClass.getConstructor(String.class);
            return constructor.newInstance(name);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new Exception(ex);
        }
    }

    private AbstractTracer getTracerByName(String name) throws Exception {
        if (!this.tracerPool.containsKey(name)) {
            throw new Exception("Unknown tracer: '" + name + "'");
        }
        return this.tracerPool.get(name);
    }

    public AbstractTracer getTracer(String name) throws Exception {
        this.poolReadLock.lock();
        try {
            AbstractTracer abstractTracer = this.getTracerByName(name);
            return abstractTracer;
        }
        finally {
            this.poolReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTracer getTracer(Thread thread) {
        this.poolReadLock.lock();
        try {
            AbstractTracer tracer;
            if (!this.tracerMap.containsKey(thread.getId())) {
                if (this.threadNames.contains(thread.getName())) {
                    System.err.printf("WARNING: Duplicate thread name \"%s\" encountered.%n", thread.getName());
                    tracer = this.defaultTracer;
                } else if (this.threadName2Element.containsKey(thread.getName())) {
                    try {
                        Element threadElement = this.threadName2Element.get(thread.getName());
                        String referencedTracerName = (String)this.xpath.evaluate("./dns:TraceLogger/@ref", threadElement, XPathConstants.STRING);
                        tracer = this.getTracerByName(referencedTracerName);
                        this.tracerMap.put(thread.getId(), tracer);
                        this.threadNames.add(thread.getName());
                    }
                    catch (Exception | XPathExpressionException ex) {
                        tracer = this.defaultTracer;
                    }
                } else {
                    tracer = this.defaultTracer;
                }
            } else {
                tracer = this.tracerMap.get(thread.getId());
            }
            AbstractTracer abstractTracer = tracer;
            return abstractTracer;
        }
        finally {
            this.poolReadLock.unlock();
        }
    }

    public AbstractTracer getCurrentPoolTracer() {
        return this.getTracer(Thread.currentThread());
    }

    public void reset() {
        this.poolWriteLock.lock();
        try {
            this.defaultTracer = NULLTRACER;
            this.threadName2Element.clear();
            this.threadNames.clear();
            this.tracerMap.clear();
            this.tracerPool.clear();
        }
        finally {
            this.poolWriteLock.unlock();
        }
        this.queueWriteLock.lock();
        try {
            this.queueConfig = new Queue();
        }
        finally {
            this.queueWriteLock.unlock();
        }
    }

    public void openPoolTracer() {
        this.poolWriteLock.lock();
        try {
            for (AbstractTracer tracer : this.tracerPool.values()) {
                tracer.open();
            }
        }
        finally {
            this.poolWriteLock.unlock();
        }
    }

    public void closePoolTracer() {
        this.poolWriteLock.lock();
        try {
            for (AbstractTracer tracer : this.tracerPool.values()) {
                tracer.close();
            }
        }
        finally {
            this.poolWriteLock.unlock();
        }
    }

    public QueueTracer<? extends AbstractTracer> takeTracer() {
        this.queueReadLock.lock();
        try {
            QueueTracer tracer;
            if (this.queueConfig.enabled) {
                try {
                    tracer = this.queueConfig.blockingTracerDeque.takeFirst();
                    this.queueConfig.currentTracer.set(tracer);
                }
                catch (InterruptedException ex) {
                    System.err.printf("Interrupted when waiting for a QueueTracer... %n", new Object[0]);
                    tracer = this.queueConfig.queueNullTracer;
                }
            } else {
                tracer = this.queueConfig.queueNullTracer;
            }
            QueueNullTracer queueNullTracer = tracer;
            return queueNullTracer;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean offerTracer(QueueTracer<? extends AbstractTracer> tracer) {
        boolean success = false;
        this.queueReadLock.lock();
        try {
            if (this.queueConfig.enabled && !(tracer instanceof QueueNullTracer) && (success = this.queueConfig.blockingTracerDeque.offerLast(tracer))) {
                this.queueConfig.currentTracer.remove();
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openQueueTracer() {
        int TRIALS = 5;
        int tracerCounter = 0;
        int trialCounter = 0;
        boolean success = false;
        do {
            this.queueWriteLock.lock();
            try {
                if (!this.queueConfig.enabled) continue;
                for (QueueTracer<? extends AbstractTracer> queueTracer : this.queueConfig.blockingTracerDeque) {
                    if (queueTracer.isOpened()) continue;
                    queueTracer.open();
                    if (++tracerCounter != this.queueConfig.size) continue;
                    success = true;
                }
            }
            finally {
                this.queueWriteLock.unlock();
            }
        } while (tracerCounter < this.queueConfig.size && ++trialCounter < 5);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeQueueTracer() {
        int TRIALS = 5;
        int tracerCounter = 0;
        int trialCounter = 0;
        boolean success = false;
        do {
            this.queueWriteLock.lock();
            try {
                if (!this.queueConfig.enabled) continue;
                for (QueueTracer<? extends AbstractTracer> queueTracer : this.queueConfig.blockingTracerDeque) {
                    if (!queueTracer.isOpened()) continue;
                    queueTracer.close();
                    if (++tracerCounter != this.queueConfig.size) continue;
                    success = true;
                }
            }
            finally {
                this.queueWriteLock.unlock();
            }
        } while (tracerCounter < this.queueConfig.size && ++trialCounter < 5);
        return success;
    }

    public QueueTracer<?> getCurrentQueueTracer() {
        this.queueReadLock.lock();
        try {
            QueueTracer tracer;
            if (this.queueConfig.enabled) {
                tracer = this.queueConfig.currentTracer.get();
                if (tracer == null) {
                    tracer = this.queueConfig.queueNullTracer;
                }
            } else {
                tracer = this.queueConfig.queueNullTracer;
            }
            QueueNullTracer queueNullTracer = tracer;
            return queueNullTracer;
        }
        finally {
            this.queueReadLock.unlock();
        }
    }

    static class XMLConfig {
        final Document tracerConfigDoc;
        final DOMResult domResult;
        final List<String> xpathExpressions;

        XMLConfig(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder parser = builderFactory.newDocumentBuilder();
            this.tracerConfigDoc = parser.parse(inputStream);
            this.domResult = new DOMResult(this.tracerConfigDoc);
            this.xpathExpressions = List.of("/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:LogDir/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:AutoFlush/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:BufSize/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:Limit/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:Context/dns:Thread/dns:Online/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:Context/dns:Thread/dns:DebugLevel/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:Listener/dns:Port/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:Listener/dns:Host/text()", "/dns:TraceConfig/dns:Queue/dns:Enabled/text()", "/dns:TraceConfig/dns:Queue/dns:Size/text()", "/dns:TraceConfig/dns:Queue/dns:Online/text()", "/dns:TraceConfig/dns:Queue/dns:DebugLevel/text()", "/dns:TraceConfig/dns:Queue/dns:TraceLogger/dns:LogDir/text()", "/dns:TraceConfig/dns:Queue/dns:TraceLogger/dns:AutoFlush/text()", "/dns:TraceConfig/dns:Queue/dns:TraceLogger/dns:BufSize/text()", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/@name", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/@class", "/dns:TraceConfig/dns:Pool/dns:TraceLogger/dns:Context/dns:Thread/@name", "/dns:TraceConfig/dns:DefaultTracer/@class", "/dns:TraceConfig/dns:Queue/dns:TraceLogger/@name", "/dns:TraceConfig/dns:Queue/dns:TraceLogger/@class");
        }

        void validate() throws IOException, SAXException {
            try (InputStream inputStream = TracerFactory.class.getClassLoader().getResourceAsStream("de/christofreichardt/diagnosis/TraceConfigSchema.xsd");){
                StreamSource streamSource = new StreamSource(inputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(streamSource);
                DOMSource domSource = new DOMSource(this.tracerConfigDoc);
                Validator traceConfigValidator = schema.newValidator();
                ErrorHandler errorHandler = new ErrorHandler();
                traceConfigValidator.setErrorHandler(errorHandler);
                traceConfigValidator.validate(domSource, this.domResult);
            }
        }

        void evaluatePropertyExpressions() throws Exception {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return "http://www.christofreichardt.de/java/tracer";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return "dns";
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            });
            PropertyExpression propertyExpression = new PropertyExpression(System.getProperties());
            for (String xpathExpression : this.xpathExpressions) {
                try {
                    NodeList nodeList = (NodeList)xpath.evaluate(xpathExpression, this.documentElement(), XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (Objects.nonNull(node) && node.getNodeType() == 3) {
                            node.setTextContent(propertyExpression.replace(node.getTextContent()));
                            continue;
                        }
                        if (!Objects.nonNull(node) || node.getNodeType() != 2) continue;
                        Attr attr = (Attr)node;
                        attr.setValue(propertyExpression.replace(attr.getValue()));
                    }
                }
                catch (XPathExpressionException ex) {
                    throw new Exception(ex);
                }
            }
        }

        Element documentElement() {
            Document document = (Document)this.domResult.getNode();
            return document.getDocumentElement();
        }
    }

    protected class Queue {
        private final boolean enabled;
        private final int size;
        private final String className;
        private final BlockingDeque<QueueTracer<? extends AbstractTracer>> blockingTracerDeque;
        private final QueueNullTracer queueNullTracer;
        private final ThreadLocal<QueueTracer<? extends AbstractTracer>> currentTracer;

        Queue() {
            this.queueNullTracer = new QueueNullTracer(TracerFactory.this.defaultTracer);
            this.enabled = false;
            this.size = 0;
            this.blockingTracerDeque = null;
            this.className = null;
            this.currentTracer = null;
        }

        Queue(Node node) throws XPathExpressionException, Exception, AbstractTracer.Exception {
            this.queueNullTracer = new QueueNullTracer(TracerFactory.this.defaultTracer);
            Node enabledNode = (Node)TracerFactory.this.xpath.evaluate("./dns:Enabled", node, XPathConstants.NODE);
            this.enabled = enabledNode != null ? Boolean.parseBoolean(enabledNode.getTextContent().strip()) : false;
            if (this.enabled) {
                this.size = Integer.parseInt(((String)TracerFactory.this.xpath.evaluate("./dns:Size", node, XPathConstants.STRING)).strip());
                this.className = (String)TracerFactory.this.xpath.evaluate("./dns:TraceLogger/@class", node, XPathConstants.STRING);
                this.blockingTracerDeque = new LinkedBlockingDeque<QueueTracer<? extends AbstractTracer>>(this.size);
                this.currentTracer = new ThreadLocal();
                this.init(node);
            } else {
                this.size = 0;
                this.className = null;
                this.blockingTracerDeque = null;
                this.currentTracer = null;
            }
        }

        private void init(Node node) throws Exception, XPathExpressionException, AbstractTracer.Exception {
            try {
                for (int i = 0; i < this.size; ++i) {
                    Class<?> clazz = Class.forName(this.className);
                    if (!QueueTracer.class.isAssignableFrom(clazz)) {
                        throw new Exception("Need a QueueTracer class but found '" + clazz.getName() + "'.");
                    }
                    Class<?> tracerClass = clazz;
                    if (QueueNullTracer.class.isAssignableFrom(tracerClass)) {
                        throw new Exception("No QueueNullTracer allowed here.");
                    }
                    String tracerName = (String)TracerFactory.this.xpath.evaluate("./dns:TraceLogger/@name", node, XPathConstants.STRING);
                    Constructor<?> constructor = tracerClass.getConstructor(String.class);
                    QueueTracer queueTracer = (QueueTracer)constructor.newInstance(tracerName + i);
                    queueTracer.readConfiguration(TracerFactory.this.xpath, node);
                    this.blockingTracerDeque.offerLast(queueTracer);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new Exception(ex);
            }
        }
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String msg) {
            super(msg);
        }

        public Exception(Throwable cause) {
            super(cause);
        }
    }

    private static final class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException ex) {
            System.err.println(ex.getMessage());
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw new SAXException(ex);
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw new SAXException(ex);
        }
    }

    private static final class InstanceHolder {
        static final TracerFactory INSTANCE = new TracerFactory();

        private InstanceHolder() {
        }
    }
}

