/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.DebugConfig;
import de.christofreichardt.diagnosis.TraceMethod;
import java.util.ArrayDeque;
import java.util.Deque;

public class TracingContext {
    private int debugLevel = -1;
    private boolean online = false;
    private final Deque<TraceMethod> methodStack = new ArrayDeque<TraceMethod>();
    private boolean corrupted = false;

    TracingContext(int debugLevel, boolean online) {
        this.debugLevel = debugLevel;
        this.online = online;
    }

    TracingContext(DebugConfig debugConfig) {
        this.debugLevel = debugConfig.getLevel();
        this.online = debugConfig.isOnline();
    }

    int getDebugLevel() {
        return this.debugLevel;
    }

    void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    boolean isOnline() {
        return this.online & !this.corrupted;
    }

    void setOnline(boolean online) {
        this.online = online;
    }

    Deque<TraceMethod> getMethodStack() {
        return this.methodStack;
    }

    boolean isCorrupted() {
        return this.corrupted;
    }

    void setCorrupted(boolean corrupted) {
        this.corrupted = corrupted;
    }
}

