/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis.net;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.io.TracePrintStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public class NetTracer
extends AbstractTracer {
    public static final int TIMEOUT = 5000;
    protected int portNo;
    protected String hostName = "localhost";
    protected Socket pizzaConnection = null;

    public NetTracer(String name) {
        super(name);
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    protected void readConfiguration(XPath xpath, Node node) throws XPathExpressionException, AbstractTracer.Exception {
        super.readConfiguration(xpath, node);
        this.hostName = (String)xpath.evaluate("./dns:Listener/dns:Host/text()", node, XPathConstants.STRING);
        this.portNo = Integer.parseInt((String)xpath.evaluate("./dns:Listener/dns:Port/text()", node, XPathConstants.STRING));
        System.out.println("this.hostName = " + this.hostName);
        System.out.println("this.portNo = " + this.portNo);
    }

    @Override
    public void open() {
        try {
            if (!this.isOpened()) {
                System.out.printf("%s Opening [%s, %d] ...%n", this.formatVersionInfo(), this.hostName, this.portNo);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.hostName, this.portNo);
                this.pizzaConnection = new Socket();
                this.pizzaConnection.connect(inetSocketAddress, 5000);
                this.setBufferedOutputStream(new BufferedOutputStream(this.pizzaConnection.getOutputStream(), this.getBufferSize()));
                this.setTracePrintStream(new TracePrintStream(this.getBufferedOutputStream(), this.getThreadMap()));
                this.sendUserCredentials();
                this.getTracePrintStream().printf("--> TraceLog opened!%n", new Object[0]);
                this.getTracePrintStream().printf("    Time     : %tc%n", new Date());
                this.getTracePrintStream().printf("    Bufsize  : %d%n", this.getBufferSize());
                this.getTracePrintStream().printf("    Autoflush: %b%n%n", this.isAutoflush());
                this.setOpened(true);
            } else {
                System.err.println("WARNING: Tracelog is opened already.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.getTracePrintStream().println();
                this.getTracePrintStream().printf("--> TraceLog closing!%n", new Object[0]);
                this.getTracePrintStream().printf("    Time     : %tc%n", new Date());
                System.out.printf("%s Closing [%s, %d] ...%n", this.formatStreamErrorState(), this.hostName, this.portNo);
                this.getTracePrintStream().close();
                this.getBufferedOutputStream().close();
                this.pizzaConnection.close();
                this.setOpened(false);
            } else {
                System.err.println("WARNING: Tracelog is closed already.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    protected void sendUserCredentials() throws UnknownHostException {
        this.getTracePrintStream().printf("user = %s, host = %s, name = %s%n", System.getProperty("user.name"), InetAddress.getLocalHost().getHostName(), super.getName());
    }
}

