/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.util;

import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyExpression {
    static final int MAX_DEPTH = 5;
    final Map<Object, Object> properties;
    final Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z0-9.]+}");

    public PropertyExpression(Properties properties) {
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String replace(String expression, boolean recursive) {
        return this.replace(expression, recursive, 0);
    }

    public String replace(String expression) {
        return this.replace(expression, false, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String replace(String expression, boolean recursive, int depth) {
        if (depth > 5) {
            throw new RuntimeException("Too much recursion.");
        }
        Matcher matcher = this.pattern.matcher(expression);
        if (matcher.matches()) {
            String key = expression.substring(2, expression.length() - 1);
            if (!this.properties.containsKey(key)) throw new NoSuchElementException(key);
            expression = (String)this.properties.get(key);
            if (!recursive) return expression;
            return this.replace(expression, true, ++depth);
        }
        int pos = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean found = false;
        while (matcher.find()) {
            found = true;
            stringBuilder.append(expression, pos, matcher.start());
            String key = expression.substring(matcher.start() + 2, matcher.end() - 1);
            if (!this.properties.containsKey(key)) throw new NoSuchElementException(key);
            stringBuilder.append(this.properties.get(key));
            pos = matcher.end();
        }
        stringBuilder.append(expression, pos, expression.length());
        if (!found) return stringBuilder.toString();
        if (!recursive) return stringBuilder.toString();
        return this.replace(stringBuilder.toString(), true, ++depth);
    }
}

