/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.NullTracer;
import de.christofreichardt.diagnosis.TraceMethod;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public abstract class DebugLogTee<T extends AbstractTracer>
extends AbstractTracer {
    protected final T tracer;

    public DebugLogTee(String name, T tracer) {
        super(name);
        if (NullTracer.class.isAssignableFrom(tracer.getClass())) {
            throw new IllegalArgumentException("NullTracers aren't allowed.");
        }
        this.tracer = tracer;
    }

    @Override
    public final Object getSyncObject() {
        return ((AbstractTracer)this.tracer).getSyncObject();
    }

    @Override
    public final int getBufferSize() {
        return ((AbstractTracer)this.tracer).getBufferSize();
    }

    @Override
    public final boolean isAutoflush() {
        return ((AbstractTracer)this.tracer).isAutoflush();
    }

    @Override
    public final boolean isOpened() {
        return ((AbstractTracer)this.tracer).isOpened();
    }

    @Override
    public final String getName() {
        return super.getName();
    }

    @Override
    public final void setBufferSize(int bufferSize) {
        ((AbstractTracer)this.tracer).setBufferSize(bufferSize);
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        ((AbstractTracer)this.tracer).setAutoflush(autoflush);
    }

    @Override
    protected final void readConfiguration(XPath xpath, Node node) throws XPathExpressionException, AbstractTracer.Exception {
        ((AbstractTracer)this.tracer).readConfiguration(xpath, node);
    }

    @Override
    public void open() {
        ((AbstractTracer)this.tracer).open();
    }

    @Override
    public void close() {
        ((AbstractTracer)this.tracer).close();
    }

    @Override
    public final void initCurrentTracingContext() {
        ((AbstractTracer)this.tracer).initCurrentTracingContext();
    }

    @Override
    public final void initCurrentTracingContext(int debugLevel, boolean online) {
        ((AbstractTracer)this.tracer).initCurrentTracingContext(debugLevel, online);
    }

    protected abstract void adapt(LogLevel var1, String var2, Class var3);

    protected abstract void adapt(LogLevel var1, Throwable var2, Class var3);

    @Override
    public TraceMethod entry(String returnType, Class clazz, String methodSignature) {
        return ((AbstractTracer)this.tracer).entry(returnType, clazz, methodSignature);
    }

    @Override
    public TraceMethod entry(String returnType, Object object, String methodSignature) {
        return ((AbstractTracer)this.tracer).entry(returnType, object, methodSignature);
    }

    @Override
    @Deprecated
    public TraceMethod entry(String methodSignature) {
        return ((AbstractTracer)this.tracer).entry(methodSignature);
    }

    @Override
    public final void logMessage(LogLevel logLevel, String message, Class clazz, String methodName) {
        ((AbstractTracer)this.tracer).logMessage(logLevel, message, clazz, methodName);
        this.adapt(logLevel, message, clazz);
    }

    @Override
    public final void logException(LogLevel logLevel, Throwable throwable, Class clazz, String methodName) {
        ((AbstractTracer)this.tracer).logException(logLevel, throwable, clazz, methodName);
        this.adapt(logLevel, throwable, clazz);
    }

    @Override
    public TraceMethod wayout() {
        return ((AbstractTracer)this.tracer).wayout();
    }

    @Override
    public final IndentablePrintStream out() {
        return ((AbstractTracer)this.tracer).out();
    }
}

