/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.AbstractThreadMap;
import de.christofreichardt.diagnosis.TraceMethod;
import de.christofreichardt.diagnosis.TracingContext;
import java.util.NoSuchElementException;

public class ThreadLocalMap
extends AbstractThreadMap {
    private final ThreadLocal<TracingContext> currentTracingContext = new ThreadLocal();

    @Override
    public int getCurrentStackSize() {
        int stackSize = this.currentTracingContext.get() != null ? this.currentTracingContext.get().getMethodStack().size() : -1;
        return stackSize;
    }

    @Override
    TracingContext getCurrentTracingContext() {
        return this.currentTracingContext.get();
    }

    @Override
    void setCurrentTracingContext(TracingContext tracingContext) {
        this.currentTracingContext.set(tracingContext);
    }

    @Override
    TracingContext removeCurrentTracingContext() {
        TracingContext tracingContext = this.currentTracingContext.get();
        this.currentTracingContext.remove();
        return tracingContext;
    }

    @Override
    boolean push(TraceMethod traceMethod) {
        boolean success;
        if (this.currentTracingContext.get() != null && !this.currentTracingContext.get().isCorrupted()) {
            if (this.currentTracingContext.get().getMethodStack().size() >= 50) {
                this.currentTracingContext.get().setCorrupted(true);
                throw new AbstractThreadMap.RuntimeException("Stacksize is exceeded.");
            }
            this.currentTracingContext.get().getMethodStack().push(traceMethod);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    @Override
    TraceMethod pop() {
        TraceMethod traceMethod = null;
        if (this.currentTracingContext.get() != null && !this.currentTracingContext.get().isCorrupted()) {
            try {
                traceMethod = this.currentTracingContext.get().getMethodStack().pop();
                traceMethod.stopTime();
            }
            catch (NoSuchElementException ex) {
                this.currentTracingContext.get().setCorrupted(true);
                throw new AbstractThreadMap.RuntimeException(ex);
            }
        }
        return traceMethod;
    }
}

