/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.NullTracer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JDKLoggingRouter
extends NullTracer {
    protected Level convertToJDK14Level(LogLevel logLevel) {
        Level level = Level.OFF;
        switch (logLevel) {
            case INFO: {
                level = Level.INFO;
                break;
            }
            case WARNING: {
                level = Level.WARNING;
                break;
            }
            case ERROR: 
            case FATAL: 
            case SEVERE: {
                level = Level.SEVERE;
            }
        }
        return level;
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Class clazz, String methodName) {
        Logger logger = Logger.getLogger(clazz.getName());
        logger.logp(this.convertToJDK14Level(logLevel), clazz.getName(), methodName, message);
    }

    @Override
    public void logException(LogLevel logLevel, Throwable throwable, Class clazz, String methodName) {
        Logger logger = Logger.getLogger(clazz.getName());
        logger.logp(this.convertToJDK14Level(logLevel), clazz.getName(), "-", throwable.getMessage(), throwable);
    }
}

