/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.AbstractThreadMap;
import de.christofreichardt.diagnosis.TraceMethod;
import de.christofreichardt.diagnosis.TracingContext;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ThreadMap
extends AbstractThreadMap {
    private final ConcurrentMap<Thread, TracingContext> tracingContextMap = new ConcurrentHashMap<Thread, TracingContext>();

    @Override
    public int getCurrentStackSize() {
        int stackSize = -1;
        if (this.tracingContextMap.containsKey(Thread.currentThread())) {
            stackSize = ((TracingContext)this.tracingContextMap.get(Thread.currentThread())).getMethodStack().size();
        }
        return stackSize;
    }

    @Override
    TracingContext getCurrentTracingContext() {
        TracingContext tracingContext = null;
        if (this.tracingContextMap.containsKey(Thread.currentThread())) {
            tracingContext = (TracingContext)this.tracingContextMap.get(Thread.currentThread());
        }
        return tracingContext;
    }

    @Override
    void setCurrentTracingContext(TracingContext tracingContext) {
        this.tracingContextMap.put(Thread.currentThread(), tracingContext);
    }

    @Override
    TracingContext removeCurrentTracingContext() {
        return (TracingContext)this.tracingContextMap.remove(Thread.currentThread());
    }

    @Override
    boolean push(TraceMethod traceMethod) {
        boolean success;
        TracingContext currentTracingContext = this.getCurrentTracingContext();
        if (currentTracingContext != null && !currentTracingContext.isCorrupted()) {
            if (currentTracingContext.getMethodStack().size() >= 50) {
                currentTracingContext.setCorrupted(true);
                throw new AbstractThreadMap.RuntimeException("Stacksize is exceeded.");
            }
            currentTracingContext.getMethodStack().push(traceMethod);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    @Override
    TraceMethod pop() {
        TraceMethod traceMethod = null;
        TracingContext currentTracingContext = this.getCurrentTracingContext();
        if (currentTracingContext != null && !currentTracingContext.isCorrupted()) {
            try {
                traceMethod = currentTracingContext.getMethodStack().pop();
                traceMethod.stopTime();
            }
            catch (NoSuchElementException ex) {
                currentTracingContext.setCorrupted(true);
                throw new AbstractThreadMap.RuntimeException(ex);
            }
        }
        return traceMethod;
    }
}

