/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.AbstractThreadMap;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.TraceMethod;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public abstract class QueueTracer<T extends AbstractTracer>
extends AbstractTracer {
    private boolean online;
    private int level;
    protected final T tracer;

    public QueueTracer(String name, T tracer) {
        super(name);
        this.tracer = tracer;
    }

    @Override
    public Object getSyncObject() {
        return ((AbstractTracer)this.tracer).getSyncObject();
    }

    @Override
    public int getBufferSize() {
        return ((AbstractTracer)this.tracer).getBufferSize();
    }

    @Override
    public boolean isAutoflush() {
        return ((AbstractTracer)this.tracer).isAutoflush();
    }

    @Override
    public boolean isOpened() {
        return ((AbstractTracer)this.tracer).isOpened();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        ((AbstractTracer)this.tracer).setBufferSize(bufferSize);
    }

    @Override
    protected void setAutoflush(boolean autoflush) {
        ((AbstractTracer)this.tracer).setAutoflush(autoflush);
    }

    @Override
    protected void readConfiguration(XPath xpath, Node node) throws XPathExpressionException, AbstractTracer.Exception {
        this.online = (Boolean)xpath.evaluate("./dns:Online/text()", node, XPathConstants.BOOLEAN);
        this.level = Integer.parseInt((String)xpath.evaluate("./dns:DebugLevel/text()", node, XPathConstants.STRING));
        this.setAutoflush((Boolean)xpath.evaluate("./dns:TraceLogger/dns:AutoFlush/text()", node, XPathConstants.BOOLEAN));
        this.setBufferSize(Integer.parseInt((String)xpath.evaluate("./dns:TraceLogger/dns:BufSize/text()", node, XPathConstants.STRING)));
    }

    @Override
    public void open() {
        ((AbstractTracer)this.tracer).open();
    }

    @Override
    public void close() {
        ((AbstractTracer)this.tracer).close();
    }

    @Override
    public void initCurrentTracingContext() {
        ((AbstractTracer)this.tracer).initCurrentTracingContext(this.level, this.online);
    }

    @Override
    public void initCurrentTracingContext(int debugLevel, boolean online) {
        ((AbstractTracer)this.tracer).initCurrentTracingContext(debugLevel, online);
    }

    @Override
    public TraceMethod entry(String returnType, Class<?> clazz, String methodSignature) {
        return ((AbstractTracer)this.tracer).entry(returnType, clazz, methodSignature);
    }

    @Override
    public TraceMethod entry(String returnType, Object object, String methodSignature) {
        return ((AbstractTracer)this.tracer).entry(returnType, object, methodSignature);
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Class<?> clazz, String methodName) {
        ((AbstractTracer)this.tracer).logMessage(logLevel, message, clazz, methodName);
    }

    @Override
    public void logException(LogLevel logLevel, Throwable throwable, Class<?> clazz, String methodName) {
        ((AbstractTracer)this.tracer).logException(logLevel, throwable, clazz, methodName);
    }

    @Override
    protected AbstractThreadMap getThreadMap() {
        return ((AbstractTracer)this.tracer).getThreadMap();
    }

    @Override
    public TraceMethod wayout() {
        TraceMethod traceMethod = ((AbstractTracer)this.tracer).wayout();
        if (this.getThreadMap().getCurrentStackSize() == 0) {
            this.clearCurrentTracingContext();
            if (!TracerFactory.getInstance().offerTracer(this)) {
                System.err.printf("WARNING: Offer failed. Possible queue corruption.%n", new Object[0]);
            }
        }
        return traceMethod;
    }

    @Override
    public IndentablePrintStream out() {
        return ((AbstractTracer)this.tracer).out();
    }

    @Override
    protected IndentablePrintStream out(int level) {
        return ((AbstractTracer)this.tracer).out(level);
    }

    @Override
    public void clearCurrentTracingContext() {
        ((AbstractTracer)this.tracer).clearCurrentTracingContext();
    }
}

