/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis.file;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import de.christofreichardt.diagnosis.io.TracePrintStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Date;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public class FileTracer
extends AbstractTracer {
    protected File traceLogfile;
    protected FileOutputStream fileOutputStream;
    protected volatile long byteLimit = -1L;
    protected Path logDirPath = FileSystems.getDefault().getPath("log", new String[0]);
    protected int counter = -1;

    public FileTracer(String name) {
        super(name);
    }

    public Path getLogDirPath() {
        return this.logDirPath;
    }

    public void setLogDirPath(Path logDirPath) {
        if (!logDirPath.toFile().isDirectory()) {
            throw new IllegalArgumentException("Need a path to a directory.");
        }
        this.logDirPath = logDirPath;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    public void setByteLimit(long byteLimit) {
        this.byteLimit = byteLimit;
    }

    @Override
    public void open() {
        try {
            if (!this.isOpened()) {
                System.out.println(this.formatVersionInfo() + " Opening ...");
                this.traceLogfile = FileSystems.getDefault().getPath(this.logDirPath.toString(), super.getName() + ".log").toFile();
                this.fileOutputStream = new FileOutputStream(this.traceLogfile);
                this.setBufferedOutputStream(new BufferedOutputStream(this.fileOutputStream, this.getBufferSize()));
                this.setTracePrintStream(new TracePrintStream((OutputStream)this.getBufferedOutputStream(), this.getThreadMap()));
                this.getTracePrintStream().printf("--> TraceLog opened!%n", new Object[0]);
                this.getTracePrintStream().printf("    Time     : %tc%n", new Date());
                this.getTracePrintStream().printf("    Bufsize  : %d%n", this.getBufferSize());
                this.getTracePrintStream().printf("    Autoflush: %b%n%n", this.isAutoflush());
                this.setOpened(true);
            } else {
                System.err.println("WARNING: Tracelog is opened already.");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.getTracePrintStream().println();
                this.getTracePrintStream().printf("--> TraceLog closing!%n", new Object[0]);
                this.getTracePrintStream().printf("    Time     : %tc%n", new Date());
                System.out.println(this.formatStreamErrorState() + " Closing ...");
                this.getTracePrintStream().close();
                this.getBufferedOutputStream().close();
                this.fileOutputStream.close();
                this.setOpened(false);
            } else {
                System.err.println("WARNING: Tracelog is closed already.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    protected void readConfiguration(XPath xpath, Node node) throws XPathExpressionException, AbstractTracer.Exception {
        super.readConfiguration(xpath, node);
        File logDir = new File(this.substitute((String)xpath.evaluate("./dns:LogDir/text()", node, XPathConstants.STRING)));
        if (!logDir.isDirectory()) {
            throw (AbstractTracer)this.new AbstractTracer.Exception("Invalid path to directory configured for tracer: " + super.getName());
        }
        this.logDirPath = logDir.toPath();
        try {
            this.byteLimit = Long.parseLong((String)xpath.evaluate("./dns:Limit/text()", node, XPathConstants.STRING));
        }
        catch (NumberFormatException ex) {
            System.err.println(super.getName() + ": Could not parse byte limit. File splitting is off.");
            this.byteLimit = -1L;
        }
        System.out.println("this.logDir = " + this.logDirPath);
        System.out.println("this.byteLimit = " + this.byteLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLimit() {
        Object object = this.getSyncObject();
        synchronized (object) {
            if (this.byteLimit != -1L && this.traceLogfile != null && this.traceLogfile.length() > this.byteLimit) {
                this.close();
                int pos = this.traceLogfile.getAbsolutePath().lastIndexOf(46);
                String splitFilename = this.traceLogfile.getAbsolutePath().substring(0, pos) + "." + ++this.counter + ".log";
                File splitFile = new File(splitFilename);
                if (splitFile.exists() && !splitFile.delete()) {
                    System.err.printf("WARNING: Couldn't delete old file: %s%n", splitFile.getName());
                }
                this.traceLogfile.renameTo(splitFile);
                this.open();
            }
        }
    }

    @Override
    public IndentablePrintStream out() {
        this.checkLimit();
        return super.out();
    }

    @Override
    public void logException(LogLevel logLevel, Throwable throwable, Class<?> clazz, String methodName) {
        super.logException(logLevel, throwable, clazz, methodName);
        this.checkLimit();
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Class<?> clazz, String methodName) {
        super.logMessage(logLevel, message, clazz, methodName);
        this.checkLimit();
    }
}

