/*
 * Decompiled with CFR 0.152.
 */
package de.cketti.codepoints;

import de.cketti.codepoints.CodePoints;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010\r\n\u0002\b\b\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"codePointAt", "", "", "index", "codePointBefore", "codePointCount", "beginIndex", "endIndex", "offsetByCodePoints", "codePointOffset", "kotlin-codepoints"})
@SourceDebugExtension(value={"SMAP\nCharSequenceExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharSequenceExtensions.kt\nde/cketti/codepoints/CharSequenceExtensionsKt\n+ 2 CodePoints.kt\nde/cketti/codepoints/CodePoints\n*L\n1#1,156:1\n35#2:157\n35#2:158\n*S KotlinDebug\n*F\n+ 1 CharSequenceExtensions.kt\nde/cketti/codepoints/CharSequenceExtensionsKt\n*L\n44#1:157\n72#1:158\n*E\n"})
public final class CharSequenceExtensionsKt {
    public static final int codePointAt(@NotNull CharSequence $this$codePointAt, int index) {
        char nextChar;
        Intrinsics.checkNotNullParameter((Object)$this$codePointAt, (String)"<this>");
        if (!(0 <= index ? index < $this$codePointAt.length() : false)) {
            throw new IndexOutOfBoundsException();
        }
        char firstChar = $this$codePointAt.charAt(index);
        if (Character.isHighSurrogate(firstChar) && index + 1 < $this$codePointAt.length() && Character.isLowSurrogate(nextChar = $this$codePointAt.charAt(index + 1))) {
            CodePoints this_$iv = CodePoints.INSTANCE;
            boolean $i$f$toCodePoint = false;
            return Character.toCodePoint(firstChar, nextChar);
        }
        return firstChar;
    }

    public static final int codePointBefore(@NotNull CharSequence $this$codePointBefore, int index) {
        char previousChar;
        Intrinsics.checkNotNullParameter((Object)$this$codePointBefore, (String)"<this>");
        int startIndex = index - 1;
        if (!(0 <= startIndex ? startIndex < $this$codePointBefore.length() : false)) {
            throw new IndexOutOfBoundsException();
        }
        char firstChar = $this$codePointBefore.charAt(startIndex);
        if (Character.isLowSurrogate(firstChar) && startIndex - 1 >= 0 && Character.isHighSurrogate(previousChar = $this$codePointBefore.charAt(startIndex - 1))) {
            CodePoints this_$iv = CodePoints.INSTANCE;
            boolean $i$f$toCodePoint = false;
            return Character.toCodePoint(previousChar, firstChar);
        }
        return firstChar;
    }

    public static final int codePointCount(@NotNull CharSequence $this$codePointCount, int beginIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointCount, (String)"<this>");
        if (beginIndex < 0 || endIndex > $this$codePointCount.length() || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        int index = beginIndex;
        int count = 0;
        do {
            char nextChar;
            char firstChar;
            if (Character.isHighSurrogate(firstChar = $this$codePointCount.charAt(index)) && ++index < endIndex && Character.isLowSurrogate(nextChar = $this$codePointCount.charAt(index))) {
                ++index;
            }
            ++count;
        } while (index < endIndex);
        return count;
    }

    public static final int offsetByCodePoints(@NotNull CharSequence $this$offsetByCodePoints, int index, int codePointOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetByCodePoints, (String)"<this>");
        if (!(0 <= index ? index <= $this$offsetByCodePoints.length() : false)) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int currentIndex = 0;
            currentIndex = index;
            for (int i = 0; i < codePointOffset; ++i) {
                char nextChar;
                int it = i;
                boolean bl = false;
                if (currentIndex > StringsKt.getLastIndex((CharSequence)$this$offsetByCodePoints)) {
                    throw new IndexOutOfBoundsException();
                }
                char firstChar = $this$offsetByCodePoints.charAt(currentIndex);
                if (!Character.isHighSurrogate(firstChar) || ++currentIndex > StringsKt.getLastIndex((CharSequence)$this$offsetByCodePoints) || !Character.isLowSurrogate(nextChar = $this$offsetByCodePoints.charAt(currentIndex))) continue;
                ++currentIndex;
            }
            return currentIndex;
        }
        int currentIndex = 0;
        currentIndex = index - 1;
        int n = -codePointOffset;
        for (int i = 0; i < n; ++i) {
            char previousChar;
            int it = i;
            boolean bl = false;
            if (currentIndex < 0) {
                throw new IndexOutOfBoundsException();
            }
            char firstChar = $this$offsetByCodePoints.charAt(currentIndex);
            if (!Character.isLowSurrogate(firstChar) || (currentIndex += -1) < 0 || !Character.isHighSurrogate(previousChar = $this$offsetByCodePoints.charAt(currentIndex))) continue;
            currentIndex += -1;
        }
        return currentIndex + 1;
    }
}

