/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Cart
 */
@JsonPropertyOrder({
  Cart.JSON_PROPERTY_API_ALIAS,
  Cart.JSON_PROPERTY_NAME,
  Cart.JSON_PROPERTY_TOKEN,
  Cart.JSON_PROPERTY_PRICE,
  Cart.JSON_PROPERTY_LINE_ITEMS,
  Cart.JSON_PROPERTY_ERRORS,
  Cart.JSON_PROPERTY_TRANSACTIONS,
  Cart.JSON_PROPERTY_MODIFIED,
  Cart.JSON_PROPERTY_CUSTOMER_COMMENT,
  Cart.JSON_PROPERTY_AFFILIATE_CODE,
  Cart.JSON_PROPERTY_CAMPAIGN_CODE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class Cart {
  public static final String JSON_PROPERTY_API_ALIAS = "apiAlias";
  private String apiAlias;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  public static final String JSON_PROPERTY_PRICE = "price";
  private CartAllOfPrice price;

  public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
  private List<LineItem> lineItems = new ArrayList<>();

  public static final String JSON_PROPERTY_ERRORS = "errors";
  private List<CartAllOfErrors> errors = new ArrayList<>();

  public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
  private List<CartAllOfTransactions> transactions = new ArrayList<>();

  public static final String JSON_PROPERTY_MODIFIED = "modified";
  private Boolean modified;

  public static final String JSON_PROPERTY_CUSTOMER_COMMENT = "customerComment";
  private String customerComment;

  public static final String JSON_PROPERTY_AFFILIATE_CODE = "affiliateCode";
  private String affiliateCode;

  public static final String JSON_PROPERTY_CAMPAIGN_CODE = "campaignCode";
  private String campaignCode;

  public Cart() {
  }

  public Cart apiAlias(String apiAlias) {
    
    this.apiAlias = apiAlias;
    return this;
  }

   /**
   * Alias which can be used to restrict response fields. For more information see [includes](https://shopware.stoplight.io/docs/store-api/docs/concepts/search-queries.md#includes-apialias).
   * @return apiAlias
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_API_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApiAlias() {
    return apiAlias;
  }


  @JsonProperty(JSON_PROPERTY_API_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApiAlias(String apiAlias) {
    this.apiAlias = apiAlias;
  }


  public Cart name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the cart - for example &#x60;guest-cart&#x60;
   * @return name
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public Cart token(String token) {
    
    this.token = token;
    return this;
  }

   /**
   * Context token identifying the cart and the user session
   * @return token
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(String token) {
    this.token = token;
  }


  public Cart price(CartAllOfPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CartAllOfPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(CartAllOfPrice price) {
    this.price = price;
  }


  public Cart lineItems(List<LineItem> lineItems) {
    
    this.lineItems = lineItems;
    return this;
  }

  public Cart addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * All items within the cart
   * @return lineItems
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LineItem> getLineItems() {
    return lineItems;
  }


  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public Cart errors(List<CartAllOfErrors> errors) {
    
    this.errors = errors;
    return this;
  }

  public Cart addErrorsItem(CartAllOfErrors errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * A list of all cart errors, such as insufficient stocks, invalid addresses or vouchers.
   * @return errors
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CartAllOfErrors> getErrors() {
    return errors;
  }


  @JsonProperty(JSON_PROPERTY_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrors(List<CartAllOfErrors> errors) {
    this.errors = errors;
  }


  public Cart transactions(List<CartAllOfTransactions> transactions) {
    
    this.transactions = transactions;
    return this;
  }

  public Cart addTransactionsItem(CartAllOfTransactions transactionsItem) {
    if (this.transactions == null) {
      this.transactions = new ArrayList<>();
    }
    this.transactions.add(transactionsItem);
    return this;
  }

   /**
   * A list of all payment transactions associated with the current cart.
   * @return transactions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CartAllOfTransactions> getTransactions() {
    return transactions;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactions(List<CartAllOfTransactions> transactions) {
    this.transactions = transactions;
  }


  public Cart modified(Boolean modified) {
    
    this.modified = modified;
    return this;
  }

   /**
   * Get modified
   * @return modified
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getModified() {
    return modified;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModified(Boolean modified) {
    this.modified = modified;
  }


  public Cart customerComment(String customerComment) {
    
    this.customerComment = customerComment;
    return this;
  }

   /**
   * A comment that can be added to the cart.
   * @return customerComment
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerComment() {
    return customerComment;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerComment(String customerComment) {
    this.customerComment = customerComment;
  }


  public Cart affiliateCode(String affiliateCode) {
    
    this.affiliateCode = affiliateCode;
    return this;
  }

   /**
   * An affiliate tracking code
   * @return affiliateCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateCode() {
    return affiliateCode;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateCode(String affiliateCode) {
    this.affiliateCode = affiliateCode;
  }


  public Cart campaignCode(String campaignCode) {
    
    this.campaignCode = campaignCode;
    return this;
  }

   /**
   * A campaign tracking code
   * @return campaignCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCampaignCode() {
    return campaignCode;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignCode(String campaignCode) {
    this.campaignCode = campaignCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Cart cart = (Cart) o;
    return Objects.equals(this.apiAlias, cart.apiAlias) &&
        Objects.equals(this.name, cart.name) &&
        Objects.equals(this.token, cart.token) &&
        Objects.equals(this.price, cart.price) &&
        Objects.equals(this.lineItems, cart.lineItems) &&
        Objects.equals(this.errors, cart.errors) &&
        Objects.equals(this.transactions, cart.transactions) &&
        Objects.equals(this.modified, cart.modified) &&
        Objects.equals(this.customerComment, cart.customerComment) &&
        Objects.equals(this.affiliateCode, cart.affiliateCode) &&
        Objects.equals(this.campaignCode, cart.campaignCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiAlias, name, token, price, lineItems, errors, transactions, modified, customerComment, affiliateCode, campaignCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Cart {\n");
    sb.append("    apiAlias: ").append(toIndentedString(apiAlias)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("    modified: ").append(toIndentedString(modified)).append("\n");
    sb.append("    customerComment: ").append(toIndentedString(customerComment)).append("\n");
    sb.append("    affiliateCode: ").append(toIndentedString(affiliateCode)).append("\n");
    sb.append("    campaignCode: ").append(toIndentedString(campaignCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

