/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.Objects;

/**
 * CartAllOfPrice
 */
@JsonPropertyOrder({
  CartAllOfPrice.JSON_PROPERTY_NET_PRICE,
  CartAllOfPrice.JSON_PROPERTY_TOTAL_PRICE,
  CartAllOfPrice.JSON_PROPERTY_POSITION_PRICE,
  CartAllOfPrice.JSON_PROPERTY_TAX_STATUS
})
@JsonTypeName("Cart_allOf_price")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class CartAllOfPrice {
  public static final String JSON_PROPERTY_NET_PRICE = "netPrice";
  private Float netPrice;

  public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
  private Float totalPrice;

  public static final String JSON_PROPERTY_POSITION_PRICE = "positionPrice";
  private Float positionPrice;

  public static final String JSON_PROPERTY_TAX_STATUS = "taxStatus";
  private String taxStatus;

  public CartAllOfPrice() {
  }

  public CartAllOfPrice netPrice(Float netPrice) {
    
    this.netPrice = netPrice;
    return this;
  }

   /**
   * Net price of the cart
   * @return netPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NET_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getNetPrice() {
    return netPrice;
  }


  @JsonProperty(JSON_PROPERTY_NET_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetPrice(Float netPrice) {
    this.netPrice = netPrice;
  }


  public CartAllOfPrice totalPrice(Float totalPrice) {
    
    this.totalPrice = totalPrice;
    return this;
  }

   /**
   * Total price of the cart, including shipping costs, discounts and taxes
   * @return totalPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalPrice() {
    return totalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPrice(Float totalPrice) {
    this.totalPrice = totalPrice;
  }


  public CartAllOfPrice positionPrice(Float positionPrice) {
    
    this.positionPrice = positionPrice;
    return this;
  }

   /**
   * Price for all line items in the cart
   * @return positionPrice
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITION_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPositionPrice() {
    return positionPrice;
  }


  @JsonProperty(JSON_PROPERTY_POSITION_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPositionPrice(Float positionPrice) {
    this.positionPrice = positionPrice;
  }


  public CartAllOfPrice taxStatus(String taxStatus) {
    
    this.taxStatus = taxStatus;
    return this;
  }

   /**
   * Tax calculation for the cart. One of &#x60;gross&#x60;, &#x60;net&#x60; or &#x60;tax-free&#x60;
   * @return taxStatus
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAX_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTaxStatus() {
    return taxStatus;
  }


  @JsonProperty(JSON_PROPERTY_TAX_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxStatus(String taxStatus) {
    this.taxStatus = taxStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CartAllOfPrice cartAllOfPrice = (CartAllOfPrice) o;
    return Objects.equals(this.netPrice, cartAllOfPrice.netPrice) &&
        Objects.equals(this.totalPrice, cartAllOfPrice.totalPrice) &&
        Objects.equals(this.positionPrice, cartAllOfPrice.positionPrice) &&
        Objects.equals(this.taxStatus, cartAllOfPrice.taxStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(netPrice, totalPrice, positionPrice, taxStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CartAllOfPrice {\n");
    sb.append("    netPrice: ").append(toIndentedString(netPrice)).append("\n");
    sb.append("    totalPrice: ").append(toIndentedString(totalPrice)).append("\n");
    sb.append("    positionPrice: ").append(toIndentedString(positionPrice)).append("\n");
    sb.append("    taxStatus: ").append(toIndentedString(taxStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

