/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.Objects;

/**
 * ChangeProfileRequest
 */
@JsonPropertyOrder({
  ChangeProfileRequest.JSON_PROPERTY_SALUTATION_ID,
  ChangeProfileRequest.JSON_PROPERTY_TITLE,
  ChangeProfileRequest.JSON_PROPERTY_FIRST_NAME,
  ChangeProfileRequest.JSON_PROPERTY_LAST_NAME,
  ChangeProfileRequest.JSON_PROPERTY_COMPANY,
  ChangeProfileRequest.JSON_PROPERTY_BIRTHDAY_DAY,
  ChangeProfileRequest.JSON_PROPERTY_BIRTHDAY_MONTH,
  ChangeProfileRequest.JSON_PROPERTY_BIRTHDAY_YEAR
})
@JsonTypeName("changeProfile_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class ChangeProfileRequest {
  public static final String JSON_PROPERTY_SALUTATION_ID = "salutationId";
  private String salutationId;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private String company;

  public static final String JSON_PROPERTY_BIRTHDAY_DAY = "birthdayDay";
  private Integer birthdayDay;

  public static final String JSON_PROPERTY_BIRTHDAY_MONTH = "birthdayMonth";
  private Integer birthdayMonth;

  public static final String JSON_PROPERTY_BIRTHDAY_YEAR = "birthdayYear";
  private Integer birthdayYear;

  public ChangeProfileRequest() {
  }

  public ChangeProfileRequest salutationId(String salutationId) {
    
    this.salutationId = salutationId;
    return this;
  }

   /**
   * Id of the salutation for the customer account. Fetch options using &#x60;salutation&#x60; endpoint.
   * @return salutationId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalutationId() {
    return salutationId;
  }


  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalutationId(String salutationId) {
    this.salutationId = salutationId;
  }


  public ChangeProfileRequest title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * (Academic) title of the customer
   * @return title
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public ChangeProfileRequest firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * Customer first name. Value will be reused for shipping and billing address if not provided explicitly.
   * @return firstName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public ChangeProfileRequest lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Customer last name. Value will be reused for shipping and billing address if not provided explicitly.
   * @return lastName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public ChangeProfileRequest company(String company) {
    
    this.company = company;
    return this;
  }

   /**
   * Company of the customer. Only required when &#x60;accountType&#x60; is &#x60;business&#x60;.
   * @return company
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompany() {
    return company;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompany(String company) {
    this.company = company;
  }


  public ChangeProfileRequest birthdayDay(Integer birthdayDay) {
    
    this.birthdayDay = birthdayDay;
    return this;
  }

   /**
   * Birthday day
   * @return birthdayDay
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBirthdayDay() {
    return birthdayDay;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthdayDay(Integer birthdayDay) {
    this.birthdayDay = birthdayDay;
  }


  public ChangeProfileRequest birthdayMonth(Integer birthdayMonth) {
    
    this.birthdayMonth = birthdayMonth;
    return this;
  }

   /**
   * Birthday month
   * @return birthdayMonth
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBirthdayMonth() {
    return birthdayMonth;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthdayMonth(Integer birthdayMonth) {
    this.birthdayMonth = birthdayMonth;
  }


  public ChangeProfileRequest birthdayYear(Integer birthdayYear) {
    
    this.birthdayYear = birthdayYear;
    return this;
  }

   /**
   * Birthday year
   * @return birthdayYear
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBirthdayYear() {
    return birthdayYear;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthdayYear(Integer birthdayYear) {
    this.birthdayYear = birthdayYear;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChangeProfileRequest changeProfileRequest = (ChangeProfileRequest) o;
    return Objects.equals(this.salutationId, changeProfileRequest.salutationId) &&
        Objects.equals(this.title, changeProfileRequest.title) &&
        Objects.equals(this.firstName, changeProfileRequest.firstName) &&
        Objects.equals(this.lastName, changeProfileRequest.lastName) &&
        Objects.equals(this.company, changeProfileRequest.company) &&
        Objects.equals(this.birthdayDay, changeProfileRequest.birthdayDay) &&
        Objects.equals(this.birthdayMonth, changeProfileRequest.birthdayMonth) &&
        Objects.equals(this.birthdayYear, changeProfileRequest.birthdayYear);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salutationId, title, firstName, lastName, company, birthdayDay, birthdayMonth, birthdayYear);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChangeProfileRequest {\n");
    sb.append("    salutationId: ").append(toIndentedString(salutationId)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    birthdayDay: ").append(toIndentedString(birthdayDay)).append("\n");
    sb.append("    birthdayMonth: ").append(toIndentedString(birthdayMonth)).append("\n");
    sb.append("    birthdayYear: ").append(toIndentedString(birthdayYear)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

