/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  Country.JSON_PROPERTY_ID,
  Country.JSON_PROPERTY_NAME,
  Country.JSON_PROPERTY_ISO,
  Country.JSON_PROPERTY_POSITION,
  Country.JSON_PROPERTY_ACTIVE,
  Country.JSON_PROPERTY_SHIPPING_AVAILABLE,
  Country.JSON_PROPERTY_ISO3,
  Country.JSON_PROPERTY_DISPLAY_STATE_IN_REGISTRATION,
  Country.JSON_PROPERTY_FORCE_STATE_IN_REGISTRATION,
  Country.JSON_PROPERTY_CHECK_VAT_ID_PATTERN,
  Country.JSON_PROPERTY_VAT_ID_REQUIRED,
  Country.JSON_PROPERTY_VAT_ID_PATTERN,
  Country.JSON_PROPERTY_CUSTOM_FIELDS,
  Country.JSON_PROPERTY_CUSTOMER_TAX,
  Country.JSON_PROPERTY_COMPANY_TAX,
  Country.JSON_PROPERTY_POSTAL_CODE_REQUIRED,
  Country.JSON_PROPERTY_CHECK_POSTAL_CODE_PATTERN,
  Country.JSON_PROPERTY_CHECK_ADVANCED_POSTAL_CODE_PATTERN,
  Country.JSON_PROPERTY_ADVANCED_POSTAL_CODE_PATTERN,
  Country.JSON_PROPERTY_ADDRESS_FORMAT,
  Country.JSON_PROPERTY_DEFAULT_POSTAL_CODE_PATTERN,
  Country.JSON_PROPERTY_CREATED_AT,
  Country.JSON_PROPERTY_UPDATED_AT,
  Country.JSON_PROPERTY_TRANSLATED,
  Country.JSON_PROPERTY_STATES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class Country {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ISO = "iso";
  private String iso;

  public static final String JSON_PROPERTY_POSITION = "position";
  private Long position;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_SHIPPING_AVAILABLE = "shippingAvailable";
  private Boolean shippingAvailable;

  public static final String JSON_PROPERTY_ISO3 = "iso3";
  private String iso3;

  public static final String JSON_PROPERTY_DISPLAY_STATE_IN_REGISTRATION = "displayStateInRegistration";
  private Boolean displayStateInRegistration;

  public static final String JSON_PROPERTY_FORCE_STATE_IN_REGISTRATION = "forceStateInRegistration";
  private Boolean forceStateInRegistration;

  public static final String JSON_PROPERTY_CHECK_VAT_ID_PATTERN = "checkVatIdPattern";
  private Boolean checkVatIdPattern;

  public static final String JSON_PROPERTY_VAT_ID_REQUIRED = "vatIdRequired";
  private Boolean vatIdRequired;

  public static final String JSON_PROPERTY_VAT_ID_PATTERN = "vatIdPattern";
  private String vatIdPattern;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_CUSTOMER_TAX = "customerTax";
  private CountryJsonApiAllOfCustomerTax customerTax;

  public static final String JSON_PROPERTY_COMPANY_TAX = "companyTax";
  private CountryJsonApiAllOfCustomerTax companyTax;

  public static final String JSON_PROPERTY_POSTAL_CODE_REQUIRED = "postalCodeRequired";
  private Boolean postalCodeRequired;

  public static final String JSON_PROPERTY_CHECK_POSTAL_CODE_PATTERN = "checkPostalCodePattern";
  private Boolean checkPostalCodePattern;

  public static final String JSON_PROPERTY_CHECK_ADVANCED_POSTAL_CODE_PATTERN = "checkAdvancedPostalCodePattern";
  private Boolean checkAdvancedPostalCodePattern;

  public static final String JSON_PROPERTY_ADVANCED_POSTAL_CODE_PATTERN = "advancedPostalCodePattern";
  private String advancedPostalCodePattern;

  public static final String JSON_PROPERTY_ADDRESS_FORMAT = "addressFormat";
  private Object addressFormat;

  public static final String JSON_PROPERTY_DEFAULT_POSTAL_CODE_PATTERN = "defaultPostalCodePattern";
  private String defaultPostalCodePattern;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_TRANSLATED = "translated";
  private Object translated;

  public static final String JSON_PROPERTY_STATES = "states";
  private List<CountryState> states = new ArrayList<>();

  public Country() {
  }

  @JsonCreator
  public Country(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public Country id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Country name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Country iso(String iso) {
    
    this.iso = iso;
    return this;
  }

   /**
   * Get iso
   * @return iso
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ISO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso() {
    return iso;
  }


  @JsonProperty(JSON_PROPERTY_ISO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso(String iso) {
    this.iso = iso;
  }


  public Country position(Long position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(Long position) {
    this.position = position;
  }


  public Country active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public Country shippingAvailable(Boolean shippingAvailable) {
    
    this.shippingAvailable = shippingAvailable;
    return this;
  }

   /**
   * Get shippingAvailable
   * @return shippingAvailable
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHIPPING_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShippingAvailable() {
    return shippingAvailable;
  }


  @JsonProperty(JSON_PROPERTY_SHIPPING_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShippingAvailable(Boolean shippingAvailable) {
    this.shippingAvailable = shippingAvailable;
  }


  public Country iso3(String iso3) {
    
    this.iso3 = iso3;
    return this;
  }

   /**
   * Get iso3
   * @return iso3
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ISO3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3() {
    return iso3;
  }


  @JsonProperty(JSON_PROPERTY_ISO3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3(String iso3) {
    this.iso3 = iso3;
  }


  public Country displayStateInRegistration(Boolean displayStateInRegistration) {
    
    this.displayStateInRegistration = displayStateInRegistration;
    return this;
  }

   /**
   * Get displayStateInRegistration
   * @return displayStateInRegistration
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPLAY_STATE_IN_REGISTRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisplayStateInRegistration() {
    return displayStateInRegistration;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_STATE_IN_REGISTRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayStateInRegistration(Boolean displayStateInRegistration) {
    this.displayStateInRegistration = displayStateInRegistration;
  }


  public Country forceStateInRegistration(Boolean forceStateInRegistration) {
    
    this.forceStateInRegistration = forceStateInRegistration;
    return this;
  }

   /**
   * Get forceStateInRegistration
   * @return forceStateInRegistration
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_STATE_IN_REGISTRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceStateInRegistration() {
    return forceStateInRegistration;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_STATE_IN_REGISTRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceStateInRegistration(Boolean forceStateInRegistration) {
    this.forceStateInRegistration = forceStateInRegistration;
  }


  public Country checkVatIdPattern(Boolean checkVatIdPattern) {
    
    this.checkVatIdPattern = checkVatIdPattern;
    return this;
  }

   /**
   * Get checkVatIdPattern
   * @return checkVatIdPattern
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CHECK_VAT_ID_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCheckVatIdPattern() {
    return checkVatIdPattern;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_VAT_ID_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckVatIdPattern(Boolean checkVatIdPattern) {
    this.checkVatIdPattern = checkVatIdPattern;
  }


  public Country vatIdRequired(Boolean vatIdRequired) {
    
    this.vatIdRequired = vatIdRequired;
    return this;
  }

   /**
   * Get vatIdRequired
   * @return vatIdRequired
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VAT_ID_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVatIdRequired() {
    return vatIdRequired;
  }


  @JsonProperty(JSON_PROPERTY_VAT_ID_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVatIdRequired(Boolean vatIdRequired) {
    this.vatIdRequired = vatIdRequired;
  }


  public Country vatIdPattern(String vatIdPattern) {
    
    this.vatIdPattern = vatIdPattern;
    return this;
  }

   /**
   * Get vatIdPattern
   * @return vatIdPattern
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VAT_ID_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVatIdPattern() {
    return vatIdPattern;
  }


  @JsonProperty(JSON_PROPERTY_VAT_ID_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVatIdPattern(String vatIdPattern) {
    this.vatIdPattern = vatIdPattern;
  }


  public Country customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


  public Country customerTax(CountryJsonApiAllOfCustomerTax customerTax) {
    
    this.customerTax = customerTax;
    return this;
  }

   /**
   * Get customerTax
   * @return customerTax
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CountryJsonApiAllOfCustomerTax getCustomerTax() {
    return customerTax;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerTax(CountryJsonApiAllOfCustomerTax customerTax) {
    this.customerTax = customerTax;
  }


  public Country companyTax(CountryJsonApiAllOfCustomerTax companyTax) {
    
    this.companyTax = companyTax;
    return this;
  }

   /**
   * Get companyTax
   * @return companyTax
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANY_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CountryJsonApiAllOfCustomerTax getCompanyTax() {
    return companyTax;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyTax(CountryJsonApiAllOfCustomerTax companyTax) {
    this.companyTax = companyTax;
  }


  public Country postalCodeRequired(Boolean postalCodeRequired) {
    
    this.postalCodeRequired = postalCodeRequired;
    return this;
  }

   /**
   * Get postalCodeRequired
   * @return postalCodeRequired
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPostalCodeRequired() {
    return postalCodeRequired;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCodeRequired(Boolean postalCodeRequired) {
    this.postalCodeRequired = postalCodeRequired;
  }


  public Country checkPostalCodePattern(Boolean checkPostalCodePattern) {
    
    this.checkPostalCodePattern = checkPostalCodePattern;
    return this;
  }

   /**
   * Get checkPostalCodePattern
   * @return checkPostalCodePattern
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CHECK_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCheckPostalCodePattern() {
    return checkPostalCodePattern;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckPostalCodePattern(Boolean checkPostalCodePattern) {
    this.checkPostalCodePattern = checkPostalCodePattern;
  }


  public Country checkAdvancedPostalCodePattern(Boolean checkAdvancedPostalCodePattern) {
    
    this.checkAdvancedPostalCodePattern = checkAdvancedPostalCodePattern;
    return this;
  }

   /**
   * Get checkAdvancedPostalCodePattern
   * @return checkAdvancedPostalCodePattern
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CHECK_ADVANCED_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCheckAdvancedPostalCodePattern() {
    return checkAdvancedPostalCodePattern;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_ADVANCED_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckAdvancedPostalCodePattern(Boolean checkAdvancedPostalCodePattern) {
    this.checkAdvancedPostalCodePattern = checkAdvancedPostalCodePattern;
  }


  public Country advancedPostalCodePattern(String advancedPostalCodePattern) {
    
    this.advancedPostalCodePattern = advancedPostalCodePattern;
    return this;
  }

   /**
   * Get advancedPostalCodePattern
   * @return advancedPostalCodePattern
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADVANCED_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdvancedPostalCodePattern() {
    return advancedPostalCodePattern;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCED_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvancedPostalCodePattern(String advancedPostalCodePattern) {
    this.advancedPostalCodePattern = advancedPostalCodePattern;
  }


  public Country addressFormat(Object addressFormat) {
    
    this.addressFormat = addressFormat;
    return this;
  }

   /**
   * Get addressFormat
   * @return addressFormat
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ADDRESS_FORMAT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Object getAddressFormat() {
    return addressFormat;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS_FORMAT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddressFormat(Object addressFormat) {
    this.addressFormat = addressFormat;
  }


  public Country defaultPostalCodePattern(String defaultPostalCodePattern) {
    
    this.defaultPostalCodePattern = defaultPostalCodePattern;
    return this;
  }

   /**
   * Get defaultPostalCodePattern
   * @return defaultPostalCodePattern
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultPostalCodePattern() {
    return defaultPostalCodePattern;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_POSTAL_CODE_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultPostalCodePattern(String defaultPostalCodePattern) {
    this.defaultPostalCodePattern = defaultPostalCodePattern;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public Country translated(Object translated) {
    
    this.translated = translated;
    return this;
  }

   /**
   * Get translated
   * @return translated
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTranslated() {
    return translated;
  }


  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranslated(Object translated) {
    this.translated = translated;
  }


  public Country states(List<CountryState> states) {
    
    this.states = states;
    return this;
  }

  public Country addStatesItem(CountryState statesItem) {
    if (this.states == null) {
      this.states = new ArrayList<>();
    }
    this.states.add(statesItem);
    return this;
  }

   /**
   * Get states
   * @return states
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CountryState> getStates() {
    return states;
  }


  @JsonProperty(JSON_PROPERTY_STATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStates(List<CountryState> states) {
    this.states = states;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Country country = (Country) o;
    return Objects.equals(this.id, country.id) &&
        Objects.equals(this.name, country.name) &&
        Objects.equals(this.iso, country.iso) &&
        Objects.equals(this.position, country.position) &&
        Objects.equals(this.active, country.active) &&
        Objects.equals(this.shippingAvailable, country.shippingAvailable) &&
        Objects.equals(this.iso3, country.iso3) &&
        Objects.equals(this.displayStateInRegistration, country.displayStateInRegistration) &&
        Objects.equals(this.forceStateInRegistration, country.forceStateInRegistration) &&
        Objects.equals(this.checkVatIdPattern, country.checkVatIdPattern) &&
        Objects.equals(this.vatIdRequired, country.vatIdRequired) &&
        Objects.equals(this.vatIdPattern, country.vatIdPattern) &&
        Objects.equals(this.customFields, country.customFields) &&
        Objects.equals(this.customerTax, country.customerTax) &&
        Objects.equals(this.companyTax, country.companyTax) &&
        Objects.equals(this.postalCodeRequired, country.postalCodeRequired) &&
        Objects.equals(this.checkPostalCodePattern, country.checkPostalCodePattern) &&
        Objects.equals(this.checkAdvancedPostalCodePattern, country.checkAdvancedPostalCodePattern) &&
        Objects.equals(this.advancedPostalCodePattern, country.advancedPostalCodePattern) &&
        Objects.equals(this.addressFormat, country.addressFormat) &&
        Objects.equals(this.defaultPostalCodePattern, country.defaultPostalCodePattern) &&
        Objects.equals(this.createdAt, country.createdAt) &&
        Objects.equals(this.updatedAt, country.updatedAt) &&
        Objects.equals(this.translated, country.translated) &&
        Objects.equals(this.states, country.states);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, iso, position, active, shippingAvailable, iso3, displayStateInRegistration, forceStateInRegistration, checkVatIdPattern, vatIdRequired, vatIdPattern, customFields, customerTax, companyTax, postalCodeRequired, checkPostalCodePattern, checkAdvancedPostalCodePattern, advancedPostalCodePattern, addressFormat, defaultPostalCodePattern, createdAt, updatedAt, translated, states);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Country {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    iso: ").append(toIndentedString(iso)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    shippingAvailable: ").append(toIndentedString(shippingAvailable)).append("\n");
    sb.append("    iso3: ").append(toIndentedString(iso3)).append("\n");
    sb.append("    displayStateInRegistration: ").append(toIndentedString(displayStateInRegistration)).append("\n");
    sb.append("    forceStateInRegistration: ").append(toIndentedString(forceStateInRegistration)).append("\n");
    sb.append("    checkVatIdPattern: ").append(toIndentedString(checkVatIdPattern)).append("\n");
    sb.append("    vatIdRequired: ").append(toIndentedString(vatIdRequired)).append("\n");
    sb.append("    vatIdPattern: ").append(toIndentedString(vatIdPattern)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    customerTax: ").append(toIndentedString(customerTax)).append("\n");
    sb.append("    companyTax: ").append(toIndentedString(companyTax)).append("\n");
    sb.append("    postalCodeRequired: ").append(toIndentedString(postalCodeRequired)).append("\n");
    sb.append("    checkPostalCodePattern: ").append(toIndentedString(checkPostalCodePattern)).append("\n");
    sb.append("    checkAdvancedPostalCodePattern: ").append(toIndentedString(checkAdvancedPostalCodePattern)).append("\n");
    sb.append("    advancedPostalCodePattern: ").append(toIndentedString(advancedPostalCodePattern)).append("\n");
    sb.append("    addressFormat: ").append(toIndentedString(addressFormat)).append("\n");
    sb.append("    defaultPostalCodePattern: ").append(toIndentedString(defaultPostalCodePattern)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    translated: ").append(toIndentedString(translated)).append("\n");
    sb.append("    states: ").append(toIndentedString(states)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

