/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openapitools.jackson.nullable.JsonNullable;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  CountryStateJsonApi.JSON_PROPERTY_TYPE,
  CountryStateJsonApi.JSON_PROPERTY_ID,
  CountryStateJsonApi.JSON_PROPERTY_ATTRIBUTES,
  CountryStateJsonApi.JSON_PROPERTY_RELATIONSHIPS,
  CountryStateJsonApi.JSON_PROPERTY_LINKS,
  CountryStateJsonApi.JSON_PROPERTY_META,
  CountryStateJsonApi.JSON_PROPERTY_COUNTRY_ID,
  CountryStateJsonApi.JSON_PROPERTY_SHORT_CODE,
  CountryStateJsonApi.JSON_PROPERTY_NAME,
  CountryStateJsonApi.JSON_PROPERTY_POSITION,
  CountryStateJsonApi.JSON_PROPERTY_ACTIVE,
  CountryStateJsonApi.JSON_PROPERTY_CUSTOM_FIELDS,
  CountryStateJsonApi.JSON_PROPERTY_CREATED_AT,
  CountryStateJsonApi.JSON_PROPERTY_UPDATED_AT,
  CountryStateJsonApi.JSON_PROPERTY_TRANSLATED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class CountryStateJsonApi {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private Map<String, Object> attributes = new HashMap<>();

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private JsonNullable<Relationships> relationships = JsonNullable.<Relationships>undefined();

  public static final String JSON_PROPERTY_LINKS = "links";
  private Map<String, Link> links = new HashMap<>();

  public static final String JSON_PROPERTY_META = "meta";
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_COUNTRY_ID = "countryId";
  private String countryId;

  public static final String JSON_PROPERTY_SHORT_CODE = "shortCode";
  private String shortCode;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_POSITION = "position";
  private Long position;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_TRANSLATED = "translated";
  private Object translated;

  public CountryStateJsonApi() {
  }

  @JsonCreator
  public CountryStateJsonApi(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public CountryStateJsonApi type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public CountryStateJsonApi id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public CountryStateJsonApi attributes(Map<String, Object> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public CountryStateJsonApi putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Members of the attributes object (\&quot;attributes\&quot;) represent information about the resource object in which it&#39;s defined.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }


  public CountryStateJsonApi relationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
    
    return this;
  }

   /**
   * Get relationships
   * @return relationships
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public Relationships getRelationships() {
        return relationships.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Relationships> getRelationships_JsonNullable() {
    return relationships;
  }
  
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
    this.relationships = relationships;
  }

  public void setRelationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
  }


  public CountryStateJsonApi links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public CountryStateJsonApi putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public CountryStateJsonApi meta(Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public CountryStateJsonApi putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

   /**
   * Non-standard meta-information that can not be represented as an attribute or relationship.
   * @return meta
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(Map<String, Object> meta) {
    this.meta = meta;
  }


  public CountryStateJsonApi countryId(String countryId) {
    
    this.countryId = countryId;
    return this;
  }

   /**
   * Get countryId
   * @return countryId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_COUNTRY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryId() {
    return countryId;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryId(String countryId) {
    this.countryId = countryId;
  }


  public CountryStateJsonApi shortCode(String shortCode) {
    
    this.shortCode = shortCode;
    return this;
  }

   /**
   * Get shortCode
   * @return shortCode
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SHORT_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getShortCode() {
    return shortCode;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShortCode(String shortCode) {
    this.shortCode = shortCode;
  }


  public CountryStateJsonApi name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CountryStateJsonApi position(Long position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(Long position) {
    this.position = position;
  }


  public CountryStateJsonApi active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public CountryStateJsonApi customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public CountryStateJsonApi translated(Object translated) {
    
    this.translated = translated;
    return this;
  }

   /**
   * Get translated
   * @return translated
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTranslated() {
    return translated;
  }


  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranslated(Object translated) {
    this.translated = translated;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CountryStateJsonApi countryStateJsonApi = (CountryStateJsonApi) o;
    return Objects.equals(this.type, countryStateJsonApi.type) &&
        Objects.equals(this.id, countryStateJsonApi.id) &&
        Objects.equals(this.attributes, countryStateJsonApi.attributes) &&
        equalsNullable(this.relationships, countryStateJsonApi.relationships) &&
        Objects.equals(this.links, countryStateJsonApi.links) &&
        Objects.equals(this.meta, countryStateJsonApi.meta) &&
        Objects.equals(this.countryId, countryStateJsonApi.countryId) &&
        Objects.equals(this.shortCode, countryStateJsonApi.shortCode) &&
        Objects.equals(this.name, countryStateJsonApi.name) &&
        Objects.equals(this.position, countryStateJsonApi.position) &&
        Objects.equals(this.active, countryStateJsonApi.active) &&
        Objects.equals(this.customFields, countryStateJsonApi.customFields) &&
        Objects.equals(this.createdAt, countryStateJsonApi.createdAt) &&
        Objects.equals(this.updatedAt, countryStateJsonApi.updatedAt) &&
        Objects.equals(this.translated, countryStateJsonApi.translated);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, attributes, hashCodeNullable(relationships), links, meta, countryId, shortCode, name, position, active, customFields, createdAt, updatedAt, translated);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CountryStateJsonApi {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    countryId: ").append(toIndentedString(countryId)).append("\n");
    sb.append("    shortCode: ").append(toIndentedString(shortCode)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    translated: ").append(toIndentedString(translated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

