/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.Objects;

/**
 * CreateOrderRequest
 */
@JsonPropertyOrder({
  CreateOrderRequest.JSON_PROPERTY_CUSTOMER_COMMENT,
  CreateOrderRequest.JSON_PROPERTY_AFFILIATE_CODE,
  CreateOrderRequest.JSON_PROPERTY_CAMPAIGN_CODE
})
@JsonTypeName("createOrder_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class CreateOrderRequest {
  public static final String JSON_PROPERTY_CUSTOMER_COMMENT = "customerComment";
  private String customerComment;

  public static final String JSON_PROPERTY_AFFILIATE_CODE = "affiliateCode";
  private String affiliateCode;

  public static final String JSON_PROPERTY_CAMPAIGN_CODE = "campaignCode";
  private String campaignCode;

  public CreateOrderRequest() {
  }

  public CreateOrderRequest customerComment(String customerComment) {
    
    this.customerComment = customerComment;
    return this;
  }

   /**
   * Adds a comment from the customer to the order.
   * @return customerComment
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerComment() {
    return customerComment;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerComment(String customerComment) {
    this.customerComment = customerComment;
  }


  public CreateOrderRequest affiliateCode(String affiliateCode) {
    
    this.affiliateCode = affiliateCode;
    return this;
  }

   /**
   * The affiliate code can be used to track which referrer the customer came through. An example could be &#x60;Price-comparison-company-XY&#x60;.
   * @return affiliateCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateCode() {
    return affiliateCode;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateCode(String affiliateCode) {
    this.affiliateCode = affiliateCode;
  }


  public CreateOrderRequest campaignCode(String campaignCode) {
    
    this.campaignCode = campaignCode;
    return this;
  }

   /**
   * The campaign code is used to track which action the customer came from. An example could be &#x60;Summer-Deals&#x60;
   * @return campaignCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCampaignCode() {
    return campaignCode;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignCode(String campaignCode) {
    this.campaignCode = campaignCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateOrderRequest createOrderRequest = (CreateOrderRequest) o;
    return Objects.equals(this.customerComment, createOrderRequest.customerComment) &&
        Objects.equals(this.affiliateCode, createOrderRequest.affiliateCode) &&
        Objects.equals(this.campaignCode, createOrderRequest.campaignCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerComment, affiliateCode, campaignCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderRequest {\n");
    sb.append("    customerComment: ").append(toIndentedString(customerComment)).append("\n");
    sb.append("    affiliateCode: ").append(toIndentedString(affiliateCode)).append("\n");
    sb.append("    campaignCode: ").append(toIndentedString(campaignCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

