/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openapitools.jackson.nullable.JsonNullable;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  CurrencyJsonApi.JSON_PROPERTY_TYPE,
  CurrencyJsonApi.JSON_PROPERTY_ID,
  CurrencyJsonApi.JSON_PROPERTY_ATTRIBUTES,
  CurrencyJsonApi.JSON_PROPERTY_RELATIONSHIPS,
  CurrencyJsonApi.JSON_PROPERTY_LINKS,
  CurrencyJsonApi.JSON_PROPERTY_META,
  CurrencyJsonApi.JSON_PROPERTY_FACTOR,
  CurrencyJsonApi.JSON_PROPERTY_SYMBOL,
  CurrencyJsonApi.JSON_PROPERTY_ISO_CODE,
  CurrencyJsonApi.JSON_PROPERTY_SHORT_NAME,
  CurrencyJsonApi.JSON_PROPERTY_NAME,
  CurrencyJsonApi.JSON_PROPERTY_POSITION,
  CurrencyJsonApi.JSON_PROPERTY_IS_SYSTEM_DEFAULT,
  CurrencyJsonApi.JSON_PROPERTY_TAX_FREE_FROM,
  CurrencyJsonApi.JSON_PROPERTY_CUSTOM_FIELDS,
  CurrencyJsonApi.JSON_PROPERTY_ITEM_ROUNDING,
  CurrencyJsonApi.JSON_PROPERTY_TOTAL_ROUNDING,
  CurrencyJsonApi.JSON_PROPERTY_CREATED_AT,
  CurrencyJsonApi.JSON_PROPERTY_UPDATED_AT,
  CurrencyJsonApi.JSON_PROPERTY_TRANSLATED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class CurrencyJsonApi {
  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private Map<String, Object> attributes = new HashMap<>();

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private JsonNullable<Relationships> relationships = JsonNullable.<Relationships>undefined();

  public static final String JSON_PROPERTY_LINKS = "links";
  private Map<String, Link> links = new HashMap<>();

  public static final String JSON_PROPERTY_META = "meta";
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_FACTOR = "factor";
  private Float factor;

  public static final String JSON_PROPERTY_SYMBOL = "symbol";
  private String symbol;

  public static final String JSON_PROPERTY_ISO_CODE = "isoCode";
  private String isoCode;

  public static final String JSON_PROPERTY_SHORT_NAME = "shortName";
  private String shortName;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_POSITION = "position";
  private Long position;

  public static final String JSON_PROPERTY_IS_SYSTEM_DEFAULT = "isSystemDefault";
  private Boolean isSystemDefault;

  public static final String JSON_PROPERTY_TAX_FREE_FROM = "taxFreeFrom";
  private Float taxFreeFrom;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_ITEM_ROUNDING = "itemRounding";
  private CurrencyJsonApiAllOfItemRounding itemRounding;

  public static final String JSON_PROPERTY_TOTAL_ROUNDING = "totalRounding";
  private CurrencyJsonApiAllOfItemRounding totalRounding;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_TRANSLATED = "translated";
  private Object translated;

  public CurrencyJsonApi() {
  }

  @JsonCreator
  public CurrencyJsonApi(
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public CurrencyJsonApi type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public CurrencyJsonApi id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public CurrencyJsonApi attributes(Map<String, Object> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public CurrencyJsonApi putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

   /**
   * Members of the attributes object (\&quot;attributes\&quot;) represent information about the resource object in which it&#39;s defined.
   * @return attributes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }


  public CurrencyJsonApi relationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
    
    return this;
  }

   /**
   * Get relationships
   * @return relationships
  **/
  @jakarta.annotation.Nullable
  @JsonIgnore

  public Relationships getRelationships() {
        return relationships.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Relationships> getRelationships_JsonNullable() {
    return relationships;
  }
  
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  public void setRelationships_JsonNullable(JsonNullable<Relationships> relationships) {
    this.relationships = relationships;
  }

  public void setRelationships(Relationships relationships) {
    this.relationships = JsonNullable.<Relationships>of(relationships);
  }


  public CurrencyJsonApi links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public CurrencyJsonApi putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public CurrencyJsonApi meta(Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public CurrencyJsonApi putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

   /**
   * Non-standard meta-information that can not be represented as an attribute or relationship.
   * @return meta
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(Map<String, Object> meta) {
    this.meta = meta;
  }


  public CurrencyJsonApi factor(Float factor) {
    
    this.factor = factor;
    return this;
  }

   /**
   * Get factor
   * @return factor
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FACTOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getFactor() {
    return factor;
  }


  @JsonProperty(JSON_PROPERTY_FACTOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFactor(Float factor) {
    this.factor = factor;
  }


  public CurrencyJsonApi symbol(String symbol) {
    
    this.symbol = symbol;
    return this;
  }

   /**
   * Get symbol
   * @return symbol
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSymbol() {
    return symbol;
  }


  @JsonProperty(JSON_PROPERTY_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public CurrencyJsonApi isoCode(String isoCode) {
    
    this.isoCode = isoCode;
    return this;
  }

   /**
   * Get isoCode
   * @return isoCode
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIsoCode() {
    return isoCode;
  }


  @JsonProperty(JSON_PROPERTY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIsoCode(String isoCode) {
    this.isoCode = isoCode;
  }


  public CurrencyJsonApi shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

   /**
   * Get shortName
   * @return shortName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SHORT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getShortName() {
    return shortName;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShortName(String shortName) {
    this.shortName = shortName;
  }


  public CurrencyJsonApi name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CurrencyJsonApi position(Long position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(Long position) {
    this.position = position;
  }


  public CurrencyJsonApi isSystemDefault(Boolean isSystemDefault) {
    
    this.isSystemDefault = isSystemDefault;
    return this;
  }

   /**
   * Runtime field, cannot be used as part of the criteria.
   * @return isSystemDefault
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_SYSTEM_DEFAULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsSystemDefault() {
    return isSystemDefault;
  }


  @JsonProperty(JSON_PROPERTY_IS_SYSTEM_DEFAULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsSystemDefault(Boolean isSystemDefault) {
    this.isSystemDefault = isSystemDefault;
  }


  public CurrencyJsonApi taxFreeFrom(Float taxFreeFrom) {
    
    this.taxFreeFrom = taxFreeFrom;
    return this;
  }

   /**
   * Get taxFreeFrom
   * @return taxFreeFrom
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAX_FREE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTaxFreeFrom() {
    return taxFreeFrom;
  }


  @JsonProperty(JSON_PROPERTY_TAX_FREE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxFreeFrom(Float taxFreeFrom) {
    this.taxFreeFrom = taxFreeFrom;
  }


  public CurrencyJsonApi customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


  public CurrencyJsonApi itemRounding(CurrencyJsonApiAllOfItemRounding itemRounding) {
    
    this.itemRounding = itemRounding;
    return this;
  }

   /**
   * Get itemRounding
   * @return itemRounding
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ITEM_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CurrencyJsonApiAllOfItemRounding getItemRounding() {
    return itemRounding;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemRounding(CurrencyJsonApiAllOfItemRounding itemRounding) {
    this.itemRounding = itemRounding;
  }


  public CurrencyJsonApi totalRounding(CurrencyJsonApiAllOfItemRounding totalRounding) {
    
    this.totalRounding = totalRounding;
    return this;
  }

   /**
   * Get totalRounding
   * @return totalRounding
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TOTAL_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CurrencyJsonApiAllOfItemRounding getTotalRounding() {
    return totalRounding;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalRounding(CurrencyJsonApiAllOfItemRounding totalRounding) {
    this.totalRounding = totalRounding;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public CurrencyJsonApi translated(Object translated) {
    
    this.translated = translated;
    return this;
  }

   /**
   * Get translated
   * @return translated
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTranslated() {
    return translated;
  }


  @JsonProperty(JSON_PROPERTY_TRANSLATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranslated(Object translated) {
    this.translated = translated;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CurrencyJsonApi currencyJsonApi = (CurrencyJsonApi) o;
    return Objects.equals(this.type, currencyJsonApi.type) &&
        Objects.equals(this.id, currencyJsonApi.id) &&
        Objects.equals(this.attributes, currencyJsonApi.attributes) &&
        equalsNullable(this.relationships, currencyJsonApi.relationships) &&
        Objects.equals(this.links, currencyJsonApi.links) &&
        Objects.equals(this.meta, currencyJsonApi.meta) &&
        Objects.equals(this.factor, currencyJsonApi.factor) &&
        Objects.equals(this.symbol, currencyJsonApi.symbol) &&
        Objects.equals(this.isoCode, currencyJsonApi.isoCode) &&
        Objects.equals(this.shortName, currencyJsonApi.shortName) &&
        Objects.equals(this.name, currencyJsonApi.name) &&
        Objects.equals(this.position, currencyJsonApi.position) &&
        Objects.equals(this.isSystemDefault, currencyJsonApi.isSystemDefault) &&
        Objects.equals(this.taxFreeFrom, currencyJsonApi.taxFreeFrom) &&
        Objects.equals(this.customFields, currencyJsonApi.customFields) &&
        Objects.equals(this.itemRounding, currencyJsonApi.itemRounding) &&
        Objects.equals(this.totalRounding, currencyJsonApi.totalRounding) &&
        Objects.equals(this.createdAt, currencyJsonApi.createdAt) &&
        Objects.equals(this.updatedAt, currencyJsonApi.updatedAt) &&
        Objects.equals(this.translated, currencyJsonApi.translated);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, attributes, hashCodeNullable(relationships), links, meta, factor, symbol, isoCode, shortName, name, position, isSystemDefault, taxFreeFrom, customFields, itemRounding, totalRounding, createdAt, updatedAt, translated);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CurrencyJsonApi {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    factor: ").append(toIndentedString(factor)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    isoCode: ").append(toIndentedString(isoCode)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    isSystemDefault: ").append(toIndentedString(isSystemDefault)).append("\n");
    sb.append("    taxFreeFrom: ").append(toIndentedString(taxFreeFrom)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    itemRounding: ").append(toIndentedString(itemRounding)).append("\n");
    sb.append("    totalRounding: ").append(toIndentedString(totalRounding)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    translated: ").append(toIndentedString(translated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

