/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
  Customer.JSON_PROPERTY_ID,
  Customer.JSON_PROPERTY_GROUP_ID,
  Customer.JSON_PROPERTY_DEFAULT_PAYMENT_METHOD_ID,
  Customer.JSON_PROPERTY_SALES_CHANNEL_ID,
  Customer.JSON_PROPERTY_LANGUAGE_ID,
  Customer.JSON_PROPERTY_LAST_PAYMENT_METHOD_ID,
  Customer.JSON_PROPERTY_DEFAULT_BILLING_ADDRESS_ID,
  Customer.JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS_ID,
  Customer.JSON_PROPERTY_CUSTOMER_NUMBER,
  Customer.JSON_PROPERTY_SALUTATION_ID,
  Customer.JSON_PROPERTY_FIRST_NAME,
  Customer.JSON_PROPERTY_LAST_NAME,
  Customer.JSON_PROPERTY_COMPANY,
  Customer.JSON_PROPERTY_EMAIL,
  Customer.JSON_PROPERTY_TITLE,
  Customer.JSON_PROPERTY_VAT_IDS,
  Customer.JSON_PROPERTY_AFFILIATE_CODE,
  Customer.JSON_PROPERTY_CAMPAIGN_CODE,
  Customer.JSON_PROPERTY_ACTIVE,
  Customer.JSON_PROPERTY_DOUBLE_OPT_IN_REGISTRATION,
  Customer.JSON_PROPERTY_DOUBLE_OPT_IN_EMAIL_SENT_DATE,
  Customer.JSON_PROPERTY_DOUBLE_OPT_IN_CONFIRM_DATE,
  Customer.JSON_PROPERTY_HASH,
  Customer.JSON_PROPERTY_GUEST,
  Customer.JSON_PROPERTY_FIRST_LOGIN,
  Customer.JSON_PROPERTY_LAST_LOGIN,
  Customer.JSON_PROPERTY_BIRTHDAY,
  Customer.JSON_PROPERTY_LAST_ORDER_DATE,
  Customer.JSON_PROPERTY_ORDER_COUNT,
  Customer.JSON_PROPERTY_ORDER_TOTAL_AMOUNT,
  Customer.JSON_PROPERTY_REVIEW_COUNT,
  Customer.JSON_PROPERTY_CUSTOM_FIELDS,
  Customer.JSON_PROPERTY_TAG_IDS,
  Customer.JSON_PROPERTY_ACCOUNT_TYPE,
  Customer.JSON_PROPERTY_CREATED_BY_ID,
  Customer.JSON_PROPERTY_UPDATED_BY_ID,
  Customer.JSON_PROPERTY_CREATED_AT,
  Customer.JSON_PROPERTY_UPDATED_AT,
  Customer.JSON_PROPERTY_GROUP,
  Customer.JSON_PROPERTY_DEFAULT_PAYMENT_METHOD,
  Customer.JSON_PROPERTY_LANGUAGE,
  Customer.JSON_PROPERTY_LAST_PAYMENT_METHOD,
  Customer.JSON_PROPERTY_DEFAULT_BILLING_ADDRESS,
  Customer.JSON_PROPERTY_ACTIVE_BILLING_ADDRESS,
  Customer.JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS,
  Customer.JSON_PROPERTY_ACTIVE_SHIPPING_ADDRESS,
  Customer.JSON_PROPERTY_SALUTATION,
  Customer.JSON_PROPERTY_ADDRESSES,
  Customer.JSON_PROPERTY_TAGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class Customer {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_GROUP_ID = "groupId";
  private String groupId;

  public static final String JSON_PROPERTY_DEFAULT_PAYMENT_METHOD_ID = "defaultPaymentMethodId";
  private String defaultPaymentMethodId;

  public static final String JSON_PROPERTY_SALES_CHANNEL_ID = "salesChannelId";
  private String salesChannelId;

  public static final String JSON_PROPERTY_LANGUAGE_ID = "languageId";
  private String languageId;

  public static final String JSON_PROPERTY_LAST_PAYMENT_METHOD_ID = "lastPaymentMethodId";
  private String lastPaymentMethodId;

  public static final String JSON_PROPERTY_DEFAULT_BILLING_ADDRESS_ID = "defaultBillingAddressId";
  private String defaultBillingAddressId;

  public static final String JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS_ID = "defaultShippingAddressId";
  private String defaultShippingAddressId;

  public static final String JSON_PROPERTY_CUSTOMER_NUMBER = "customerNumber";
  private String customerNumber;

  public static final String JSON_PROPERTY_SALUTATION_ID = "salutationId";
  private String salutationId;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private String company;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_VAT_IDS = "vatIds";
  private List<String> vatIds = new ArrayList<>();

  public static final String JSON_PROPERTY_AFFILIATE_CODE = "affiliateCode";
  private String affiliateCode;

  public static final String JSON_PROPERTY_CAMPAIGN_CODE = "campaignCode";
  private String campaignCode;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_DOUBLE_OPT_IN_REGISTRATION = "doubleOptInRegistration";
  private Boolean doubleOptInRegistration;

  public static final String JSON_PROPERTY_DOUBLE_OPT_IN_EMAIL_SENT_DATE = "doubleOptInEmailSentDate";
  private OffsetDateTime doubleOptInEmailSentDate;

  public static final String JSON_PROPERTY_DOUBLE_OPT_IN_CONFIRM_DATE = "doubleOptInConfirmDate";
  private OffsetDateTime doubleOptInConfirmDate;

  public static final String JSON_PROPERTY_HASH = "hash";
  private String hash;

  public static final String JSON_PROPERTY_GUEST = "guest";
  private Boolean guest;

  public static final String JSON_PROPERTY_FIRST_LOGIN = "firstLogin";
  private OffsetDateTime firstLogin;

  public static final String JSON_PROPERTY_LAST_LOGIN = "lastLogin";
  private OffsetDateTime lastLogin;

  public static final String JSON_PROPERTY_BIRTHDAY = "birthday";
  private String birthday;

  public static final String JSON_PROPERTY_LAST_ORDER_DATE = "lastOrderDate";
  private OffsetDateTime lastOrderDate;

  public static final String JSON_PROPERTY_ORDER_COUNT = "orderCount";
  private Long orderCount;

  public static final String JSON_PROPERTY_ORDER_TOTAL_AMOUNT = "orderTotalAmount";
  private Float orderTotalAmount;

  public static final String JSON_PROPERTY_REVIEW_COUNT = "reviewCount";
  private Long reviewCount;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
  private Object customFields;

  public static final String JSON_PROPERTY_TAG_IDS = "tagIds";
  private List<String> tagIds = new ArrayList<>();

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private String accountType;

  public static final String JSON_PROPERTY_CREATED_BY_ID = "createdById";
  private String createdById;

  public static final String JSON_PROPERTY_UPDATED_BY_ID = "updatedById";
  private String updatedById;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_GROUP = "group";
  private CustomerGroup group;

  public static final String JSON_PROPERTY_DEFAULT_PAYMENT_METHOD = "defaultPaymentMethod";
  private PaymentMethod defaultPaymentMethod;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private Language language;

  public static final String JSON_PROPERTY_LAST_PAYMENT_METHOD = "lastPaymentMethod";
  private PaymentMethod lastPaymentMethod;

  public static final String JSON_PROPERTY_DEFAULT_BILLING_ADDRESS = "defaultBillingAddress";
  private CustomerAddress defaultBillingAddress;

  public static final String JSON_PROPERTY_ACTIVE_BILLING_ADDRESS = "activeBillingAddress";
  private CustomerAddress activeBillingAddress;

  public static final String JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS = "defaultShippingAddress";
  private CustomerAddress defaultShippingAddress;

  public static final String JSON_PROPERTY_ACTIVE_SHIPPING_ADDRESS = "activeShippingAddress";
  private CustomerAddress activeShippingAddress;

  public static final String JSON_PROPERTY_SALUTATION = "salutation";
  private Salutation salutation;

  public static final String JSON_PROPERTY_ADDRESSES = "addresses";
  private List<CustomerAddress> addresses = new ArrayList<>();

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<Tag> tags = new ArrayList<>();

  public Customer() {
  }

  @JsonCreator
  public Customer(
    @JsonProperty(JSON_PROPERTY_LAST_ORDER_DATE) OffsetDateTime lastOrderDate, 
    @JsonProperty(JSON_PROPERTY_ORDER_COUNT) Long orderCount, 
    @JsonProperty(JSON_PROPERTY_ORDER_TOTAL_AMOUNT) Float orderTotalAmount, 
    @JsonProperty(JSON_PROPERTY_REVIEW_COUNT) Long reviewCount, 
    @JsonProperty(JSON_PROPERTY_TAG_IDS) List<String> tagIds, 
    @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt, 
    @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
  ) {
    this();
    this.lastOrderDate = lastOrderDate;
    this.orderCount = orderCount;
    this.orderTotalAmount = orderTotalAmount;
    this.reviewCount = reviewCount;
    this.tagIds = tagIds;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  public Customer id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Customer groupId(String groupId) {
    
    this.groupId = groupId;
    return this;
  }

   /**
   * Get groupId
   * @return groupId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGroupId() {
    return groupId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }


  public Customer defaultPaymentMethodId(String defaultPaymentMethodId) {
    
    this.defaultPaymentMethodId = defaultPaymentMethodId;
    return this;
  }

   /**
   * Get defaultPaymentMethodId
   * @return defaultPaymentMethodId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DEFAULT_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDefaultPaymentMethodId() {
    return defaultPaymentMethodId;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDefaultPaymentMethodId(String defaultPaymentMethodId) {
    this.defaultPaymentMethodId = defaultPaymentMethodId;
  }


  public Customer salesChannelId(String salesChannelId) {
    
    this.salesChannelId = salesChannelId;
    return this;
  }

   /**
   * Get salesChannelId
   * @return salesChannelId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalesChannelId() {
    return salesChannelId;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannelId(String salesChannelId) {
    this.salesChannelId = salesChannelId;
  }


  public Customer languageId(String languageId) {
    
    this.languageId = languageId;
    return this;
  }

   /**
   * Get languageId
   * @return languageId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LANGUAGE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLanguageId() {
    return languageId;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLanguageId(String languageId) {
    this.languageId = languageId;
  }


  public Customer lastPaymentMethodId(String lastPaymentMethodId) {
    
    this.lastPaymentMethodId = lastPaymentMethodId;
    return this;
  }

   /**
   * Get lastPaymentMethodId
   * @return lastPaymentMethodId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastPaymentMethodId() {
    return lastPaymentMethodId;
  }


  @JsonProperty(JSON_PROPERTY_LAST_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastPaymentMethodId(String lastPaymentMethodId) {
    this.lastPaymentMethodId = lastPaymentMethodId;
  }


  public Customer defaultBillingAddressId(String defaultBillingAddressId) {
    
    this.defaultBillingAddressId = defaultBillingAddressId;
    return this;
  }

   /**
   * Get defaultBillingAddressId
   * @return defaultBillingAddressId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DEFAULT_BILLING_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDefaultBillingAddressId() {
    return defaultBillingAddressId;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_BILLING_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDefaultBillingAddressId(String defaultBillingAddressId) {
    this.defaultBillingAddressId = defaultBillingAddressId;
  }


  public Customer defaultShippingAddressId(String defaultShippingAddressId) {
    
    this.defaultShippingAddressId = defaultShippingAddressId;
    return this;
  }

   /**
   * Get defaultShippingAddressId
   * @return defaultShippingAddressId
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDefaultShippingAddressId() {
    return defaultShippingAddressId;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDefaultShippingAddressId(String defaultShippingAddressId) {
    this.defaultShippingAddressId = defaultShippingAddressId;
  }


  public Customer customerNumber(String customerNumber) {
    
    this.customerNumber = customerNumber;
    return this;
  }

   /**
   * Get customerNumber
   * @return customerNumber
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CUSTOMER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCustomerNumber() {
    return customerNumber;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCustomerNumber(String customerNumber) {
    this.customerNumber = customerNumber;
  }


  public Customer salutationId(String salutationId) {
    
    this.salutationId = salutationId;
    return this;
  }

   /**
   * Get salutationId
   * @return salutationId
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSalutationId() {
    return salutationId;
  }


  @JsonProperty(JSON_PROPERTY_SALUTATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalutationId(String salutationId) {
    this.salutationId = salutationId;
  }


  public Customer firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public Customer lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public Customer company(String company) {
    
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompany() {
    return company;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompany(String company) {
    this.company = company;
  }


  public Customer email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public Customer title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public Customer vatIds(List<String> vatIds) {
    
    this.vatIds = vatIds;
    return this;
  }

  public Customer addVatIdsItem(String vatIdsItem) {
    if (this.vatIds == null) {
      this.vatIds = new ArrayList<>();
    }
    this.vatIds.add(vatIdsItem);
    return this;
  }

   /**
   * Get vatIds
   * @return vatIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VAT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getVatIds() {
    return vatIds;
  }


  @JsonProperty(JSON_PROPERTY_VAT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVatIds(List<String> vatIds) {
    this.vatIds = vatIds;
  }


  public Customer affiliateCode(String affiliateCode) {
    
    this.affiliateCode = affiliateCode;
    return this;
  }

   /**
   * Get affiliateCode
   * @return affiliateCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAffiliateCode() {
    return affiliateCode;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffiliateCode(String affiliateCode) {
    this.affiliateCode = affiliateCode;
  }


  public Customer campaignCode(String campaignCode) {
    
    this.campaignCode = campaignCode;
    return this;
  }

   /**
   * Get campaignCode
   * @return campaignCode
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCampaignCode() {
    return campaignCode;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignCode(String campaignCode) {
    this.campaignCode = campaignCode;
  }


  public Customer active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public Customer doubleOptInRegistration(Boolean doubleOptInRegistration) {
    
    this.doubleOptInRegistration = doubleOptInRegistration;
    return this;
  }

   /**
   * Get doubleOptInRegistration
   * @return doubleOptInRegistration
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOUBLE_OPT_IN_REGISTRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDoubleOptInRegistration() {
    return doubleOptInRegistration;
  }


  @JsonProperty(JSON_PROPERTY_DOUBLE_OPT_IN_REGISTRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDoubleOptInRegistration(Boolean doubleOptInRegistration) {
    this.doubleOptInRegistration = doubleOptInRegistration;
  }


  public Customer doubleOptInEmailSentDate(OffsetDateTime doubleOptInEmailSentDate) {
    
    this.doubleOptInEmailSentDate = doubleOptInEmailSentDate;
    return this;
  }

   /**
   * Get doubleOptInEmailSentDate
   * @return doubleOptInEmailSentDate
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOUBLE_OPT_IN_EMAIL_SENT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDoubleOptInEmailSentDate() {
    return doubleOptInEmailSentDate;
  }


  @JsonProperty(JSON_PROPERTY_DOUBLE_OPT_IN_EMAIL_SENT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDoubleOptInEmailSentDate(OffsetDateTime doubleOptInEmailSentDate) {
    this.doubleOptInEmailSentDate = doubleOptInEmailSentDate;
  }


  public Customer doubleOptInConfirmDate(OffsetDateTime doubleOptInConfirmDate) {
    
    this.doubleOptInConfirmDate = doubleOptInConfirmDate;
    return this;
  }

   /**
   * Get doubleOptInConfirmDate
   * @return doubleOptInConfirmDate
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOUBLE_OPT_IN_CONFIRM_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDoubleOptInConfirmDate() {
    return doubleOptInConfirmDate;
  }


  @JsonProperty(JSON_PROPERTY_DOUBLE_OPT_IN_CONFIRM_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDoubleOptInConfirmDate(OffsetDateTime doubleOptInConfirmDate) {
    this.doubleOptInConfirmDate = doubleOptInConfirmDate;
  }


  public Customer hash(String hash) {
    
    this.hash = hash;
    return this;
  }

   /**
   * Get hash
   * @return hash
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHash() {
    return hash;
  }


  @JsonProperty(JSON_PROPERTY_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHash(String hash) {
    this.hash = hash;
  }


  public Customer guest(Boolean guest) {
    
    this.guest = guest;
    return this;
  }

   /**
   * Get guest
   * @return guest
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGuest() {
    return guest;
  }


  @JsonProperty(JSON_PROPERTY_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuest(Boolean guest) {
    this.guest = guest;
  }


  public Customer firstLogin(OffsetDateTime firstLogin) {
    
    this.firstLogin = firstLogin;
    return this;
  }

   /**
   * Get firstLogin
   * @return firstLogin
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIRST_LOGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getFirstLogin() {
    return firstLogin;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_LOGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstLogin(OffsetDateTime firstLogin) {
    this.firstLogin = firstLogin;
  }


  public Customer lastLogin(OffsetDateTime lastLogin) {
    
    this.lastLogin = lastLogin;
    return this;
  }

   /**
   * Get lastLogin
   * @return lastLogin
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_LOGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastLogin() {
    return lastLogin;
  }


  @JsonProperty(JSON_PROPERTY_LAST_LOGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastLogin(OffsetDateTime lastLogin) {
    this.lastLogin = lastLogin;
  }


  public Customer birthday(String birthday) {
    
    this.birthday = birthday;
    return this;
  }

   /**
   * Get birthday
   * @return birthday
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BIRTHDAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBirthday() {
    return birthday;
  }


  @JsonProperty(JSON_PROPERTY_BIRTHDAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthday(String birthday) {
    this.birthday = birthday;
  }


   /**
   * Get lastOrderDate
   * @return lastOrderDate
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_ORDER_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getLastOrderDate() {
    return lastOrderDate;
  }




   /**
   * Get orderCount
   * @return orderCount
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getOrderCount() {
    return orderCount;
  }




   /**
   * Get orderTotalAmount
   * @return orderTotalAmount
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getOrderTotalAmount() {
    return orderTotalAmount;
  }




   /**
   * Get reviewCount
   * @return reviewCount
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REVIEW_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getReviewCount() {
    return reviewCount;
  }




  public Customer customFields(Object customFields) {
    
    this.customFields = customFields;
    return this;
  }

   /**
   * Get customFields
   * @return customFields
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(Object customFields) {
    this.customFields = customFields;
  }


   /**
   * Get tagIds
   * @return tagIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAG_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTagIds() {
    return tagIds;
  }




  public Customer accountType(String accountType) {
    
    this.accountType = accountType;
    return this;
  }

   /**
   * Get accountType
   * @return accountType
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountType() {
    return accountType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public Customer createdById(String createdById) {
    
    this.createdById = createdById;
    return this;
  }

   /**
   * Get createdById
   * @return createdById
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreatedById() {
    return createdById;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedById(String createdById) {
    this.createdById = createdById;
  }


  public Customer updatedById(String updatedById) {
    
    this.updatedById = updatedById;
    return this;
  }

   /**
   * Get updatedById
   * @return updatedById
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedById() {
    return updatedById;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_BY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedById(String updatedById) {
    this.updatedById = updatedById;
  }


   /**
   * Get createdAt
   * @return createdAt
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }




  public Customer group(CustomerGroup group) {
    
    this.group = group;
    return this;
  }

   /**
   * Get group
   * @return group
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomerGroup getGroup() {
    return group;
  }


  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroup(CustomerGroup group) {
    this.group = group;
  }


  public Customer defaultPaymentMethod(PaymentMethod defaultPaymentMethod) {
    
    this.defaultPaymentMethod = defaultPaymentMethod;
    return this;
  }

   /**
   * Get defaultPaymentMethod
   * @return defaultPaymentMethod
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentMethod getDefaultPaymentMethod() {
    return defaultPaymentMethod;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultPaymentMethod(PaymentMethod defaultPaymentMethod) {
    this.defaultPaymentMethod = defaultPaymentMethod;
  }


  public Customer language(Language language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Language getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(Language language) {
    this.language = language;
  }


  public Customer lastPaymentMethod(PaymentMethod lastPaymentMethod) {
    
    this.lastPaymentMethod = lastPaymentMethod;
    return this;
  }

   /**
   * Get lastPaymentMethod
   * @return lastPaymentMethod
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentMethod getLastPaymentMethod() {
    return lastPaymentMethod;
  }


  @JsonProperty(JSON_PROPERTY_LAST_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastPaymentMethod(PaymentMethod lastPaymentMethod) {
    this.lastPaymentMethod = lastPaymentMethod;
  }


  public Customer defaultBillingAddress(CustomerAddress defaultBillingAddress) {
    
    this.defaultBillingAddress = defaultBillingAddress;
    return this;
  }

   /**
   * Get defaultBillingAddress
   * @return defaultBillingAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomerAddress getDefaultBillingAddress() {
    return defaultBillingAddress;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultBillingAddress(CustomerAddress defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }


  public Customer activeBillingAddress(CustomerAddress activeBillingAddress) {
    
    this.activeBillingAddress = activeBillingAddress;
    return this;
  }

   /**
   * Get activeBillingAddress
   * @return activeBillingAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomerAddress getActiveBillingAddress() {
    return activeBillingAddress;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveBillingAddress(CustomerAddress activeBillingAddress) {
    this.activeBillingAddress = activeBillingAddress;
  }


  public Customer defaultShippingAddress(CustomerAddress defaultShippingAddress) {
    
    this.defaultShippingAddress = defaultShippingAddress;
    return this;
  }

   /**
   * Get defaultShippingAddress
   * @return defaultShippingAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomerAddress getDefaultShippingAddress() {
    return defaultShippingAddress;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_SHIPPING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultShippingAddress(CustomerAddress defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }


  public Customer activeShippingAddress(CustomerAddress activeShippingAddress) {
    
    this.activeShippingAddress = activeShippingAddress;
    return this;
  }

   /**
   * Get activeShippingAddress
   * @return activeShippingAddress
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE_SHIPPING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomerAddress getActiveShippingAddress() {
    return activeShippingAddress;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_SHIPPING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveShippingAddress(CustomerAddress activeShippingAddress) {
    this.activeShippingAddress = activeShippingAddress;
  }


  public Customer salutation(Salutation salutation) {
    
    this.salutation = salutation;
    return this;
  }

   /**
   * Get salutation
   * @return salutation
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SALUTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Salutation getSalutation() {
    return salutation;
  }


  @JsonProperty(JSON_PROPERTY_SALUTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalutation(Salutation salutation) {
    this.salutation = salutation;
  }


  public Customer addresses(List<CustomerAddress> addresses) {
    
    this.addresses = addresses;
    return this;
  }

  public Customer addAddressesItem(CustomerAddress addressesItem) {
    if (this.addresses == null) {
      this.addresses = new ArrayList<>();
    }
    this.addresses.add(addressesItem);
    return this;
  }

   /**
   * Get addresses
   * @return addresses
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CustomerAddress> getAddresses() {
    return addresses;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddresses(List<CustomerAddress> addresses) {
    this.addresses = addresses;
  }


  public Customer tags(List<Tag> tags) {
    
    this.tags = tags;
    return this;
  }

  public Customer addTagsItem(Tag tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Tag> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<Tag> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Customer customer = (Customer) o;
    return Objects.equals(this.id, customer.id) &&
        Objects.equals(this.groupId, customer.groupId) &&
        Objects.equals(this.defaultPaymentMethodId, customer.defaultPaymentMethodId) &&
        Objects.equals(this.salesChannelId, customer.salesChannelId) &&
        Objects.equals(this.languageId, customer.languageId) &&
        Objects.equals(this.lastPaymentMethodId, customer.lastPaymentMethodId) &&
        Objects.equals(this.defaultBillingAddressId, customer.defaultBillingAddressId) &&
        Objects.equals(this.defaultShippingAddressId, customer.defaultShippingAddressId) &&
        Objects.equals(this.customerNumber, customer.customerNumber) &&
        Objects.equals(this.salutationId, customer.salutationId) &&
        Objects.equals(this.firstName, customer.firstName) &&
        Objects.equals(this.lastName, customer.lastName) &&
        Objects.equals(this.company, customer.company) &&
        Objects.equals(this.email, customer.email) &&
        Objects.equals(this.title, customer.title) &&
        Objects.equals(this.vatIds, customer.vatIds) &&
        Objects.equals(this.affiliateCode, customer.affiliateCode) &&
        Objects.equals(this.campaignCode, customer.campaignCode) &&
        Objects.equals(this.active, customer.active) &&
        Objects.equals(this.doubleOptInRegistration, customer.doubleOptInRegistration) &&
        Objects.equals(this.doubleOptInEmailSentDate, customer.doubleOptInEmailSentDate) &&
        Objects.equals(this.doubleOptInConfirmDate, customer.doubleOptInConfirmDate) &&
        Objects.equals(this.hash, customer.hash) &&
        Objects.equals(this.guest, customer.guest) &&
        Objects.equals(this.firstLogin, customer.firstLogin) &&
        Objects.equals(this.lastLogin, customer.lastLogin) &&
        Objects.equals(this.birthday, customer.birthday) &&
        Objects.equals(this.lastOrderDate, customer.lastOrderDate) &&
        Objects.equals(this.orderCount, customer.orderCount) &&
        Objects.equals(this.orderTotalAmount, customer.orderTotalAmount) &&
        Objects.equals(this.reviewCount, customer.reviewCount) &&
        Objects.equals(this.customFields, customer.customFields) &&
        Objects.equals(this.tagIds, customer.tagIds) &&
        Objects.equals(this.accountType, customer.accountType) &&
        Objects.equals(this.createdById, customer.createdById) &&
        Objects.equals(this.updatedById, customer.updatedById) &&
        Objects.equals(this.createdAt, customer.createdAt) &&
        Objects.equals(this.updatedAt, customer.updatedAt) &&
        Objects.equals(this.group, customer.group) &&
        Objects.equals(this.defaultPaymentMethod, customer.defaultPaymentMethod) &&
        Objects.equals(this.language, customer.language) &&
        Objects.equals(this.lastPaymentMethod, customer.lastPaymentMethod) &&
        Objects.equals(this.defaultBillingAddress, customer.defaultBillingAddress) &&
        Objects.equals(this.activeBillingAddress, customer.activeBillingAddress) &&
        Objects.equals(this.defaultShippingAddress, customer.defaultShippingAddress) &&
        Objects.equals(this.activeShippingAddress, customer.activeShippingAddress) &&
        Objects.equals(this.salutation, customer.salutation) &&
        Objects.equals(this.addresses, customer.addresses) &&
        Objects.equals(this.tags, customer.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupId, defaultPaymentMethodId, salesChannelId, languageId, lastPaymentMethodId, defaultBillingAddressId, defaultShippingAddressId, customerNumber, salutationId, firstName, lastName, company, email, title, vatIds, affiliateCode, campaignCode, active, doubleOptInRegistration, doubleOptInEmailSentDate, doubleOptInConfirmDate, hash, guest, firstLogin, lastLogin, birthday, lastOrderDate, orderCount, orderTotalAmount, reviewCount, customFields, tagIds, accountType, createdById, updatedById, createdAt, updatedAt, group, defaultPaymentMethod, language, lastPaymentMethod, defaultBillingAddress, activeBillingAddress, defaultShippingAddress, activeShippingAddress, salutation, addresses, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Customer {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    defaultPaymentMethodId: ").append(toIndentedString(defaultPaymentMethodId)).append("\n");
    sb.append("    salesChannelId: ").append(toIndentedString(salesChannelId)).append("\n");
    sb.append("    languageId: ").append(toIndentedString(languageId)).append("\n");
    sb.append("    lastPaymentMethodId: ").append(toIndentedString(lastPaymentMethodId)).append("\n");
    sb.append("    defaultBillingAddressId: ").append(toIndentedString(defaultBillingAddressId)).append("\n");
    sb.append("    defaultShippingAddressId: ").append(toIndentedString(defaultShippingAddressId)).append("\n");
    sb.append("    customerNumber: ").append(toIndentedString(customerNumber)).append("\n");
    sb.append("    salutationId: ").append(toIndentedString(salutationId)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    vatIds: ").append(toIndentedString(vatIds)).append("\n");
    sb.append("    affiliateCode: ").append(toIndentedString(affiliateCode)).append("\n");
    sb.append("    campaignCode: ").append(toIndentedString(campaignCode)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    doubleOptInRegistration: ").append(toIndentedString(doubleOptInRegistration)).append("\n");
    sb.append("    doubleOptInEmailSentDate: ").append(toIndentedString(doubleOptInEmailSentDate)).append("\n");
    sb.append("    doubleOptInConfirmDate: ").append(toIndentedString(doubleOptInConfirmDate)).append("\n");
    sb.append("    hash: ").append(toIndentedString(hash)).append("\n");
    sb.append("    guest: ").append(toIndentedString(guest)).append("\n");
    sb.append("    firstLogin: ").append(toIndentedString(firstLogin)).append("\n");
    sb.append("    lastLogin: ").append(toIndentedString(lastLogin)).append("\n");
    sb.append("    birthday: ").append(toIndentedString(birthday)).append("\n");
    sb.append("    lastOrderDate: ").append(toIndentedString(lastOrderDate)).append("\n");
    sb.append("    orderCount: ").append(toIndentedString(orderCount)).append("\n");
    sb.append("    orderTotalAmount: ").append(toIndentedString(orderTotalAmount)).append("\n");
    sb.append("    reviewCount: ").append(toIndentedString(reviewCount)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    tagIds: ").append(toIndentedString(tagIds)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    createdById: ").append(toIndentedString(createdById)).append("\n");
    sb.append("    updatedById: ").append(toIndentedString(updatedById)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    defaultPaymentMethod: ").append(toIndentedString(defaultPaymentMethod)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    lastPaymentMethod: ").append(toIndentedString(lastPaymentMethod)).append("\n");
    sb.append("    defaultBillingAddress: ").append(toIndentedString(defaultBillingAddress)).append("\n");
    sb.append("    activeBillingAddress: ").append(toIndentedString(activeBillingAddress)).append("\n");
    sb.append("    defaultShippingAddress: ").append(toIndentedString(defaultShippingAddress)).append("\n");
    sb.append("    activeShippingAddress: ").append(toIndentedString(activeShippingAddress)).append("\n");
    sb.append("    salutation: ").append(toIndentedString(salutation)).append("\n");
    sb.append("    addresses: ").append(toIndentedString(addresses)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

