/*
 * Shopware Store API
 * This endpoint reference contains an overview of all endpoints comprising the Shopware Store API
 *
 * The version of the OpenAPI document: 6.5.7.3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.codebarista.shopware.model.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Added since version: 6.0.0.0
 */
@JsonPropertyOrder({
        Document.JSON_PROPERTY_ID,
        Document.JSON_PROPERTY_DOCUMENT_TYPE_ID,
        Document.JSON_PROPERTY_FILE_TYPE,
        Document.JSON_PROPERTY_REFERENCED_DOCUMENT_ID,
        Document.JSON_PROPERTY_ORDER_ID,
        Document.JSON_PROPERTY_DOCUMENT_MEDIA_FILE_ID,
        Document.JSON_PROPERTY_ORDER_VERSION_ID,
        Document.JSON_PROPERTY_CONFIG,
        Document.JSON_PROPERTY_SENT,
        Document.JSON_PROPERTY_STATIC,
        Document.JSON_PROPERTY_DEEP_LINK_CODE,
        Document.JSON_PROPERTY_DOCUMENT_NUMBER,
        Document.JSON_PROPERTY_CUSTOM_FIELDS,
        Document.JSON_PROPERTY_CREATED_AT,
        Document.JSON_PROPERTY_UPDATED_AT,
        Document.JSON_PROPERTY_DOCUMENT_TYPE,
        Document.JSON_PROPERTY_ORDER,
        Document.JSON_PROPERTY_REFERENCED_DOCUMENT,
        Document.JSON_PROPERTY_DEPENDENT_DOCUMENTS,
        Document.JSON_PROPERTY_DOCUMENT_MEDIA_FILE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-10T11:26:02.541008353+02:00[Europe/Berlin]", comments = "Generator version: 7.5.0")
public class Document {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_DOCUMENT_TYPE_ID = "documentTypeId";
    private String documentTypeId;

    public static final String JSON_PROPERTY_FILE_TYPE = "fileType";
    private String fileType;

    public static final String JSON_PROPERTY_REFERENCED_DOCUMENT_ID = "referencedDocumentId";
    private String referencedDocumentId;

    public static final String JSON_PROPERTY_ORDER_ID = "orderId";
    private String orderId;

    public static final String JSON_PROPERTY_DOCUMENT_MEDIA_FILE_ID = "documentMediaFileId";
    private String documentMediaFileId;

    public static final String JSON_PROPERTY_ORDER_VERSION_ID = "orderVersionId";
    private String orderVersionId;

    public static final String JSON_PROPERTY_CONFIG = "config";
    @JsonDeserialize(using = DocumentConfigDeserializer.class)
    private DocumentConfig config;

    public static final String JSON_PROPERTY_SENT = "sent";
    private Boolean sent;

    public static final String JSON_PROPERTY_STATIC = "static";
    private Boolean _static;

    public static final String JSON_PROPERTY_DEEP_LINK_CODE = "deepLinkCode";
    private String deepLinkCode;

    public static final String JSON_PROPERTY_DOCUMENT_NUMBER = "documentNumber";
    private String documentNumber;

    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Object customFields;

    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;

    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;

    public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
    private DocumentType documentType;

    public static final String JSON_PROPERTY_ORDER = "order";
    private Order order;

    public static final String JSON_PROPERTY_REFERENCED_DOCUMENT = "referencedDocument";
    private Document referencedDocument;

    public static final String JSON_PROPERTY_DEPENDENT_DOCUMENTS = "dependentDocuments";
    private List<Document> dependentDocuments = new ArrayList<>();

    public static final String JSON_PROPERTY_DOCUMENT_MEDIA_FILE = "documentMediaFile";
    private Media documentMediaFile;

    public Document() {
    }

    @JsonCreator
    public Document(
            @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt,
            @JsonProperty(JSON_PROPERTY_UPDATED_AT) OffsetDateTime updatedAt
    ) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Document id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }


    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }


    public Document documentTypeId(String documentTypeId) {

        this.documentTypeId = documentTypeId;
        return this;
    }

    /**
     * Get documentTypeId
     *
     * @return documentTypeId
     **/
    @jakarta.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDocumentTypeId() {
        return documentTypeId;
    }


    @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }


    public Document fileType(String fileType) {

        this.fileType = fileType;
        return this;
    }

    /**
     * Get fileType
     *
     * @return fileType
     **/
    @jakarta.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_FILE_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getFileType() {
        return fileType;
    }


    @JsonProperty(JSON_PROPERTY_FILE_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }


    public Document referencedDocumentId(String referencedDocumentId) {

        this.referencedDocumentId = referencedDocumentId;
        return this;
    }

    /**
     * Get referencedDocumentId
     *
     * @return referencedDocumentId
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_REFERENCED_DOCUMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReferencedDocumentId() {
        return referencedDocumentId;
    }


    @JsonProperty(JSON_PROPERTY_REFERENCED_DOCUMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReferencedDocumentId(String referencedDocumentId) {
        this.referencedDocumentId = referencedDocumentId;
    }


    public Document orderId(String orderId) {

        this.orderId = orderId;
        return this;
    }

    /**
     * Get orderId
     *
     * @return orderId
     **/
    @jakarta.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_ORDER_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getOrderId() {
        return orderId;
    }


    @JsonProperty(JSON_PROPERTY_ORDER_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }


    public Document documentMediaFileId(String documentMediaFileId) {

        this.documentMediaFileId = documentMediaFileId;
        return this;
    }

    /**
     * Get documentMediaFileId
     *
     * @return documentMediaFileId
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_DOCUMENT_MEDIA_FILE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDocumentMediaFileId() {
        return documentMediaFileId;
    }


    @JsonProperty(JSON_PROPERTY_DOCUMENT_MEDIA_FILE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentMediaFileId(String documentMediaFileId) {
        this.documentMediaFileId = documentMediaFileId;
    }


    public Document orderVersionId(String orderVersionId) {

        this.orderVersionId = orderVersionId;
        return this;
    }

    /**
     * Get orderVersionId
     *
     * @return orderVersionId
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_ORDER_VERSION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrderVersionId() {
        return orderVersionId;
    }


    @JsonProperty(JSON_PROPERTY_ORDER_VERSION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrderVersionId(String orderVersionId) {
        this.orderVersionId = orderVersionId;
    }


    public Document config(DocumentConfig config) {
        this.config = config;
        return this;
    }

    /**
     * Get config
     *
     * @return config
     **/
    @jakarta.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_CONFIG)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public DocumentConfig getConfig() {
        return config;
    }


    @JsonProperty(JSON_PROPERTY_CONFIG)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setConfig(DocumentConfig config) {
        this.config = config;
    }


    public Document sent(Boolean sent) {

        this.sent = sent;
        return this;
    }

    /**
     * Get sent
     *
     * @return sent
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_SENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSent() {
        return sent;
    }


    @JsonProperty(JSON_PROPERTY_SENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSent(Boolean sent) {
        this.sent = sent;
    }


    public Document _static(Boolean _static) {

        this._static = _static;
        return this;
    }

    /**
     * Get _static
     *
     * @return _static
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_STATIC)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getStatic() {
        return _static;
    }


    @JsonProperty(JSON_PROPERTY_STATIC)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatic(Boolean _static) {
        this._static = _static;
    }


    public Document deepLinkCode(String deepLinkCode) {

        this.deepLinkCode = deepLinkCode;
        return this;
    }

    /**
     * Get deepLinkCode
     *
     * @return deepLinkCode
     **/
    @jakarta.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_DEEP_LINK_CODE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDeepLinkCode() {
        return deepLinkCode;
    }


    @JsonProperty(JSON_PROPERTY_DEEP_LINK_CODE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDeepLinkCode(String deepLinkCode) {
        this.deepLinkCode = deepLinkCode;
    }


    public Document documentNumber(String documentNumber) {

        this.documentNumber = documentNumber;
        return this;
    }

    /**
     * Get documentNumber
     *
     * @return documentNumber
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_DOCUMENT_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDocumentNumber() {
        return documentNumber;
    }


    @JsonProperty(JSON_PROPERTY_DOCUMENT_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }


    public Document customFields(Object customFields) {

        this.customFields = customFields;
        return this;
    }

    /**
     * Get customFields
     *
     * @return customFields
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getCustomFields() {
        return customFields;
    }


    @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Object customFields) {
        this.customFields = customFields;
    }


    /**
     * Get createdAt
     *
     * @return createdAt
     **/
    @jakarta.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_CREATED_AT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }


    /**
     * Get updatedAt
     *
     * @return updatedAt
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_UPDATED_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }


    public Document documentType(DocumentType documentType) {

        this.documentType = documentType;
        return this;
    }

    /**
     * Get documentType
     *
     * @return documentType
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DocumentType getDocumentType() {
        return documentType;
    }


    @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }


    public Document order(Order order) {

        this.order = order;
        return this;
    }

    /**
     * Get order
     *
     * @return order
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_ORDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Order getOrder() {
        return order;
    }


    @JsonProperty(JSON_PROPERTY_ORDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(Order order) {
        this.order = order;
    }


    public Document referencedDocument(Document referencedDocument) {

        this.referencedDocument = referencedDocument;
        return this;
    }

    /**
     * Get referencedDocument
     *
     * @return referencedDocument
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_REFERENCED_DOCUMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Document getReferencedDocument() {
        return referencedDocument;
    }


    @JsonProperty(JSON_PROPERTY_REFERENCED_DOCUMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReferencedDocument(Document referencedDocument) {
        this.referencedDocument = referencedDocument;
    }


    public Document dependentDocuments(List<Document> dependentDocuments) {

        this.dependentDocuments = dependentDocuments;
        return this;
    }

    public Document addDependentDocumentsItem(Document dependentDocumentsItem) {
        if (this.dependentDocuments == null) {
            this.dependentDocuments = new ArrayList<>();
        }
        this.dependentDocuments.add(dependentDocumentsItem);
        return this;
    }

    /**
     * Get dependentDocuments
     *
     * @return dependentDocuments
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_DEPENDENT_DOCUMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Document> getDependentDocuments() {
        return dependentDocuments;
    }


    @JsonProperty(JSON_PROPERTY_DEPENDENT_DOCUMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDependentDocuments(List<Document> dependentDocuments) {
        this.dependentDocuments = dependentDocuments;
    }


    public Document documentMediaFile(Media documentMediaFile) {

        this.documentMediaFile = documentMediaFile;
        return this;
    }

    /**
     * Get documentMediaFile
     *
     * @return documentMediaFile
     **/
    @jakarta.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_DOCUMENT_MEDIA_FILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Media getDocumentMediaFile() {
        return documentMediaFile;
    }


    @JsonProperty(JSON_PROPERTY_DOCUMENT_MEDIA_FILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentMediaFile(Media documentMediaFile) {
        this.documentMediaFile = documentMediaFile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document) o;
        return Objects.equals(this.id, document.id) &&
                Objects.equals(this.documentTypeId, document.documentTypeId) &&
                Objects.equals(this.fileType, document.fileType) &&
                Objects.equals(this.referencedDocumentId, document.referencedDocumentId) &&
                Objects.equals(this.orderId, document.orderId) &&
                Objects.equals(this.documentMediaFileId, document.documentMediaFileId) &&
                Objects.equals(this.orderVersionId, document.orderVersionId) &&
                Objects.equals(this.config, document.config) &&
                Objects.equals(this.sent, document.sent) &&
                Objects.equals(this._static, document._static) &&
                Objects.equals(this.deepLinkCode, document.deepLinkCode) &&
                Objects.equals(this.documentNumber, document.documentNumber) &&
                Objects.equals(this.customFields, document.customFields) &&
                Objects.equals(this.createdAt, document.createdAt) &&
                Objects.equals(this.updatedAt, document.updatedAt) &&
                Objects.equals(this.documentType, document.documentType) &&
                Objects.equals(this.order, document.order) &&
                Objects.equals(this.referencedDocument, document.referencedDocument) &&
                Objects.equals(this.dependentDocuments, document.dependentDocuments) &&
                Objects.equals(this.documentMediaFile, document.documentMediaFile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, documentTypeId, fileType, referencedDocumentId, orderId, documentMediaFileId, orderVersionId, config, sent, _static, deepLinkCode, documentNumber, customFields, createdAt, updatedAt, documentType, order, referencedDocument, dependentDocuments, documentMediaFile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    documentTypeId: ").append(toIndentedString(documentTypeId)).append("\n");
        sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
        sb.append("    referencedDocumentId: ").append(toIndentedString(referencedDocumentId)).append("\n");
        sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
        sb.append("    documentMediaFileId: ").append(toIndentedString(documentMediaFileId)).append("\n");
        sb.append("    orderVersionId: ").append(toIndentedString(orderVersionId)).append("\n");
        sb.append("    config: ").append(toIndentedString(config)).append("\n");
        sb.append("    sent: ").append(toIndentedString(sent)).append("\n");
        sb.append("    _static: ").append(toIndentedString(_static)).append("\n");
        sb.append("    deepLinkCode: ").append(toIndentedString(deepLinkCode)).append("\n");
        sb.append("    documentNumber: ").append(toIndentedString(documentNumber)).append("\n");
        sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
        sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
        sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
        sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
        sb.append("    order: ").append(toIndentedString(order)).append("\n");
        sb.append("    referencedDocument: ").append(toIndentedString(referencedDocument)).append("\n");
        sb.append("    dependentDocuments: ").append(toIndentedString(dependentDocuments)).append("\n");
        sb.append("    documentMediaFile: ").append(toIndentedString(documentMediaFile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
